/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.test.api.score.stream;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Map;
import org.optaplanner.core.api.score.constraint.ConstraintMatchTotal;
import org.optaplanner.core.impl.score.stream.common.AbstractConstraint;
import org.optaplanner.core.impl.score.stream.common.ScoreImpactType;
import org.optaplanner.test.api.score.stream.AbstractAssertion;
import org.optaplanner.test.api.score.stream.SingleConstraintVerifier;

public final class SingleConstraintAssertion<Solution_>
extends AbstractAssertion<Solution_, SingleConstraintAssertion<Solution_>, SingleConstraintVerifier<Solution_>> {
    private final Map<String, ConstraintMatchTotal> constraintMatchTotalMap;

    SingleConstraintAssertion(SingleConstraintVerifier<Solution_> singleConstraintVerifier, Map<String, ConstraintMatchTotal> constraintMatchTotalMap) {
        super(singleConstraintVerifier);
        this.constraintMatchTotalMap = Collections.unmodifiableMap(constraintMatchTotalMap);
    }

    private Number getImpact() {
        return this.constraintMatchTotalMap.values().stream().mapToInt(ConstraintMatchTotal::getConstraintMatchCount).sum();
    }

    private static void assertCorrectMatchWeight(Number matchWeightTotal) {
        if (matchWeightTotal.doubleValue() <= 0.0) {
            throw new IllegalArgumentException("Expected a positive match weight, given (" + matchWeightTotal + ").");
        }
    }

    private void assertImpact(ScoreImpactType scoreImpactType, Number weight, String message) {
        boolean isCorrectImpactType;
        Number impact = this.getImpact();
        AbstractConstraint constraint = (AbstractConstraint)((SingleConstraintVerifier)this.getParentConstraintVerifier()).getConstraint();
        boolean bl = isCorrectImpactType = scoreImpactType == null || scoreImpactType == constraint.getScoreImpactType();
        if (isCorrectImpactType && weight.equals(impact)) {
            return;
        }
        String constraintId = constraint.getConstraintId();
        String assertionMessage = SingleConstraintAssertion.getAssertionErrorMessage(scoreImpactType, weight, constraint.getScoreImpactType(), impact, constraintId, message);
        throw new AssertionError((Object)assertionMessage);
    }

    /*
     * Exception decompiling
     */
    private static String getAssertionErrorMessage(ScoreImpactType expectedImpactType, Number expectedImpact, ScoreImpactType actualImpactType, Number actualImpact, String constraintId, String message) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String getImpactTypeLabel(ScoreImpactType scoreImpactType) {
        if (scoreImpactType == ScoreImpactType.PENALTY) {
            return "penalty";
        }
        if (scoreImpactType == ScoreImpactType.REWARD) {
            return "reward";
        }
        return "impact";
    }

    public void penalizesBy(int matchWeightTotal, String message) {
        SingleConstraintAssertion.assertCorrectMatchWeight(matchWeightTotal);
        this.assertImpact(ScoreImpactType.PENALTY, matchWeightTotal, message);
    }

    public void penalizesBy(long matchWeightTotal, String message) {
        SingleConstraintAssertion.assertCorrectMatchWeight(matchWeightTotal);
        this.assertImpact(ScoreImpactType.PENALTY, matchWeightTotal, message);
    }

    public void penalizesBy(BigDecimal matchWeightTotal, String message) {
        SingleConstraintAssertion.assertCorrectMatchWeight(matchWeightTotal);
        this.assertImpact(ScoreImpactType.PENALTY, matchWeightTotal, message);
    }

    public void penalizesBy(int matchWeightTotal) {
        this.penalizesBy(matchWeightTotal, (String)null);
    }

    public void penalizesBy(long matchWeightTotal) {
        this.penalizesBy(matchWeightTotal, null);
    }

    public void penalizesBy(BigDecimal matchWeightTotal) {
        this.penalizesBy(matchWeightTotal, null);
    }

    public void rewardsWith(int matchWeightTotal, String message) {
        SingleConstraintAssertion.assertCorrectMatchWeight(matchWeightTotal);
        this.assertImpact(ScoreImpactType.REWARD, matchWeightTotal, message);
    }

    public void rewardsWith(long matchWeightTotal, String message) {
        SingleConstraintAssertion.assertCorrectMatchWeight(matchWeightTotal);
        this.assertImpact(ScoreImpactType.REWARD, matchWeightTotal, message);
    }

    public void rewardsWith(BigDecimal matchWeightTotal, String message) {
        SingleConstraintAssertion.assertCorrectMatchWeight(matchWeightTotal);
        this.assertImpact(ScoreImpactType.REWARD, matchWeightTotal, message);
    }

    public void rewardsWith(int matchWeightTotal) {
        this.rewardsWith(matchWeightTotal, (String)null);
    }

    public void rewardsWith(long matchWeightTotal) {
        this.rewardsWith(matchWeightTotal, null);
    }

    public void rewardsWith(BigDecimal matchWeightTotal) {
        this.rewardsWith(matchWeightTotal, null);
    }

    public void hasNoImpact(String message) {
        this.assertImpact(null, 0, message);
    }

    public void hasNoImpact() {
        this.hasNoImpact(null);
    }
}

