/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.core.support;

import java.util.List;
import org.springframework.data.mapping.context.PersistentEntities;
import org.springframework.data.rest.core.support.EntityLookup;
import org.springframework.data.rest.core.support.SelfLinkProvider;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.server.EntityLinks;
import org.springframework.plugin.core.PluginRegistry;
import org.springframework.util.Assert;

public class DefaultSelfLinkProvider
implements SelfLinkProvider {
    private final PersistentEntities entities;
    private final EntityLinks entityLinks;
    private final PluginRegistry<EntityLookup<?>, Class<?>> lookups;

    public DefaultSelfLinkProvider(PersistentEntities entities, EntityLinks entityLinks, List<? extends EntityLookup<?>> lookups) {
        Assert.notNull((Object)entities, (String)"PersistentEntities must not be null!");
        Assert.notNull((Object)entityLinks, (String)"EntityLinks must not be null!");
        Assert.notNull(lookups, (String)"EntityLookups must not be null!");
        this.entities = entities;
        this.entityLinks = entityLinks;
        this.lookups = PluginRegistry.of(lookups);
    }

    @Override
    public Link createSelfLinkFor(Object instance) {
        Assert.notNull((Object)instance, (String)"Domain object must not be null!");
        return this.entityLinks.linkToItemResource(instance.getClass(), this.getResourceId(instance));
    }

    private Object getResourceId(Object instance) {
        Class<?> instanceType = instance.getClass();
        return this.lookups.getPluginFor(instanceType).map(it -> (EntityLookup)it.getClass().cast(it)).map(it -> it.getResourceIdentifier(instance)).orElseGet(() -> this.identifierOrNull(instance));
    }

    private Object identifierOrNull(Object instance) {
        return this.entities.getRequiredPersistentEntity(instance.getClass()).getIdentifierAccessor(instance).getIdentifier();
    }
}

