/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.json;

import lombok.NonNull;
import org.springframework.core.MethodParameter;
import org.springframework.data.domain.Sort;
import org.springframework.data.rest.webmvc.json.JacksonMappingAwareSortTranslator;
import org.springframework.data.web.SortArgumentResolver;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class MappingAwareSortArgumentResolver
implements HandlerMethodArgumentResolver,
SortArgumentResolver {
    @NonNull
    private final JacksonMappingAwareSortTranslator translator;
    @NonNull
    private final SortArgumentResolver delegate;

    public boolean supportsParameter(MethodParameter parameter) {
        return this.delegate.supportsParameter(parameter);
    }

    public Sort resolveArgument(MethodParameter methodParameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) {
        Sort sort = this.delegate.resolveArgument(methodParameter, mavContainer, webRequest, binderFactory);
        return sort.isUnsorted() ? sort : this.translator.translateSort(sort, methodParameter, webRequest);
    }

    public MappingAwareSortArgumentResolver(@NonNull JacksonMappingAwareSortTranslator translator, @NonNull SortArgumentResolver delegate) {
        if (translator == null) {
            throw new IllegalArgumentException("translator is marked non-null but is null");
        }
        if (delegate == null) {
            throw new IllegalArgumentException("delegate is marked non-null but is null");
        }
        this.translator = translator;
        this.delegate = delegate;
    }
}

