/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.config;

import lombok.Generated;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.hateoas.config.WebConverters;
import org.springframework.lang.NonNull;
import org.springframework.web.client.RestTemplate;

@Configuration
class RestTemplateHateoasConfiguration {
    RestTemplateHateoasConfiguration() {
    }

    @Bean
    static HypermediaRestTemplateBeanPostProcessor hypermediaRestTemplateBeanPostProcessor(ObjectProvider<WebConverters> converters) {
        return new HypermediaRestTemplateBeanPostProcessor(converters);
    }

    static class HypermediaRestTemplateBeanPostProcessor
    implements BeanPostProcessor {
        private final ObjectProvider<WebConverters> converters;

        @NonNull
        public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
            if (!RestTemplate.class.isInstance(bean)) {
                return bean;
            }
            RestTemplate template = (RestTemplate)bean;
            template.setMessageConverters(((WebConverters)this.converters.getObject()).and(template.getMessageConverters()));
            return template;
        }

        @Generated
        public HypermediaRestTemplateBeanPostProcessor(ObjectProvider<WebConverters> converters) {
            this.converters = converters;
        }
    }
}

