/*
 * Decompiled with CFR 0.152.
 */
package org.webjars;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.Resource;
import io.github.classgraph.ResourceList;
import io.github.classgraph.ScanResult;
import java.io.IOException;
import java.net.URI;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.webjars.MultipleMatchesException;
import org.webjars.NotFoundException;

public class WebJarAssetLocator {
    public static final String WEBJARS_PACKAGE = "META-INF.resources.webjars";
    public static final String WEBJARS_PATH_PREFIX = "META-INF/resources/webjars";
    private static Pattern WEBJAR_EXTRACTOR_PATTERN = Pattern.compile("META-INF/resources/webjars/([^/]*)/([^/]*)/(.*)$");
    protected final Map<String, WebJarInfo> allWebJars;

    protected static ResourceList webJarResources(final String webJarName, ResourceList resources) {
        return resources.filter(new ResourceList.ResourceFilter(){

            public boolean accept(Resource resource) {
                return resource.getPath().startsWith("META-INF/resources/webjars/" + webJarName + "/");
            }
        });
    }

    protected static String webJarVersion(String webJarName, ResourceList resources) {
        String prefix;
        if (resources.isEmpty()) {
            return null;
        }
        String aPath = ((Resource)resources.get(0)).getPath();
        if (aPath.startsWith(prefix = "META-INF/resources/webjars/" + webJarName + "/")) {
            String withoutName = aPath.substring(prefix.length());
            try {
                final String maybeVersion = withoutName.substring(0, withoutName.indexOf("/"));
                ResourceList withMaybeVersion = resources.filter(new ResourceList.ResourceFilter(){

                    public boolean accept(Resource resource) {
                        return resource.getPath().startsWith(prefix + maybeVersion + "/");
                    }
                });
                if (withMaybeVersion.size() == resources.size()) {
                    return maybeVersion;
                }
                return null;
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    protected static String groupId(URI classpathElementURI) {
        ClassGraph classGraph = new ClassGraph().overrideClasspath(new Object[]{classpathElementURI}).whitelistPaths(new String[]{"META-INF/maven"});
        try (ScanResult scanResult = classGraph.scan();){
            ResourceList maybePomProperties = scanResult.getResourcesWithLeafName("pom.properties");
            String groupId = null;
            if (maybePomProperties.size() == 1) {
                try {
                    Properties properties = new Properties();
                    properties.load(((Resource)maybePomProperties.get(0)).open());
                    ((Resource)maybePomProperties.get(0)).close();
                    groupId = properties.getProperty("groupId");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            String string = groupId;
            return string;
        }
    }

    protected static Map<String, WebJarInfo> findWebJars(ScanResult scanResult) {
        HashMap<String, WebJarInfo> allWebJars = new HashMap<String, WebJarInfo>();
        for (Resource resource : scanResult.getAllResources()) {
            String noPrefix = resource.getPath().substring(WEBJARS_PATH_PREFIX.length() + 1);
            String webJarName = noPrefix.substring(0, noPrefix.indexOf("/"));
            WebJarInfo webJarInfo = (WebJarInfo)allWebJars.get(webJarName);
            if (webJarInfo != null) continue;
            ResourceList webJarResources = WebJarAssetLocator.webJarResources(webJarName, scanResult.getAllResources());
            String maybeWebJarVersion = WebJarAssetLocator.webJarVersion(webJarName, webJarResources);
            String maybeGroupId = WebJarAssetLocator.groupId(resource.getClasspathElementURI());
            webJarInfo = new WebJarInfo(maybeWebJarVersion, maybeGroupId, resource.getClasspathElementURI(), webJarResources.getPaths());
            allWebJars.put(webJarName, webJarInfo);
        }
        return allWebJars;
    }

    public static Map.Entry<String, String> getWebJar(String path) {
        Matcher matcher = WEBJAR_EXTRACTOR_PATTERN.matcher(path);
        if (matcher.find()) {
            String id = matcher.group(1);
            String version = matcher.group(2);
            return new AbstractMap.SimpleEntry<String, String>(id, version);
        }
        return null;
    }

    private Map<String, WebJarInfo> scanForWebJars(ClassGraph classGraph) {
        try (ScanResult scanResult = classGraph.whitelistPaths(new String[]{WEBJARS_PATH_PREFIX}).scan();){
            Map<String, WebJarInfo> map = WebJarAssetLocator.findWebJars(scanResult);
            return map;
        }
    }

    public WebJarAssetLocator() {
        this.allWebJars = this.scanForWebJars(new ClassGraph());
    }

    public WebJarAssetLocator(ClassLoader classLoader) {
        this.allWebJars = this.scanForWebJars(new ClassGraph().overrideClassLoaders(new ClassLoader[]{classLoader}));
    }

    public WebJarAssetLocator(Map<String, WebJarInfo> allWebJars) {
        this.allWebJars = allWebJars;
    }

    private String throwNotFoundException(String partialPath) {
        throw new NotFoundException(partialPath + " could not be found. Make sure you've added the corresponding WebJar and please check for typos.");
    }

    private String throwMultipleMatchesException(String partialPath, List<String> matches) {
        throw new MultipleMatchesException("Multiple matches found for " + partialPath + ". Please provide a more specific path, for example by including a version number.", matches);
    }

    public String getFullPath(String partialPath) {
        ArrayList<String> paths = new ArrayList<String>();
        for (String webJarName : this.allWebJars.keySet()) {
            try {
                paths.add(this.getFullPath(webJarName, partialPath));
            }
            catch (NotFoundException notFoundException) {}
        }
        if (paths.size() == 0) {
            this.throwNotFoundException(partialPath);
        } else if (paths.size() > 1) {
            this.throwMultipleMatchesException(partialPath, paths);
        }
        return (String)paths.get(0);
    }

    public String getFullPath(String webjar, String partialPath) {
        ArrayList<String> paths = new ArrayList<String>();
        for (String path : this.allWebJars.get((Object)webjar).contents) {
            if (!path.endsWith(partialPath)) continue;
            paths.add(path);
        }
        if (paths.size() == 0) {
            this.throwNotFoundException(partialPath);
        } else if (paths.size() > 1) {
            this.throwMultipleMatchesException(partialPath, paths);
        }
        return (String)paths.get(0);
    }

    public String getFullPathExact(String webJarName, String exactPath) {
        String maybeVersion = this.getWebJars().get(webJarName);
        String fullPath = maybeVersion != null ? "META-INF/resources/webjars/" + webJarName + "/" + maybeVersion + "/" + exactPath : "META-INF/resources/webjars/" + webJarName + "/" + exactPath;
        if (this.allWebJars.get((Object)webJarName).contents.contains(fullPath)) {
            return fullPath;
        }
        return null;
    }

    public Set<String> listAssets() {
        return this.listAssets("");
    }

    public Set<String> listAssets(String folderPath) {
        HashSet<String> assets = new HashSet<String>();
        String prefix = WEBJARS_PATH_PREFIX + (!folderPath.startsWith("/") ? "/" : "") + folderPath;
        for (WebJarInfo webJarInfo : this.allWebJars.values()) {
            for (String path : webJarInfo.contents) {
                if (!path.startsWith(folderPath) && !path.startsWith(prefix)) continue;
                assets.add(path);
            }
        }
        return assets;
    }

    public Map<String, String> getWebJars() {
        HashMap<String, String> webJars = new HashMap<String, String>();
        for (String webJarName : this.allWebJars.keySet()) {
            webJars.put(webJarName, this.allWebJars.get((Object)webJarName).version);
        }
        return webJars;
    }

    public String groupId(String fullPath) {
        String groupId = null;
        for (String webJarName : this.allWebJars.keySet()) {
            WebJarInfo webJarInfo = this.allWebJars.get(webJarName);
            if (!webJarInfo.contents.contains(fullPath)) continue;
            groupId = webJarInfo.groupId;
        }
        return groupId;
    }

    static class WebJarInfo {
        final String version;
        final String groupId;
        final URI uri;
        final List<String> contents;

        public WebJarInfo(String version, String groupId, URI uri, List<String> contents) {
            this.version = version;
            this.groupId = groupId;
            this.uri = uri;
            this.contents = contents;
        }
    }
}

