/*
 * Decompiled with CFR 0.152.
 */
package org.webjars;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.Resource;
import io.github.classgraph.ResourceList;
import io.github.classgraph.ScanResult;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webjars.WebJarAssetLocator;

public class WebJarExtractor {
    public static final String PACKAGE_JSON = "package.json";
    public static final String BOWER_JSON = "bower.json";
    private static final String JAR_PATH_DELIMITER = "/";
    private static final Logger log = LoggerFactory.getLogger(WebJarExtractor.class);
    private final ClassLoader classLoader;

    public WebJarExtractor() {
        this(WebJarExtractor.class.getClassLoader());
    }

    public WebJarExtractor(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void extractAllWebJarsTo(File to) throws IOException {
        this.extractWebJarsTo(null, null, to);
    }

    public void extractWebJarTo(String name, File to) throws IOException {
        this.extractWebJarsTo(name, null, to);
    }

    public void extractAllNodeModulesTo(File to) throws IOException {
        this.extractWebJarsTo(null, PACKAGE_JSON, to);
    }

    public void extractAllBowerComponentsTo(File to) throws IOException {
        this.extractWebJarsTo(null, BOWER_JSON, to);
    }

    private String getModuleId(ResourceList resourceList, final String moduleNameFile) {
        final String[] moduleId = new String[1];
        resourceList.filter(new ResourceList.ResourceFilter(){

            public boolean accept(Resource resource) {
                return resource.getPath().endsWith(moduleNameFile);
            }
        }).forEachByteArray(new ResourceList.ByteArrayConsumer(){

            public void accept(Resource resource, byte[] byteArray) {
                try {
                    moduleId[0] = WebJarExtractor.getJsonModuleId(new String(byteArray));
                }
                catch (IOException e) {
                    log.error("Could not get moduleId", (Throwable)e);
                }
            }
        });
        return moduleId[0];
    }

    private void extractResourcesTo(final String webJarName, final String webJarVersion, String moduleNameFile, ResourceList webJarResources, final File to) {
        boolean useModuleName = moduleNameFile != null;
        final String webJarId = useModuleName ? this.getModuleId(webJarResources, moduleNameFile) : webJarName;
        webJarResources.forEachInputStream(new ResourceList.InputStreamConsumer(){

            public void accept(Resource resource, InputStream inputStream) {
                String prefix = "META-INF/resources/webjars" + File.separator + webJarName + File.separator + (webJarVersion == null ? "" : webJarVersion + File.separator);
                if (resource.getPath().startsWith(prefix)) {
                    String newPath = resource.getPath().substring(prefix.length());
                    String relativeName = webJarId + File.separator + newPath;
                    File newFile = new File(to, relativeName);
                    if (!newFile.exists()) {
                        try {
                            newFile.getParentFile().mkdirs();
                            Files.copy(inputStream, newFile.toPath(), new CopyOption[0]);
                            inputStream.close();
                            Set resourcePerms = resource.getPosixFilePermissions();
                            if (resourcePerms != null) {
                                Files.setPosixFilePermissions(newFile.toPath(), resourcePerms);
                            }
                            if (resource.getLastModified() > 0L) {
                                newFile.setLastModified(resource.getLastModified());
                            }
                        }
                        catch (IOException e) {
                            log.error("Could not write file", (Throwable)e);
                        }
                    }
                }
            }
        });
    }

    private void extractWebJarsTo(String name, String moduleNameFile, File to) throws IOException {
        if (name == null) {
            ClassGraph classGraph = new ClassGraph().overrideClassLoaders(new ClassLoader[]{this.classLoader}).whitelistPaths(new String[]{"META-INF/resources/webjars"});
            try (ScanResult scanResult = classGraph.scan();){
                Map<String, WebJarAssetLocator.WebJarInfo> allWebJars = WebJarAssetLocator.findWebJars(scanResult);
                for (String webJarName : allWebJars.keySet()) {
                    String webJarVersion = allWebJars.get((Object)webJarName).version;
                    ResourceList webJarResources = WebJarAssetLocator.webJarResources(webJarName, scanResult.getAllResources());
                    this.extractResourcesTo(webJarName, webJarVersion, moduleNameFile, webJarResources, to);
                }
            }
        }
        ClassGraph classGraph = new ClassGraph().overrideClassLoaders(new ClassLoader[]{this.classLoader}).whitelistPaths(new String[]{"META-INF/resources/webjars/" + name});
        try (ScanResult scanResult = classGraph.scan();){
            ResourceList webJarResources = scanResult.getAllResources();
            String webJarVersion = WebJarAssetLocator.webJarVersion(name, webJarResources);
            this.extractResourcesTo(name, webJarVersion, moduleNameFile, webJarResources, to);
        }
    }

    protected static String getJsonModuleId(String packageJson) throws IOException {
        JsonFactory factory = new JsonFactory();
        JsonParser parser = factory.createParser(packageJson);
        if (parser.nextToken() != JsonToken.START_OBJECT) {
            throw new IOException("package.json is not a valid JSON object");
        }
        String moduleId = null;
        while (moduleId == null) {
            parser.nextToken();
            String fieldName = parser.getCurrentName();
            if (!"name".equals(fieldName) || !parser.getParsingContext().getParent().inRoot()) continue;
            parser.nextToken();
            moduleId = parser.getText();
        }
        parser.close();
        return moduleId;
    }
}

