/*
 * Decompiled with CFR 0.152.
 */
package com.example.schooltimetabling.domain;

import java.time.DayOfWeek;
import java.time.LocalTime;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.NotNull;
import org.optaplanner.core.api.domain.lookup.PlanningId;

@Entity
@Table(uniqueConstraints={@UniqueConstraint(columnNames={"dayOfWeek", "startTime", "endTime"})})
public class Timeslot {
    @PlanningId
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @NotNull
    private Long id;
    @NotNull
    private DayOfWeek dayOfWeek;
    @NotNull
    private LocalTime startTime;
    @NotNull
    private LocalTime endTime;

    private Timeslot() {
    }

    public Timeslot(DayOfWeek dayOfWeek, LocalTime startTime, LocalTime endTime) {
        this.dayOfWeek = dayOfWeek;
        this.startTime = startTime;
        this.endTime = endTime;
    }

    public Timeslot(long id, DayOfWeek dayOfWeek, LocalTime startTime) {
        this(dayOfWeek, startTime, startTime.plusMinutes(50L));
        this.id = id;
    }

    public String toString() {
        return this.dayOfWeek + " " + this.startTime;
    }

    public Long getId() {
        return this.id;
    }

    public DayOfWeek getDayOfWeek() {
        return this.dayOfWeek;
    }

    public LocalTime getStartTime() {
        return this.startTime;
    }

    public LocalTime getEndTime() {
        return this.endTime;
    }
}

