/*
 * Decompiled with CFR 0.152.
 */
package org.drools.model.functions.temporal;

import java.util.concurrent.TimeUnit;
import org.drools.model.functions.temporal.AbstractTemporalPredicate;
import org.drools.model.functions.temporal.Interval;
import org.drools.model.functions.temporal.TimeUtil;

public class OverlapsPredicate
extends AbstractTemporalPredicate<OverlapsPredicate> {
    private final long minDev;
    private final long maxDev;

    public OverlapsPredicate() {
        this(1L, Long.MAX_VALUE);
    }

    public OverlapsPredicate(long maxDev, TimeUnit maxDevTimeUnit) {
        this(1L, TimeUtil.unitToLong(maxDev, maxDevTimeUnit));
    }

    public OverlapsPredicate(long minDev, TimeUnit minDevTimeUnit, long maxDev, TimeUnit maxDevTimeUnit) {
        this(TimeUtil.unitToLong(minDev, minDevTimeUnit), TimeUtil.unitToLong(maxDev, maxDevTimeUnit));
    }

    private OverlapsPredicate(long minDev, long maxDev) {
        this.minDev = minDev;
        this.maxDev = maxDev;
    }

    public String toString() {
        return (this.negated ? "not " : "") + "overlaps[" + this.minDev + ", " + this.maxDev + "]";
    }

    @Override
    public Interval getInterval() {
        return this.negated ? new Interval(Long.MIN_VALUE, Long.MAX_VALUE) : new Interval(Long.MIN_VALUE, 0L);
    }

    @Override
    public boolean evaluate(long start1, long duration1, long end1, long start2, long duration2, long end2) {
        long dist = end1 - start2;
        return this.negated ^ (start1 < start2 && end1 < end2 && dist >= this.minDev && dist <= this.maxDev);
    }

    @Override
    protected boolean isTemporalPredicateEqualTo(OverlapsPredicate other) {
        return this.minDev == other.minDev && this.maxDev == other.maxDev;
    }
}

