/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.common.accessor.gizmo;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.optaplanner.core.api.domain.common.DomainAccessType;
import org.optaplanner.core.impl.domain.common.accessor.MemberAccessor;
import org.optaplanner.core.impl.domain.common.accessor.gizmo.GizmoMemberAccessorImplementor;

public class GizmoMemberAccessorFactory {
    private static Map<String, MemberAccessor> memberAccessorMap = new ConcurrentHashMap<String, MemberAccessor>();
    static Map<String, Type> gizmoMemberAccessorNameToGenericType = new ConcurrentHashMap<String, Type>();
    static Map<String, AnnotatedElement> gizmoMemberAccessorNameToAnnotatedElement = new ConcurrentHashMap<String, AnnotatedElement>();

    public static String getGeneratedClassName(Member member) {
        return member.getDeclaringClass().getPackage().getName() + ".$optaplanner$__" + member.getDeclaringClass().getSimpleName() + "$__" + member.getName();
    }

    public static Type getGenericTypeFor(String gizmoMemberAccessorName) {
        return gizmoMemberAccessorNameToGenericType.get(gizmoMemberAccessorName);
    }

    public static AnnotatedElement getAnnotatedElementFor(String gizmoMemberAccessorName) {
        return gizmoMemberAccessorNameToAnnotatedElement.get(gizmoMemberAccessorName);
    }

    public static void usePregeneratedMaps(Map<String, MemberAccessor> memberAccessorMap, Map<String, Type> gizmoMemberAccessorNameToGenericType, Map<String, AnnotatedElement> gizmoMemberAccessorNameToAnnotatedElement) {
        GizmoMemberAccessorFactory.memberAccessorMap = memberAccessorMap;
        GizmoMemberAccessorFactory.gizmoMemberAccessorNameToGenericType = gizmoMemberAccessorNameToGenericType;
        GizmoMemberAccessorFactory.gizmoMemberAccessorNameToAnnotatedElement = gizmoMemberAccessorNameToAnnotatedElement;
    }

    public static MemberAccessor buildGizmoMemberAccessor(Member member, Class<? extends Annotation> annotationClass) {
        String gizmoMemberAccessorClassName = GizmoMemberAccessorFactory.getGeneratedClassName(member);
        if (memberAccessorMap.containsKey(gizmoMemberAccessorClassName)) {
            return memberAccessorMap.get(gizmoMemberAccessorClassName);
        }
        try {
            Class.forName("io.quarkus.gizmo.ClassCreator", false, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("When using the domainAccessType (" + (Object)((Object)DomainAccessType.GIZMO) + ") the classpath or modulepath must contain io.quarkus.gizmo:gizmo.\nMaybe add a dependency to io.quarkus.gizmo:gizmo.");
        }
        MemberAccessor accessor = GizmoMemberAccessorImplementor.createAccessorFor(member, annotationClass);
        memberAccessorMap.put(gizmoMemberAccessorClassName, accessor);
        return accessor;
    }

    private GizmoMemberAccessorFactory() {
    }
}

