/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.generic.chained;

import java.util.Iterator;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonInverseVariableDemand;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonInverseVariableSupply;
import org.optaplanner.core.impl.domain.variable.supply.SupplyManager;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.heuristic.selector.common.iterator.AbstractOriginalSwapIterator;
import org.optaplanner.core.impl.heuristic.selector.common.iterator.AbstractRandomSwapIterator;
import org.optaplanner.core.impl.heuristic.selector.move.generic.GenericMoveSelector;
import org.optaplanner.core.impl.heuristic.selector.move.generic.chained.SubChainReversingSwapMove;
import org.optaplanner.core.impl.heuristic.selector.move.generic.chained.SubChainSwapMove;
import org.optaplanner.core.impl.heuristic.selector.value.chained.SubChain;
import org.optaplanner.core.impl.heuristic.selector.value.chained.SubChainSelector;
import org.optaplanner.core.impl.solver.scope.SolverScope;

public class SubChainSwapMoveSelector<Solution_>
extends GenericMoveSelector<Solution_> {
    protected final SubChainSelector<Solution_> leftSubChainSelector;
    protected final SubChainSelector<Solution_> rightSubChainSelector;
    protected final GenuineVariableDescriptor<Solution_> variableDescriptor;
    protected final boolean randomSelection;
    protected final boolean selectReversingMoveToo;
    protected SingletonInverseVariableSupply inverseVariableSupply = null;

    public SubChainSwapMoveSelector(SubChainSelector<Solution_> leftSubChainSelector, SubChainSelector<Solution_> rightSubChainSelector, boolean randomSelection, boolean selectReversingMoveToo) {
        this.leftSubChainSelector = leftSubChainSelector;
        this.rightSubChainSelector = rightSubChainSelector;
        this.randomSelection = randomSelection;
        this.selectReversingMoveToo = selectReversingMoveToo;
        this.variableDescriptor = leftSubChainSelector.getVariableDescriptor();
        if (leftSubChainSelector.getVariableDescriptor() != rightSubChainSelector.getVariableDescriptor()) {
            throw new IllegalStateException("The selector (" + this + ") has a leftSubChainSelector's variableDescriptor (" + leftSubChainSelector.getVariableDescriptor() + ") which is not equal to the rightSubChainSelector's variableDescriptor (" + rightSubChainSelector.getVariableDescriptor() + ").");
        }
        this.phaseLifecycleSupport.addEventListener(leftSubChainSelector);
        if (leftSubChainSelector != rightSubChainSelector) {
            this.phaseLifecycleSupport.addEventListener(rightSubChainSelector);
        }
    }

    @Override
    public void solvingStarted(SolverScope<Solution_> solverScope) {
        super.solvingStarted(solverScope);
        SupplyManager<Solution_> supplyManager = solverScope.getScoreDirector().getSupplyManager();
        this.inverseVariableSupply = (SingletonInverseVariableSupply)supplyManager.demand(new SingletonInverseVariableDemand<Solution_>(this.variableDescriptor));
    }

    @Override
    public void solvingEnded(SolverScope<Solution_> solverScope) {
        super.solvingEnded(solverScope);
        this.inverseVariableSupply = null;
    }

    @Override
    public boolean isCountable() {
        return this.leftSubChainSelector.isCountable() && this.rightSubChainSelector.isCountable();
    }

    @Override
    public boolean isNeverEnding() {
        return this.randomSelection || this.leftSubChainSelector.isNeverEnding() || this.rightSubChainSelector.isNeverEnding();
    }

    @Override
    public long getSize() {
        return AbstractOriginalSwapIterator.getSize(this.leftSubChainSelector, this.rightSubChainSelector);
    }

    @Override
    public Iterator<Move<Solution_>> iterator() {
        if (!this.randomSelection) {
            return new AbstractOriginalSwapIterator<Solution_, Move<Solution_>, SubChain>(this.leftSubChainSelector, this.rightSubChainSelector){
                private Move<Solution_> nextReversingSelection;
                {
                    this.nextReversingSelection = null;
                }

                @Override
                protected Move<Solution_> createUpcomingSelection() {
                    if (SubChainSwapMoveSelector.this.selectReversingMoveToo && this.nextReversingSelection != null) {
                        Move upcomingSelection = this.nextReversingSelection;
                        this.nextReversingSelection = null;
                        return upcomingSelection;
                    }
                    return super.createUpcomingSelection();
                }

                @Override
                protected Move<Solution_> newSwapSelection(SubChain leftSubSelection, SubChain rightSubSelection) {
                    if (SubChainSwapMoveSelector.this.selectReversingMoveToo) {
                        this.nextReversingSelection = new SubChainReversingSwapMove(SubChainSwapMoveSelector.this.variableDescriptor, SubChainSwapMoveSelector.this.inverseVariableSupply, leftSubSelection, rightSubSelection);
                    }
                    return new SubChainSwapMove(SubChainSwapMoveSelector.this.variableDescriptor, SubChainSwapMoveSelector.this.inverseVariableSupply, leftSubSelection, rightSubSelection);
                }
            };
        }
        return new AbstractRandomSwapIterator<Solution_, Move<Solution_>, SubChain>(this.leftSubChainSelector, this.rightSubChainSelector){

            @Override
            protected Move<Solution_> newSwapSelection(SubChain leftSubSelection, SubChain rightSubSelection) {
                boolean reversing = SubChainSwapMoveSelector.this.selectReversingMoveToo && SubChainSwapMoveSelector.this.workingRandom.nextBoolean();
                return reversing ? new SubChainReversingSwapMove(SubChainSwapMoveSelector.this.variableDescriptor, SubChainSwapMoveSelector.this.inverseVariableSupply, leftSubSelection, rightSubSelection) : new SubChainSwapMove(SubChainSwapMoveSelector.this.variableDescriptor, SubChainSwapMoveSelector.this.inverseVariableSupply, leftSubSelection, rightSubSelection);
            }
        };
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.leftSubChainSelector + ", " + this.rightSubChainSelector + ")";
    }
}

