/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.bavet.bi;

import java.util.function.Function;
import org.optaplanner.core.impl.score.stream.bavet.bi.BavetAbstractBiTuple;
import org.optaplanner.core.impl.score.stream.bavet.bi.BavetGroupBiNode;
import org.optaplanner.core.impl.score.stream.bavet.common.BavetGroupTuple;

public final class BavetGroupBiTuple<GroupKey_, ResultContainer_, Result_>
extends BavetAbstractBiTuple<GroupKey_, Result_>
implements BavetGroupTuple {
    private final BavetGroupBiNode<GroupKey_, ResultContainer_, Result_> node;
    private GroupKey_ groupKey;
    private int parentCount;
    private ResultContainer_ resultContainer;
    private Result_ result;

    public BavetGroupBiTuple(BavetGroupBiNode<GroupKey_, ResultContainer_, Result_> node, GroupKey_ groupKey, ResultContainer_ resultContainer) {
        this.node = node;
        this.groupKey = groupKey;
        this.parentCount = 0;
        this.resultContainer = resultContainer;
        this.result = null;
    }

    public int increaseParentCount() {
        ++this.parentCount;
        return this.parentCount;
    }

    public int decreaseParentCount() {
        --this.parentCount;
        if (this.parentCount < 0) {
            throw new IllegalStateException("The parentCount (" + this.parentCount + ") for groupKey (" + this.groupKey + ") must not be negative.");
        }
        return this.parentCount;
    }

    public void clearResult() {
        this.result = null;
    }

    public void updateResult(Function<ResultContainer_, Result_> finisher) {
        this.result = finisher.apply(this.resultContainer);
    }

    public String toString() {
        return "Group(" + this.getFactsString() + ")";
    }

    @Override
    public BavetGroupBiNode<GroupKey_, ResultContainer_, Result_> getNode() {
        return this.node;
    }

    @Override
    public GroupKey_ getFactA() {
        return this.groupKey;
    }

    @Override
    public Result_ getFactB() {
        return this.result;
    }

    public GroupKey_ getGroupKey() {
        return this.groupKey;
    }

    public ResultContainer_ getResultContainer() {
        return this.resultContainer;
    }
}

