/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools;

import java.util.Map;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;
import org.optaplanner.core.api.domain.solution.PlanningSolution;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.constraint.ConstraintMatchTotal;
import org.optaplanner.core.api.score.constraint.Indictment;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.score.holder.AbstractScoreHolder;
import org.optaplanner.core.impl.score.stream.ConstraintSession;

public class DroolsConstraintSession<Solution_, Score_ extends Score<Score_>>
implements ConstraintSession<Solution_, Score_> {
    private final SolutionDescriptor<Solution_> solutionDescriptor;
    private final KieSession kieSession;
    private final AbstractScoreHolder<Score_> scoreHolder;

    public DroolsConstraintSession(SolutionDescriptor<Solution_> solutionDescriptor, KieSession kieSession, AbstractScoreHolder<Score_> scoreHolder) {
        this.solutionDescriptor = solutionDescriptor;
        this.kieSession = kieSession;
        this.scoreHolder = scoreHolder;
    }

    @Override
    public void insert(Object fact) {
        this.kieSession.insert(fact);
    }

    @Override
    public void update(Object fact) {
        FactHandle factHandle = this.kieSession.getFactHandle(fact);
        if (factHandle == null) {
            throw new IllegalArgumentException("The fact (" + fact + ") was never added to this ScoreDirector.\nMaybe that specific instance is not in the return values of the " + PlanningSolution.class.getSimpleName() + "'s entity members (" + this.solutionDescriptor.getEntityMemberAndEntityCollectionMemberNames() + ") or fact members (" + this.solutionDescriptor.getProblemFactMemberAndProblemFactCollectionMemberNames() + ").");
        }
        this.kieSession.update(factHandle, fact);
    }

    @Override
    public void retract(Object fact) {
        FactHandle factHandle = this.kieSession.getFactHandle(fact);
        this.kieSession.delete(factHandle);
    }

    @Override
    public Score_ calculateScore(int initScore) {
        this.kieSession.fireAllRules();
        return this.scoreHolder.extractScore(initScore);
    }

    @Override
    public Map<String, ConstraintMatchTotal<Score_>> getConstraintMatchTotalMap() {
        this.kieSession.fireAllRules();
        return this.scoreHolder.getConstraintMatchTotalMap();
    }

    @Override
    public Map<Object, Indictment<Score_>> getIndictmentMap() {
        this.kieSession.fireAllRules();
        return this.scoreHolder.getIndictmentMap();
    }

    @Override
    public void close() {
        this.kieSession.dispose();
    }
}

