/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.common;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.function.Supplier;
import org.drools.model.DSL;
import org.drools.model.Global;
import org.drools.model.Variable;
import org.drools.model.consequences.ConsequenceBuilder;
import org.drools.model.functions.Block5;
import org.optaplanner.core.api.function.ToIntTriFunction;
import org.optaplanner.core.api.function.ToLongTriFunction;
import org.optaplanner.core.api.function.TriFunction;
import org.optaplanner.core.impl.score.holder.AbstractScoreHolder;
import org.optaplanner.core.impl.score.stream.drools.DroolsConstraint;
import org.optaplanner.core.impl.score.stream.drools.common.AbstractConstraintConsequence;
import org.optaplanner.core.impl.score.stream.drools.common.ConsequenceMatchWeightType;
import org.optaplanner.core.impl.score.stream.drools.common.TriLeftHandSide;

abstract class AbstractTriConstraintConsequence<A, B, C>
extends AbstractConstraintConsequence<TriLeftHandSide<A, B, C>> {
    AbstractTriConstraintConsequence() {
    }

    @Override
    public int getCardinality() {
        return 3;
    }

    @Override
    protected abstract ConsequenceMatchWeightType getMatchWeightType();

    @Override
    protected final ConsequenceBuilder.ValidBuilder buildConsequence(DroolsConstraint<?> constraint, Global<? extends AbstractScoreHolder<?>> scoreHolderGlobal, Variable<?> ... variables) {
        AbstractConstraintConsequence consequence = constraint.getConsequence();
        switch (consequence.getMatchWeightType()) {
            case INTEGER: {
                ToIntTriFunction intMatchWeighter = (ToIntTriFunction)((Supplier)((Object)consequence)).get();
                return DSL.on(scoreHolderGlobal, variables[0], variables[1], variables[2]).execute((Block5 & Serializable)(drools, scoreHolder, a, b, c) -> AbstractTriConstraintConsequence.impactScore(constraint, drools, scoreHolder, intMatchWeighter.applyAsInt(a, b, c)));
            }
            case LONG: {
                ToLongTriFunction longMatchWeighter = (ToLongTriFunction)((Supplier)((Object)consequence)).get();
                return DSL.on(scoreHolderGlobal, variables[0], variables[1], variables[2]).execute((Block5 & Serializable)(drools, scoreHolder, a, b, c) -> AbstractTriConstraintConsequence.impactScore(constraint, drools, scoreHolder, longMatchWeighter.applyAsLong(a, b, c)));
            }
            case BIG_DECIMAL: {
                TriFunction bigDecimalMatchWeighter = (TriFunction)((Supplier)((Object)consequence)).get();
                return DSL.on(scoreHolderGlobal, variables[0], variables[1], variables[2]).execute((Block5 & Serializable)(drools, scoreHolder, a, b, c) -> AbstractTriConstraintConsequence.impactScore(constraint, drools, scoreHolder, (BigDecimal)bigDecimalMatchWeighter.apply(a, b, c)));
            }
            case DEFAULT: {
                return DSL.on(scoreHolderGlobal).execute(AbstractConstraintConsequence::impactScore);
            }
        }
        throw new UnsupportedOperationException(consequence.getMatchWeightType().toString());
    }
}

