/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.common;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import org.drools.model.DSL;
import org.drools.model.Global;
import org.drools.model.Variable;
import org.drools.model.consequences.ConsequenceBuilder;
import org.drools.model.functions.Block3;
import org.optaplanner.core.impl.score.holder.AbstractScoreHolder;
import org.optaplanner.core.impl.score.stream.drools.DroolsConstraint;
import org.optaplanner.core.impl.score.stream.drools.common.AbstractConstraintConsequence;
import org.optaplanner.core.impl.score.stream.drools.common.ConsequenceMatchWeightType;
import org.optaplanner.core.impl.score.stream.drools.common.UniLeftHandSide;

abstract class AbstractUniConstraintConsequence<A>
extends AbstractConstraintConsequence<UniLeftHandSide<A>> {
    AbstractUniConstraintConsequence() {
    }

    @Override
    public int getCardinality() {
        return 1;
    }

    @Override
    protected abstract ConsequenceMatchWeightType getMatchWeightType();

    @Override
    protected final ConsequenceBuilder.ValidBuilder buildConsequence(DroolsConstraint<?> constraint, Global<? extends AbstractScoreHolder<?>> scoreHolderGlobal, Variable<?> ... variables) {
        AbstractConstraintConsequence consequence = constraint.getConsequence();
        switch (consequence.getMatchWeightType()) {
            case INTEGER: {
                ToIntFunction intMatchWeighter = (ToIntFunction)((Supplier)((Object)consequence)).get();
                return DSL.on(scoreHolderGlobal, variables[0]).execute((Block3 & Serializable)(drools, scoreHolder, a) -> AbstractUniConstraintConsequence.impactScore(constraint, drools, scoreHolder, intMatchWeighter.applyAsInt(a)));
            }
            case LONG: {
                ToLongFunction longMatchWeighter = (ToLongFunction)((Supplier)((Object)consequence)).get();
                return DSL.on(scoreHolderGlobal, variables[0]).execute((Block3 & Serializable)(drools, scoreHolder, a) -> AbstractUniConstraintConsequence.impactScore(constraint, drools, scoreHolder, longMatchWeighter.applyAsLong(a)));
            }
            case BIG_DECIMAL: {
                Function bigDecimalMatchWeighter = (Function)((Supplier)((Object)consequence)).get();
                return DSL.on(scoreHolderGlobal, variables[0]).execute((Block3 & Serializable)(drools, scoreHolder, a) -> AbstractUniConstraintConsequence.impactScore(constraint, drools, scoreHolder, (BigDecimal)bigDecimalMatchWeighter.apply(a)));
            }
            case DEFAULT: {
                return DSL.on(scoreHolderGlobal).execute(AbstractConstraintConsequence::impactScore);
            }
        }
        throw new UnsupportedOperationException(consequence.getMatchWeightType().toString());
    }
}

