/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.common;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import org.drools.model.BetaIndex;
import org.drools.model.DSL;
import org.drools.model.Index;
import org.drools.model.PatternDSL;
import org.drools.model.Variable;
import org.drools.model.functions.Function1;
import org.drools.model.functions.Predicate2;
import org.drools.model.functions.accumulate.AccumulateFunction;
import org.drools.model.view.ExprViewItem;
import org.drools.model.view.ViewItem;
import org.drools.model.view.ViewItemBuilder;
import org.optaplanner.core.api.score.stream.bi.BiJoiner;
import org.optaplanner.core.api.score.stream.uni.UniConstraintCollector;
import org.optaplanner.core.impl.score.stream.bi.AbstractBiJoiner;
import org.optaplanner.core.impl.score.stream.bi.FilteringBiJoiner;
import org.optaplanner.core.impl.score.stream.bi.NoneBiJoiner;
import org.optaplanner.core.impl.score.stream.common.JoinerType;
import org.optaplanner.core.impl.score.stream.drools.DroolsVariableFactory;
import org.optaplanner.core.impl.score.stream.drools.common.AbstractLeftHandSide;
import org.optaplanner.core.impl.score.stream.drools.common.AbstractUniConstraintConsequence;
import org.optaplanner.core.impl.score.stream.drools.common.BiLeftHandSide;
import org.optaplanner.core.impl.score.stream.drools.common.BiTuple;
import org.optaplanner.core.impl.score.stream.drools.common.DroolsUniAccumulateFunction;
import org.optaplanner.core.impl.score.stream.drools.common.PatternVariable;
import org.optaplanner.core.impl.score.stream.drools.common.QuadLeftHandSide;
import org.optaplanner.core.impl.score.stream.drools.common.TriLeftHandSide;
import org.optaplanner.core.impl.score.stream.drools.common.UniConstraintBigDecimalConsequence;
import org.optaplanner.core.impl.score.stream.drools.common.UniConstraintDefaultConsequence;
import org.optaplanner.core.impl.score.stream.drools.common.UniConstraintIntConsequence;
import org.optaplanner.core.impl.score.stream.drools.common.UniConstraintLongConsequence;

public final class UniLeftHandSide<A>
extends AbstractLeftHandSide {
    private final PatternVariable<A> patternVariable;

    public UniLeftHandSide(Class<A> aClass, DroolsVariableFactory variableFactory) {
        super(variableFactory);
        this.patternVariable = new PatternVariable<A>(variableFactory.createVariable(aClass, "var"));
    }

    protected UniLeftHandSide(UniLeftHandSide<A> leftHandSide, PatternVariable<A> patternVariable) {
        super(leftHandSide.variableFactory);
        this.patternVariable = patternVariable;
    }

    protected UniLeftHandSide(PatternVariable<A> patternVariable, DroolsVariableFactory variableFactory) {
        super(variableFactory);
        this.patternVariable = patternVariable;
    }

    protected PatternVariable<A> getPatternVariableA() {
        return this.patternVariable;
    }

    public UniLeftHandSide<A> andFilter(Predicate<A> predicate) {
        return new UniLeftHandSide<A>(this, this.patternVariable.filter(predicate));
    }

    private <B> UniLeftHandSide<A> applyJoiners(Class<B> bClass, AbstractBiJoiner<A, B> joiner, BiPredicate<A, B> predicate, boolean shouldExist) {
        Function<A, Object> leftMapping;
        int mappingIndex;
        Variable<B> toExist = this.variableFactory.createVariable(bClass, "toExist");
        PatternDSL.PatternDef existencePattern = PatternDSL.pattern(toExist);
        if (joiner == null) {
            return this.applyFilters(this.patternVariable, existencePattern, predicate, shouldExist);
        }
        PatternVariable<A> newPatternVariable = this.patternVariable;
        JoinerType[] joinerTypes = joiner.getJoinerTypes();
        Variable[] joinVars = new Variable[joinerTypes.length];
        for (mappingIndex = 0; mappingIndex < joinerTypes.length; ++mappingIndex) {
            Variable joinVar = this.variableFactory.createVariable("joinVar");
            leftMapping = joiner.getLeftMapping(mappingIndex);
            newPatternVariable = newPatternVariable.bind(joinVar, leftMapping);
            joinVars[mappingIndex] = joinVar;
        }
        for (mappingIndex = 0; mappingIndex < joinerTypes.length; ++mappingIndex) {
            JoinerType joinerType = joinerTypes[mappingIndex];
            leftMapping = joiner.getLeftMapping(mappingIndex);
            Function rightMapping = joiner.getRightMapping(mappingIndex);
            Predicate2 & Serializable joinPredicate = (Predicate2 & Serializable)(b, a) -> joinerType.matches(a, rightMapping.apply(b));
            BetaIndex index = PatternDSL.betaIndexedBy(Object.class, (Index.ConstraintType)UniLeftHandSide.getConstraintType(joinerType), (int)mappingIndex, rightMapping::apply, leftMapping::apply);
            existencePattern = existencePattern.expr("Join using joiner #" + mappingIndex + " in " + joiner, joinVars[mappingIndex], (Predicate2)joinPredicate, index);
        }
        return this.applyFilters(newPatternVariable, existencePattern, predicate, shouldExist);
    }

    private <B> UniLeftHandSide<A> applyFilters(PatternVariable<A> newPatternVariable, PatternDSL.PatternDef<B> existencePattern, BiPredicate<A, B> biPredicate, boolean shouldExist) {
        PatternDSL.PatternDef possiblyFilteredExistencePattern = biPredicate == null ? existencePattern : existencePattern.expr("Filter using " + biPredicate, newPatternVariable.getPrimaryVariable(), (Predicate2 & Serializable)(b, a) -> biPredicate.test(a, b));
        ExprViewItem existenceExpression = DSL.exists(possiblyFilteredExistencePattern, (ViewItemBuilder[])new ViewItemBuilder[0]);
        if (!shouldExist) {
            existenceExpression = DSL.not(possiblyFilteredExistencePattern, (ViewItemBuilder[])new ViewItemBuilder[0]);
        }
        return new UniLeftHandSide<A>(this, newPatternVariable.addDependentExpression((ViewItem<?>)existenceExpression));
    }

    private <B> UniLeftHandSide<A> existsOrNot(Class<B> bClass, BiJoiner<A, B>[] joiners, boolean shouldExist) {
        int indexOfFirstFilter = -1;
        AbstractBiJoiner finalJoiner = null;
        BiPredicate finalFilter = null;
        for (int i = 0; i < joiners.length; ++i) {
            boolean hasAFilter;
            AbstractBiJoiner biJoiner = (AbstractBiJoiner)joiners[i];
            boolean bl = hasAFilter = indexOfFirstFilter >= 0;
            if (biJoiner instanceof NoneBiJoiner && joiners.length > 1) {
                throw new IllegalStateException("If present, " + NoneBiJoiner.class + " must be the only joiner, got " + Arrays.toString(joiners) + " instead.");
            }
            if (!(biJoiner instanceof FilteringBiJoiner)) {
                if (hasAFilter) {
                    throw new IllegalStateException("Indexing joiner (" + biJoiner + ") must not follow a filtering joiner (" + joiners[indexOfFirstFilter] + ").");
                }
                finalJoiner = finalJoiner == null ? biJoiner : AbstractBiJoiner.merge(finalJoiner, biJoiner);
                continue;
            }
            if (!hasAFilter) {
                indexOfFirstFilter = i;
            }
            finalFilter = finalFilter == null ? biJoiner.getFilter() : finalFilter.and(biJoiner.getFilter());
        }
        return this.applyJoiners(bClass, finalJoiner, finalFilter, shouldExist);
    }

    public <B> UniLeftHandSide<A> andExists(Class<B> bClass, BiJoiner<A, B>[] joiners) {
        return this.existsOrNot(bClass, joiners, true);
    }

    public <B> UniLeftHandSide<A> andNotExists(Class<B> bClass, BiJoiner<A, B>[] joiners) {
        return this.existsOrNot(bClass, joiners, false);
    }

    public <B> BiLeftHandSide<A, B> andJoin(UniLeftHandSide<B> right, BiJoiner<A, B> joiner) {
        AbstractBiJoiner castJoiner = (AbstractBiJoiner)joiner;
        JoinerType[] joinerTypes = castJoiner.getJoinerTypes();
        PatternVariable newLeft = this.patternVariable;
        Variable[] joinVars = new Variable[joinerTypes.length];
        for (int mappingIndex = 0; mappingIndex < joinerTypes.length; ++mappingIndex) {
            Variable joinVar = this.variableFactory.createVariable("joinVar" + mappingIndex);
            newLeft = newLeft.bind(joinVar, castJoiner.getLeftMapping(mappingIndex));
            joinVars[mappingIndex] = joinVar;
        }
        PatternVariable<A> newRight = right.patternVariable;
        for (int mappingIndex = 0; mappingIndex < joinerTypes.length; ++mappingIndex) {
            JoinerType joinerType = joinerTypes[mappingIndex];
            newRight = newRight.filterOnJoinVar(joinVars[mappingIndex], castJoiner, joinerType, mappingIndex);
        }
        return new BiLeftHandSide<A, A>(newLeft, newRight, this.variableFactory);
    }

    public <NewA> UniLeftHandSide<NewA> andGroupBy(Function<A, NewA> keyMapping) {
        Variable<A> input = this.patternVariable.getPrimaryVariable();
        Variable groupKey = this.variableFactory.createVariable("groupKey");
        ViewItem<?> innerGroupByPattern = UniLeftHandSide.joinViewItemsWithLogicalAnd(this.patternVariable);
        ExprViewItem groupByPattern = DSL.groupBy(innerGroupByPattern, input, groupKey, keyMapping::apply, (AccumulateFunction[])new AccumulateFunction[0]);
        Variable newA = this.variableFactory.createVariable("newA", groupKey);
        return new UniLeftHandSide(new PatternVariable(newA, Collections.singletonList(groupByPattern)), this.variableFactory);
    }

    public <NewA> UniLeftHandSide<NewA> andGroupBy(UniConstraintCollector<A, ?, NewA> collector) {
        Variable accumulateOutput = this.variableFactory.createVariable("collected");
        ViewItem<?> innerAccumulatePattern = UniLeftHandSide.joinViewItemsWithLogicalAnd(this.patternVariable);
        ExprViewItem outerAccumulatePattern = DSL.accumulate(innerAccumulatePattern, (AccumulateFunction)this.createAccumulateFunction(collector, accumulateOutput), (AccumulateFunction[])new AccumulateFunction[0]);
        return new UniLeftHandSide(new PatternVariable(accumulateOutput, Collections.singletonList(outerAccumulatePattern)), this.variableFactory);
    }

    private <Out> AccumulateFunction createAccumulateFunction(UniConstraintCollector<A, ?, Out> collector, Variable<Out> out) {
        return DSL.accFunction(() -> new DroolsUniAccumulateFunction(collector), this.patternVariable.getPrimaryVariable()).as(out);
    }

    public <NewA, NewB> BiLeftHandSide<NewA, NewB> andGroupBy(Function<A, NewA> keyMappingA, Function<A, NewB> keyMappingB) {
        Variable<A> input = this.patternVariable.getPrimaryVariable();
        Variable<BiTuple> groupKey = this.variableFactory.createVariable(BiTuple.class, "groupKey");
        ViewItem<?> innerGroupByPattern = UniLeftHandSide.joinViewItemsWithLogicalAnd(this.patternVariable);
        ExprViewItem groupByPattern = DSL.groupBy(innerGroupByPattern, input, groupKey, (Function1 & Serializable)a -> new BiTuple(keyMappingA.apply(a), keyMappingB.apply(a)), (AccumulateFunction[])new AccumulateFunction[0]);
        Variable<Object> newA = this.variableFactory.createVariable("newA", groupKey, k -> k.a);
        Variable<Object> newB = this.variableFactory.createVariable("newB", groupKey, k -> k.b);
        return new BiLeftHandSide<Object, Object>(new PatternVariable<Object>(newA, Collections.singletonList(groupByPattern)), new PatternVariable<Object>(newB), this.variableFactory);
    }

    public <NewA, NewB> BiLeftHandSide<NewA, NewB> andGroupBy(Function<A, NewA> keyMappingA, UniConstraintCollector<A, ?, NewB> collectorB) {
        Variable<A> input = this.patternVariable.getPrimaryVariable();
        Variable groupKey = this.variableFactory.createVariable("groupKey");
        Variable accumulateOutput = this.variableFactory.createVariable("output");
        ViewItem<?> innerGroupByPattern = UniLeftHandSide.joinViewItemsWithLogicalAnd(this.patternVariable);
        ExprViewItem groupByPattern = DSL.groupBy(innerGroupByPattern, input, groupKey, keyMappingA::apply, (AccumulateFunction[])new AccumulateFunction[]{this.createAccumulateFunction(collectorB, accumulateOutput)});
        Variable newA = this.variableFactory.createVariable("newA", groupKey);
        Variable newB = this.variableFactory.createVariable("newB", accumulateOutput);
        return new BiLeftHandSide(new PatternVariable(newA, Collections.singletonList(groupByPattern)), new PatternVariable(newB), this.variableFactory);
    }

    public <NewA, NewB, NewC> TriLeftHandSide<NewA, NewB, NewC> andGroupBy(Function<A, NewA> keyMappingA, Function<A, NewB> keyMappingB, UniConstraintCollector<A, ?, NewC> collectorC) {
        Variable<A> input = this.patternVariable.getPrimaryVariable();
        Variable<BiTuple> groupKey = this.variableFactory.createVariable(BiTuple.class, "groupKey");
        Variable accumulateOutput = this.variableFactory.createVariable("output");
        ViewItem<?> innerGroupByPattern = UniLeftHandSide.joinViewItemsWithLogicalAnd(this.patternVariable);
        ExprViewItem groupByPattern = DSL.groupBy(innerGroupByPattern, input, groupKey, (Function1 & Serializable)a -> new BiTuple(keyMappingA.apply(a), keyMappingB.apply(a)), (AccumulateFunction[])new AccumulateFunction[]{this.createAccumulateFunction(collectorC, accumulateOutput)});
        Variable<Object> newA = this.variableFactory.createVariable("newA", groupKey, k -> k.a);
        Variable<Object> newB = this.variableFactory.createVariable("newB", groupKey, k -> k.b);
        Variable newC = this.variableFactory.createVariable("newC", accumulateOutput);
        return new TriLeftHandSide(new PatternVariable<Object>(newA, Collections.singletonList(groupByPattern)), new PatternVariable<Object>(newB), new PatternVariable(newC), this.variableFactory);
    }

    public <NewA, NewB, NewC, NewD> QuadLeftHandSide<NewA, NewB, NewC, NewD> andGroupBy(Function<A, NewA> keyMappingA, Function<A, NewB> keyMappingB, UniConstraintCollector<A, ?, NewC> collectorC, UniConstraintCollector<A, ?, NewD> collectorD) {
        Variable<A> input = this.patternVariable.getPrimaryVariable();
        Variable<BiTuple> groupKey = this.variableFactory.createVariable(BiTuple.class, "groupKey");
        Variable accumulateOutputC = this.variableFactory.createVariable("outputC");
        Variable accumulateOutputD = this.variableFactory.createVariable("outputD");
        ViewItem<?> innerGroupByPattern = UniLeftHandSide.joinViewItemsWithLogicalAnd(this.patternVariable);
        ExprViewItem groupByPattern = DSL.groupBy(innerGroupByPattern, input, groupKey, (Function1 & Serializable)a -> new BiTuple(keyMappingA.apply(a), keyMappingB.apply(a)), (AccumulateFunction[])new AccumulateFunction[]{this.createAccumulateFunction(collectorC, accumulateOutputC), this.createAccumulateFunction(collectorD, accumulateOutputD)});
        Variable<Object> newA = this.variableFactory.createVariable("newA", groupKey, k -> k.a);
        Variable<Object> newB = this.variableFactory.createVariable("newB", groupKey, k -> k.b);
        Variable newC = this.variableFactory.createVariable("newC", accumulateOutputC);
        Variable newD = this.variableFactory.createVariable("newD", accumulateOutputD);
        return new QuadLeftHandSide(new PatternVariable<Object>(newA, Collections.singletonList(groupByPattern)), new PatternVariable<Object>(newB), new PatternVariable(newC), new PatternVariable(newD), this.variableFactory);
    }

    public AbstractUniConstraintConsequence<A> andTerminate() {
        return new UniConstraintDefaultConsequence(this);
    }

    public AbstractUniConstraintConsequence<A> andTerminate(ToIntFunction<A> matchWeighter) {
        return new UniConstraintIntConsequence<A>(this, matchWeighter);
    }

    public AbstractUniConstraintConsequence<A> andTerminate(ToLongFunction<A> matchWeighter) {
        return new UniConstraintLongConsequence<A>(this, matchWeighter);
    }

    public AbstractUniConstraintConsequence<A> andTerminate(Function<A, BigDecimal> matchWeighter) {
        return new UniConstraintBigDecimalConsequence<A>(this, matchWeighter);
    }

    @Override
    public List<ViewItem<?>> get() {
        return this.patternVariable.build();
    }

    @Override
    public Variable[] getVariables() {
        return new Variable[]{this.patternVariable.getPrimaryVariable()};
    }
}

