/*
 * Copyright 2020 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.optaplanner.core.api.domain.common;

/**
 * Determines how members (fields and methods) of
 * the domain are accessed.
 */
public enum DomainAccessType {
    /**
     * Use reflection to read the member. Always work, but slow.
     */
    REFLECTION,

    /**
     * Uses Gizmo generated bytecode to access members (field and method)
     * of the domain for performance, instead of reflection. When used without Quarkus,
     * the planning annotations must be on public members and Gizmo must be added
     * on the classpath or modulepath.
     */
    GIZMO
}
