/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.flightcrewscheduling.domain;

import java.time.LocalDate;
import java.util.Set;
import java.util.SortedSet;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.variable.InverseRelationShadowVariable;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.flightcrewscheduling.domain.Airport;
import org.optaplanner.examples.flightcrewscheduling.domain.FlightAssignment;
import org.optaplanner.examples.flightcrewscheduling.domain.Skill;

@PlanningEntity
public class Employee
extends AbstractPersistable {
    private String name;
    private Airport homeAirport;
    private Set<Skill> skillSet;
    private Set<LocalDate> unavailableDaySet;
    @InverseRelationShadowVariable(sourceVariableName="employee")
    private SortedSet<FlightAssignment> flightAssignmentSet;

    public Employee() {
    }

    public Employee(long id, String name, Airport homeAirport) {
        super(id);
        this.name = name;
        this.homeAirport = homeAirport;
    }

    public boolean hasSkill(Skill skill) {
        return this.skillSet.contains(skill);
    }

    public boolean isAvailable(LocalDate date) {
        return !this.unavailableDaySet.contains(date);
    }

    public boolean isFirstAssignmentDepartingFromHome() {
        if (this.flightAssignmentSet.isEmpty()) {
            return true;
        }
        FlightAssignment firstAssignment = this.flightAssignmentSet.first();
        return firstAssignment.getFlight().getDepartureAirport() == this.homeAirport;
    }

    public boolean isLastAssignmentArrivingAtHome() {
        if (this.flightAssignmentSet.isEmpty()) {
            return true;
        }
        FlightAssignment lastAssignment = this.flightAssignmentSet.last();
        return lastAssignment.getFlight().getArrivalAirport() == this.homeAirport;
    }

    public long countInvalidConnections() {
        long count = 0L;
        FlightAssignment previousAssignment = null;
        for (FlightAssignment assignment : this.flightAssignmentSet) {
            if (previousAssignment != null && previousAssignment.getFlight().getArrivalAirport() != assignment.getFlight().getDepartureAirport()) {
                ++count;
            }
            previousAssignment = assignment;
        }
        return count;
    }

    public long getFlightDurationTotalInMinutes() {
        long total = 0L;
        for (FlightAssignment flightAssignment : this.flightAssignmentSet) {
            total += flightAssignment.getFlightDurationInMinutes();
        }
        return total;
    }

    @Override
    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Airport getHomeAirport() {
        return this.homeAirport;
    }

    public void setHomeAirport(Airport homeAirport) {
        this.homeAirport = homeAirport;
    }

    public Set<Skill> getSkillSet() {
        return this.skillSet;
    }

    public void setSkillSet(Set<Skill> skillSet) {
        this.skillSet = skillSet;
    }

    public Set<LocalDate> getUnavailableDaySet() {
        return this.unavailableDaySet;
    }

    public void setUnavailableDaySet(Set<LocalDate> unavailableDaySet) {
        this.unavailableDaySet = unavailableDaySet;
    }

    public SortedSet<FlightAssignment> getFlightAssignmentSet() {
        return this.flightAssignmentSet;
    }

    public void setFlightAssignmentSet(SortedSet<FlightAssignment> flightAssignmentSet) {
        this.flightAssignmentSet = flightAssignmentSet;
    }
}

