/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.projectjobscheduling.domain.solver;

import java.util.ArrayDeque;
import java.util.Objects;
import org.optaplanner.core.api.domain.variable.VariableListener;
import org.optaplanner.core.api.score.director.ScoreDirector;
import org.optaplanner.examples.projectjobscheduling.domain.Allocation;
import org.optaplanner.examples.projectjobscheduling.domain.Schedule;

public class PredecessorsDoneDateUpdatingVariableListener
implements VariableListener<Schedule, Allocation> {
    public void beforeEntityAdded(ScoreDirector<Schedule> scoreDirector, Allocation allocation) {
    }

    public void afterEntityAdded(ScoreDirector<Schedule> scoreDirector, Allocation allocation) {
        this.updateAllocation(scoreDirector, allocation);
    }

    public void beforeVariableChanged(ScoreDirector<Schedule> scoreDirector, Allocation allocation) {
    }

    public void afterVariableChanged(ScoreDirector<Schedule> scoreDirector, Allocation allocation) {
        this.updateAllocation(scoreDirector, allocation);
    }

    public void beforeEntityRemoved(ScoreDirector<Schedule> scoreDirector, Allocation allocation) {
    }

    public void afterEntityRemoved(ScoreDirector<Schedule> scoreDirector, Allocation allocation) {
    }

    protected void updateAllocation(ScoreDirector<Schedule> scoreDirector, Allocation originalAllocation) {
        ArrayDeque<Allocation> uncheckedSuccessorQueue = new ArrayDeque<Allocation>();
        uncheckedSuccessorQueue.addAll(originalAllocation.getSuccessorAllocationList());
        while (!uncheckedSuccessorQueue.isEmpty()) {
            Allocation allocation = (Allocation)uncheckedSuccessorQueue.remove();
            boolean updated = this.updatePredecessorsDoneDate(scoreDirector, allocation);
            if (!updated) continue;
            uncheckedSuccessorQueue.addAll(allocation.getSuccessorAllocationList());
        }
    }

    protected boolean updatePredecessorsDoneDate(ScoreDirector<Schedule> scoreDirector, Allocation allocation) {
        Integer doneDate = 0;
        for (Allocation predecessorAllocation : allocation.getPredecessorAllocationList()) {
            int endDate = predecessorAllocation.getEndDate();
            doneDate = Math.max(doneDate, endDate);
        }
        if (Objects.equals(doneDate, allocation.getPredecessorsDoneDate())) {
            return false;
        }
        scoreDirector.beforeVariableChanged((Object)allocation, "predecessorsDoneDate");
        allocation.setPredecessorsDoneDate(doneDate);
        scoreDirector.afterVariableChanged((Object)allocation, "predecessorsDoneDate");
        return true;
    }
}

