/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.migration.v8;

import java.util.Arrays;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.template.SourceTemplate;

public class ScoreManagerMethodsRecipe
extends Recipe {
    private static final MatcherMeta[] MATCHER_METAS = new MatcherMeta[]{new MatcherMeta("getSummary(..)"), new MatcherMeta("explainScore(..)"), new MatcherMeta("updateScore(..)")};

    public String getDisplayName() {
        return "ScoreManager: explain(), update()";
    }

    public String getDescription() {
        return "Use `explain()` and `update()`    instead of `explainScore()`, `updateScore()` and `getSummary()`.";
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.CompilationUnit visitCompilationUnit(J.CompilationUnit compilationUnit, ExecutionContext executionContext) {
                for (MatcherMeta matcherMeta : MATCHER_METAS) {
                    this.doAfterVisit((TreeVisitor)new UsesMethod(matcherMeta.methodMatcher));
                }
                return compilationUnit;
            }
        };
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public Expression visitExpression(Expression expression, ExecutionContext executionContext) {
                Expression e = super.visitExpression(expression, (Object)executionContext);
                MatcherMeta matcherMeta = Arrays.stream(MATCHER_METAS).filter(m -> m.methodMatcher.matches(e)).findFirst().orElse(null);
                if (matcherMeta == null) {
                    return e;
                }
                J.MethodInvocation mi = (J.MethodInvocation)e;
                Expression select = mi.getSelect();
                List arguments = mi.getArguments();
                String pattern = "#{any(" + matcherMeta.classFqn + ")}." + (matcherMeta.methodName.contains("Summary") ? "explain(#{any()}, SolutionUpdatePolicy.UPDATE_SCORE_ONLY).getSummary()" : matcherMeta.methodName.replace(")", ", SolutionUpdatePolicy.UPDATE_SCORE_ONLY)").replace("..", "#{any()}").replace("Score(", "("));
                this.maybeAddImport("org.optaplanner.core.api.solver.SolutionUpdatePolicy");
                JavaTemplate template = JavaTemplate.builder(() -> this.getCursor().getParentOrThrow(), (String)pattern).javaParser(() -> ScoreManagerMethodsRecipe.buildJavaParser().build()).imports(new String[]{"org.optaplanner.core.api.solver.SolutionUpdatePolicy"}).build();
                return (Expression)e.withTemplate((SourceTemplate)template, e.getCoordinates().replace(), new Object[]{select, arguments.get(0)});
            }
        };
    }

    public static JavaParser.Builder buildJavaParser() {
        return JavaParser.fromJavaVersion().classpath(new String[]{"optaplanner-core-impl"});
    }

    private static final class MatcherMeta {
        public final String classFqn;
        public final MethodMatcher methodMatcher;
        public final String methodName;

        public MatcherMeta(String method) {
            this.classFqn = "org.optaplanner.core.api.score.ScoreManager";
            this.methodMatcher = new MethodMatcher(this.classFqn + " " + method);
            this.methodName = method;
        }
    }
}

