/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.migration.v8;

import org.junit.jupiter.api.Test;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.java.Assertions;
import org.openrewrite.test.RecipeSpec;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpecs;
import org.optaplanner.migration.v8.AsConstraintRecipe;

class AsConstraintRecipeTest
implements RewriteTest {
    AsConstraintRecipeTest() {
    }

    public void defaults(RecipeSpec spec) {
        spec.recipe((Recipe)new AsConstraintRecipe()).parser((Parser.Builder)AsConstraintRecipe.buildJavaParser());
    }

    @Test
    void uniPenalizeName() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .penalize(\"My constraint\", HardSoftScore.ONE_HARD);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .penalize(HardSoftScore.ONE_HARD)\n                .asConstraint(\"My constraint\");"))});
    }

    @Test
    void uniPenalizeId() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .penalize(\"My package\", \"My constraint\", HardSoftScore.ONE_HARD);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .penalize(HardSoftScore.ONE_HARD)\n                .asConstraint(\"My package\", \"My constraint\");"))});
    }

    @Test
    void uniPenalizeConfigurableName() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .penalizeConfigurable(\"My constraint\");"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .penalizeConfigurable()\n                .asConstraint(\"My constraint\");"))});
    }

    @Test
    void uniPenalizeConfigurableId() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .penalizeConfigurable(\"My package\", \"My constraint\");"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .penalizeConfigurable()\n                .asConstraint(\"My package\", \"My constraint\");"))});
    }

    @Test
    void uniPenalizeNameMatchWeigherInt() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .penalize(\"My constraint\", HardSoftScore.ONE_HARD, (a) -> 7);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .penalize(HardSoftScore.ONE_HARD, (a) -> 7)\n                .asConstraint(\"My constraint\");"))});
    }

    @Test
    void uniPenalizeIdMatchWeigherInt() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .penalize(\"My package\", \"My constraint\", HardSoftScore.ONE_HARD, (a) -> 7);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .penalize(HardSoftScore.ONE_HARD, (a) -> 7)\n                .asConstraint(\"My package\", \"My constraint\");"))});
    }

    @Test
    void uniPenalizeConfigurableNameMatchWeigherInt() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .penalizeConfigurable(\"My constraint\", (a) -> 7);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .penalizeConfigurable((a) -> 7)\n                .asConstraint(\"My constraint\");"))});
    }

    @Test
    void uniPenalizeConfigurableIdMatchWeigherInt() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .penalizeConfigurable(\"My package\", \"My constraint\", (a) -> 7);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .penalizeConfigurable((a) -> 7)\n                .asConstraint(\"My package\", \"My constraint\");"))});
    }

    @Test
    void uniPenalizeNameMatchWeigherLong() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .penalizeLong(\"My constraint\", HardSoftLongScore.ONE_HARD, (a) -> 7L);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .penalizeLong(HardSoftLongScore.ONE_HARD, (a) -> 7L)\n                .asConstraint(\"My constraint\");"))});
    }

    @Test
    void uniPenalizeIdMatchWeigherLong() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .penalizeLong(\"My package\", \"My constraint\", HardSoftLongScore.ONE_HARD, (a) -> 7L);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .penalizeLong(HardSoftLongScore.ONE_HARD, (a) -> 7L)\n                .asConstraint(\"My package\", \"My constraint\");"))});
    }

    @Test
    void uniPenalizeConfigurableNameMatchWeigherLong() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .penalizeConfigurableLong(\"My constraint\", (a) -> 7L);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .penalizeConfigurableLong((a) -> 7L)\n                .asConstraint(\"My constraint\");"))});
    }

    @Test
    void uniPenalizeConfigurableIdMatchWeigherLong() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .penalizeConfigurableLong(\"My package\", \"My constraint\", (a) -> 7L);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .penalizeConfigurableLong((a) -> 7L)\n                .asConstraint(\"My package\", \"My constraint\");"))});
    }

    @Test
    void uniPenalizeNameMatchWeigherBigDecimal() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .penalizeBigDecimal(\"My constraint\", HardSoftBigDecimalScore.ONE_HARD, (a) -> BigDecimal.TEN);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .penalizeBigDecimal(HardSoftBigDecimalScore.ONE_HARD, (a) -> BigDecimal.TEN)\n                .asConstraint(\"My constraint\");"))});
    }

    @Test
    void uniPenalizeIdMatchWeigherBigDecimal() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .penalizeBigDecimal(\"My package\", \"My constraint\", HardSoftBigDecimalScore.ONE_HARD, (a) -> BigDecimal.TEN);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .penalizeBigDecimal(HardSoftBigDecimalScore.ONE_HARD, (a) -> BigDecimal.TEN)\n                .asConstraint(\"My package\", \"My constraint\");"))});
    }

    @Test
    void uniPenalizeConfigurableNameMatchWeigherBigDecimal() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .penalizeConfigurableBigDecimal(\"My constraint\", (a) -> BigDecimal.TEN);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .penalizeConfigurableBigDecimal((a) -> BigDecimal.TEN)\n                .asConstraint(\"My constraint\");"))});
    }

    @Test
    void uniPenalizeConfigurableIdMatchWeigherBigDecimal() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .penalizeConfigurableBigDecimal(\"My package\", \"My constraint\", (a) -> BigDecimal.TEN);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .penalizeConfigurableBigDecimal((a) -> BigDecimal.TEN)\n                .asConstraint(\"My package\", \"My constraint\");"))});
    }

    @Test
    void uniRewardName() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .reward(\"My constraint\", HardSoftScore.ONE_HARD);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .reward(HardSoftScore.ONE_HARD)\n                .asConstraint(\"My constraint\");"))});
    }

    @Test
    void uniRewardId() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .reward(\"My package\", \"My constraint\", HardSoftScore.ONE_HARD);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .reward(HardSoftScore.ONE_HARD)\n                .asConstraint(\"My package\", \"My constraint\");"))});
    }

    @Test
    void uniRewardConfigurableName() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .rewardConfigurable(\"My constraint\");"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .rewardConfigurable()\n                .asConstraint(\"My constraint\");"))});
    }

    @Test
    void uniRewardConfigurableId() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .rewardConfigurable(\"My package\", \"My constraint\");"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .rewardConfigurable()\n                .asConstraint(\"My package\", \"My constraint\");"))});
    }

    @Test
    void uniRewardNameMatchWeigherInt() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .reward(\"My constraint\", HardSoftScore.ONE_HARD, (a) -> 7);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .reward(HardSoftScore.ONE_HARD, (a) -> 7)\n                .asConstraint(\"My constraint\");"))});
    }

    @Test
    void uniRewardIdMatchWeigherInt() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .reward(\"My package\", \"My constraint\", HardSoftScore.ONE_HARD, (a) -> 7);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .reward(HardSoftScore.ONE_HARD, (a) -> 7)\n                .asConstraint(\"My package\", \"My constraint\");"))});
    }

    @Test
    void uniRewardConfigurableNameMatchWeigherInt() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .rewardConfigurable(\"My constraint\", (a) -> 7);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .rewardConfigurable((a) -> 7)\n                .asConstraint(\"My constraint\");"))});
    }

    @Test
    void uniRewardConfigurableIdMatchWeigherInt() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .rewardConfigurable(\"My package\", \"My constraint\", (a) -> 7);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .rewardConfigurable((a) -> 7)\n                .asConstraint(\"My package\", \"My constraint\");"))});
    }

    @Test
    void uniRewardNameMatchWeigherLong() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .rewardLong(\"My constraint\", HardSoftLongScore.ONE_HARD, (a) -> 7L);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .rewardLong(HardSoftLongScore.ONE_HARD, (a) -> 7L)\n                .asConstraint(\"My constraint\");"))});
    }

    @Test
    void uniRewardIdMatchWeigherLong() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .rewardLong(\"My package\", \"My constraint\", HardSoftLongScore.ONE_HARD, (a) -> 7L);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .rewardLong(HardSoftLongScore.ONE_HARD, (a) -> 7L)\n                .asConstraint(\"My package\", \"My constraint\");"))});
    }

    @Test
    void uniRewardConfigurableNameMatchWeigherLong() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .rewardConfigurableLong(\"My constraint\", (a) -> 7L);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .rewardConfigurableLong((a) -> 7L)\n                .asConstraint(\"My constraint\");"))});
    }

    @Test
    void uniRewardConfigurableIdMatchWeigherLong() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .rewardConfigurableLong(\"My package\", \"My constraint\", (a) -> 7L);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .rewardConfigurableLong((a) -> 7L)\n                .asConstraint(\"My package\", \"My constraint\");"))});
    }

    @Test
    void uniRewardNameMatchWeigherBigDecimal() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .rewardBigDecimal(\"My constraint\", HardSoftBigDecimalScore.ONE_HARD, (a) -> BigDecimal.TEN);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .rewardBigDecimal(HardSoftBigDecimalScore.ONE_HARD, (a) -> BigDecimal.TEN)\n                .asConstraint(\"My constraint\");"))});
    }

    @Test
    void uniRewardIdMatchWeigherBigDecimal() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .rewardBigDecimal(\"My package\", \"My constraint\", HardSoftBigDecimalScore.ONE_HARD, (a) -> BigDecimal.TEN);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .rewardBigDecimal(HardSoftBigDecimalScore.ONE_HARD, (a) -> BigDecimal.TEN)\n                .asConstraint(\"My package\", \"My constraint\");"))});
    }

    @Test
    void uniRewardConfigurableNameMatchWeigherBigDecimal() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .rewardConfigurableBigDecimal(\"My constraint\", (a) -> BigDecimal.TEN);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .rewardConfigurableBigDecimal((a) -> BigDecimal.TEN)\n                .asConstraint(\"My constraint\");"))});
    }

    @Test
    void uniRewardConfigurableIdMatchWeigherBigDecimal() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .rewardConfigurableBigDecimal(\"My package\", \"My constraint\", (a) -> BigDecimal.TEN);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .rewardConfigurableBigDecimal((a) -> BigDecimal.TEN)\n                .asConstraint(\"My package\", \"My constraint\");"))});
    }

    @Test
    void uniImpactName() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .impact(\"My constraint\", HardSoftScore.ONE_HARD);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .impact(HardSoftScore.ONE_HARD)\n                .asConstraint(\"My constraint\");"))});
    }

    @Test
    void uniImpactId() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .impact(\"My package\", \"My constraint\", HardSoftScore.ONE_HARD);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .impact(HardSoftScore.ONE_HARD)\n                .asConstraint(\"My package\", \"My constraint\");"))});
    }

    @Test
    void uniImpactNameMatchWeigherInt() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .impact(\"My constraint\", HardSoftScore.ONE_HARD, (a) -> 7);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .impact(HardSoftScore.ONE_HARD, (a) -> 7)\n                .asConstraint(\"My constraint\");"))});
    }

    @Test
    void uniImpactIdMatchWeigherInt() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .impact(\"My package\", \"My constraint\", HardSoftScore.ONE_HARD, (a) -> 7);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .impact(HardSoftScore.ONE_HARD, (a) -> 7)\n                .asConstraint(\"My package\", \"My constraint\");"))});
    }

    @Test
    void uniImpactNameMatchWeigherLong() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .impactLong(\"My constraint\", HardSoftLongScore.ONE_HARD, (a) -> 7L);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .impactLong(HardSoftLongScore.ONE_HARD, (a) -> 7L)\n                .asConstraint(\"My constraint\");"))});
    }

    @Test
    void uniImpactIdMatchWeigherLong() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .impactLong(\"My package\", \"My constraint\", HardSoftLongScore.ONE_HARD, (a) -> 7L);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .impactLong(HardSoftLongScore.ONE_HARD, (a) -> 7L)\n                .asConstraint(\"My package\", \"My constraint\");"))});
    }

    @Test
    void uniImpactNameMatchWeigherBigDecimal() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .impactBigDecimal(\"My constraint\", HardSoftBigDecimalScore.ONE_HARD, (a) -> BigDecimal.TEN);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .impactBigDecimal(HardSoftBigDecimalScore.ONE_HARD, (a) -> BigDecimal.TEN)\n                .asConstraint(\"My constraint\");"))});
    }

    @Test
    void uniImpactIdMatchWeigherBigDecimal() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .impactBigDecimal(\"My package\", \"My constraint\", HardSoftBigDecimalScore.ONE_HARD, (a) -> BigDecimal.TEN);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .impactBigDecimal(HardSoftBigDecimalScore.ONE_HARD, (a) -> BigDecimal.TEN)\n                .asConstraint(\"My package\", \"My constraint\");"))});
    }

    @Test
    void biPenalizeName() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .penalize(\"My constraint\", HardSoftScore.ONE_HARD);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .penalize(HardSoftScore.ONE_HARD)\n                .asConstraint(\"My constraint\");"))});
    }

    @Test
    void biPenalizeId() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .penalize(\"My package\", \"My constraint\", HardSoftScore.ONE_HARD);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .penalize(HardSoftScore.ONE_HARD)\n                .asConstraint(\"My package\", \"My constraint\");"))});
    }

    @Test
    void biPenalizeConfigurableName() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .penalizeConfigurable(\"My constraint\");"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .penalizeConfigurable()\n                .asConstraint(\"My constraint\");"))});
    }

    @Test
    void biPenalizeConfigurableId() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .penalizeConfigurable(\"My package\", \"My constraint\");"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .penalizeConfigurable()\n                .asConstraint(\"My package\", \"My constraint\");"))});
    }

    @Test
    void biPenalizeNameMatchWeigherInt() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .penalize(\"My constraint\", HardSoftScore.ONE_HARD, (a, b) -> 7);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .penalize(HardSoftScore.ONE_HARD, (a, b) -> 7)\n                .asConstraint(\"My constraint\");"))});
    }

    @Test
    void biPenalizeIdMatchWeigherInt() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .penalize(\"My package\", \"My constraint\", HardSoftScore.ONE_HARD, (a, b) -> 7);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .penalize(HardSoftScore.ONE_HARD, (a, b) -> 7)\n                .asConstraint(\"My package\", \"My constraint\");"))});
    }

    @Test
    void biPenalizeConfigurableNameMatchWeigherInt() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .penalizeConfigurable(\"My constraint\", (a, b) -> 7);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .penalizeConfigurable((a, b) -> 7)\n                .asConstraint(\"My constraint\");"))});
    }

    @Test
    void biPenalizeConfigurableIdMatchWeigherInt() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .penalizeConfigurable(\"My package\", \"My constraint\", (a, b) -> 7);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .penalizeConfigurable((a, b) -> 7)\n                .asConstraint(\"My package\", \"My constraint\");"))});
    }

    @Test
    void biPenalizeNameMatchWeigherLong() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .penalizeLong(\"My constraint\", HardSoftLongScore.ONE_HARD, (a, b) -> 7L);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .penalizeLong(HardSoftLongScore.ONE_HARD, (a, b) -> 7L)\n                .asConstraint(\"My constraint\");"))});
    }

    @Test
    void biPenalizeIdMatchWeigherLong() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .penalizeLong(\"My package\", \"My constraint\", HardSoftLongScore.ONE_HARD, (a, b) -> 7L);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .penalizeLong(HardSoftLongScore.ONE_HARD, (a, b) -> 7L)\n                .asConstraint(\"My package\", \"My constraint\");"))});
    }

    @Test
    void biPenalizeConfigurableNameMatchWeigherLong() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .penalizeConfigurableLong(\"My constraint\", (a, b) -> 7L);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .penalizeConfigurableLong((a, b) -> 7L)\n                .asConstraint(\"My constraint\");"))});
    }

    @Test
    void biPenalizeConfigurableIdMatchWeigherLong() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .penalizeConfigurableLong(\"My package\", \"My constraint\", (a, b) -> 7L);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .penalizeConfigurableLong((a, b) -> 7L)\n                .asConstraint(\"My package\", \"My constraint\");"))});
    }

    @Test
    void biPenalizeNameMatchWeigherBigDecimal() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .penalizeBigDecimal(\"My constraint\", HardSoftBigDecimalScore.ONE_HARD, (a, b) -> BigDecimal.TEN);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .penalizeBigDecimal(HardSoftBigDecimalScore.ONE_HARD, (a, b) -> BigDecimal.TEN)\n                .asConstraint(\"My constraint\");"))});
    }

    @Test
    void biPenalizeIdMatchWeigherBigDecimal() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .penalizeBigDecimal(\"My package\", \"My constraint\", HardSoftBigDecimalScore.ONE_HARD, (a, b) -> BigDecimal.TEN);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .penalizeBigDecimal(HardSoftBigDecimalScore.ONE_HARD, (a, b) -> BigDecimal.TEN)\n                .asConstraint(\"My package\", \"My constraint\");"))});
    }

    @Test
    void biPenalizeConfigurableNameMatchWeigherBigDecimal() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .penalizeConfigurableBigDecimal(\"My constraint\", (a, b) -> BigDecimal.TEN);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .penalizeConfigurableBigDecimal((a, b) -> BigDecimal.TEN)\n                .asConstraint(\"My constraint\");"))});
    }

    @Test
    void biPenalizeConfigurableIdMatchWeigherBigDecimal() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .penalizeConfigurableBigDecimal(\"My package\", \"My constraint\", (a, b) -> BigDecimal.TEN);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .penalizeConfigurableBigDecimal((a, b) -> BigDecimal.TEN)\n                .asConstraint(\"My package\", \"My constraint\");"))});
    }

    @Test
    void biRewardName() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .reward(\"My constraint\", HardSoftScore.ONE_HARD);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .reward(HardSoftScore.ONE_HARD)\n                .asConstraint(\"My constraint\");"))});
    }

    @Test
    void biRewardId() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .reward(\"My package\", \"My constraint\", HardSoftScore.ONE_HARD);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .reward(HardSoftScore.ONE_HARD)\n                .asConstraint(\"My package\", \"My constraint\");"))});
    }

    @Test
    void biRewardConfigurableName() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .rewardConfigurable(\"My constraint\");"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .rewardConfigurable()\n                .asConstraint(\"My constraint\");"))});
    }

    @Test
    void biRewardConfigurableId() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .rewardConfigurable(\"My package\", \"My constraint\");"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .rewardConfigurable()\n                .asConstraint(\"My package\", \"My constraint\");"))});
    }

    @Test
    void biRewardNameMatchWeigherInt() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .reward(\"My constraint\", HardSoftScore.ONE_HARD, (a, b) -> 7);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .reward(HardSoftScore.ONE_HARD, (a, b) -> 7)\n                .asConstraint(\"My constraint\");"))});
    }

    @Test
    void biRewardIdMatchWeigherInt() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .reward(\"My package\", \"My constraint\", HardSoftScore.ONE_HARD, (a, b) -> 7);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .reward(HardSoftScore.ONE_HARD, (a, b) -> 7)\n                .asConstraint(\"My package\", \"My constraint\");"))});
    }

    @Test
    void biRewardConfigurableNameMatchWeigherInt() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .rewardConfigurable(\"My constraint\", (a, b) -> 7);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .rewardConfigurable((a, b) -> 7)\n                .asConstraint(\"My constraint\");"))});
    }

    @Test
    void biRewardConfigurableIdMatchWeigherInt() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .rewardConfigurable(\"My package\", \"My constraint\", (a, b) -> 7);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .rewardConfigurable((a, b) -> 7)\n                .asConstraint(\"My package\", \"My constraint\");"))});
    }

    @Test
    void biRewardNameMatchWeigherLong() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .rewardLong(\"My constraint\", HardSoftLongScore.ONE_HARD, (a, b) -> 7L);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .rewardLong(HardSoftLongScore.ONE_HARD, (a, b) -> 7L)\n                .asConstraint(\"My constraint\");"))});
    }

    @Test
    void biRewardIdMatchWeigherLong() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .rewardLong(\"My package\", \"My constraint\", HardSoftLongScore.ONE_HARD, (a, b) -> 7L);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .rewardLong(HardSoftLongScore.ONE_HARD, (a, b) -> 7L)\n                .asConstraint(\"My package\", \"My constraint\");"))});
    }

    @Test
    void biRewardConfigurableNameMatchWeigherLong() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .rewardConfigurableLong(\"My constraint\", (a, b) -> 7L);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .rewardConfigurableLong((a, b) -> 7L)\n                .asConstraint(\"My constraint\");"))});
    }

    @Test
    void biRewardConfigurableIdMatchWeigherLong() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .rewardConfigurableLong(\"My package\", \"My constraint\", (a, b) -> 7L);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .rewardConfigurableLong((a, b) -> 7L)\n                .asConstraint(\"My package\", \"My constraint\");"))});
    }

    @Test
    void biRewardNameMatchWeigherBigDecimal() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .rewardBigDecimal(\"My constraint\", HardSoftBigDecimalScore.ONE_HARD, (a, b) -> BigDecimal.TEN);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .rewardBigDecimal(HardSoftBigDecimalScore.ONE_HARD, (a, b) -> BigDecimal.TEN)\n                .asConstraint(\"My constraint\");"))});
    }

    @Test
    void biRewardIdMatchWeigherBigDecimal() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .rewardBigDecimal(\"My package\", \"My constraint\", HardSoftBigDecimalScore.ONE_HARD, (a, b) -> BigDecimal.TEN);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .rewardBigDecimal(HardSoftBigDecimalScore.ONE_HARD, (a, b) -> BigDecimal.TEN)\n                .asConstraint(\"My package\", \"My constraint\");"))});
    }

    @Test
    void biRewardConfigurableNameMatchWeigherBigDecimal() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .rewardConfigurableBigDecimal(\"My constraint\", (a, b) -> BigDecimal.TEN);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .rewardConfigurableBigDecimal((a, b) -> BigDecimal.TEN)\n                .asConstraint(\"My constraint\");"))});
    }

    @Test
    void biRewardConfigurableIdMatchWeigherBigDecimal() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .rewardConfigurableBigDecimal(\"My package\", \"My constraint\", (a, b) -> BigDecimal.TEN);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .rewardConfigurableBigDecimal((a, b) -> BigDecimal.TEN)\n                .asConstraint(\"My package\", \"My constraint\");"))});
    }

    @Test
    void biImpactName() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .impact(\"My constraint\", HardSoftScore.ONE_HARD);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .impact(HardSoftScore.ONE_HARD)\n                .asConstraint(\"My constraint\");"))});
    }

    @Test
    void biImpactId() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .impact(\"My package\", \"My constraint\", HardSoftScore.ONE_HARD);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .impact(HardSoftScore.ONE_HARD)\n                .asConstraint(\"My package\", \"My constraint\");"))});
    }

    @Test
    void biImpactNameMatchWeigherInt() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .impact(\"My constraint\", HardSoftScore.ONE_HARD, (a, b) -> 7);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .impact(HardSoftScore.ONE_HARD, (a, b) -> 7)\n                .asConstraint(\"My constraint\");"))});
    }

    @Test
    void biImpactIdMatchWeigherInt() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .impact(\"My package\", \"My constraint\", HardSoftScore.ONE_HARD, (a, b) -> 7);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .impact(HardSoftScore.ONE_HARD, (a, b) -> 7)\n                .asConstraint(\"My package\", \"My constraint\");"))});
    }

    @Test
    void biImpactNameMatchWeigherLong() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .impactLong(\"My constraint\", HardSoftLongScore.ONE_HARD, (a, b) -> 7L);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .impactLong(HardSoftLongScore.ONE_HARD, (a, b) -> 7L)\n                .asConstraint(\"My constraint\");"))});
    }

    @Test
    void biImpactIdMatchWeigherLong() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .impactLong(\"My package\", \"My constraint\", HardSoftLongScore.ONE_HARD, (a, b) -> 7L);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .impactLong(HardSoftLongScore.ONE_HARD, (a, b) -> 7L)\n                .asConstraint(\"My package\", \"My constraint\");"))});
    }

    @Test
    void biImpactNameMatchWeigherBigDecimal() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .impactBigDecimal(\"My constraint\", HardSoftBigDecimalScore.ONE_HARD, (a, b) -> BigDecimal.TEN);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .impactBigDecimal(HardSoftBigDecimalScore.ONE_HARD, (a, b) -> BigDecimal.TEN)\n                .asConstraint(\"My constraint\");"))});
    }

    @Test
    void biImpactIdMatchWeigherBigDecimal() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .impactBigDecimal(\"My package\", \"My constraint\", HardSoftBigDecimalScore.ONE_HARD, (a, b) -> BigDecimal.TEN);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .impactBigDecimal(HardSoftBigDecimalScore.ONE_HARD, (a, b) -> BigDecimal.TEN)\n                .asConstraint(\"My package\", \"My constraint\");"))});
    }

    @Test
    void triPenalizeName() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .penalize(\"My constraint\", HardSoftScore.ONE_HARD);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .penalize(HardSoftScore.ONE_HARD)\n                .asConstraint(\"My constraint\");"))});
    }

    @Test
    void triPenalizeId() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .penalize(\"My package\", \"My constraint\", HardSoftScore.ONE_HARD);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .penalize(HardSoftScore.ONE_HARD)\n                .asConstraint(\"My package\", \"My constraint\");"))});
    }

    @Test
    void triPenalizeConfigurableName() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .penalizeConfigurable(\"My constraint\");"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .penalizeConfigurable()\n                .asConstraint(\"My constraint\");"))});
    }

    @Test
    void triPenalizeConfigurableId() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .penalizeConfigurable(\"My package\", \"My constraint\");"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .penalizeConfigurable()\n                .asConstraint(\"My package\", \"My constraint\");"))});
    }

    @Test
    void triPenalizeNameMatchWeigherInt() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .penalize(\"My constraint\", HardSoftScore.ONE_HARD, (a, b, c) -> 7);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .penalize(HardSoftScore.ONE_HARD, (a, b, c) -> 7)\n                .asConstraint(\"My constraint\");"))});
    }

    @Test
    void triPenalizeIdMatchWeigherInt() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .penalize(\"My package\", \"My constraint\", HardSoftScore.ONE_HARD, (a, b, c) -> 7);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .penalize(HardSoftScore.ONE_HARD, (a, b, c) -> 7)\n                .asConstraint(\"My package\", \"My constraint\");"))});
    }

    @Test
    void triPenalizeConfigurableNameMatchWeigherInt() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .penalizeConfigurable(\"My constraint\", (a, b, c) -> 7);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .penalizeConfigurable((a, b, c) -> 7)\n                .asConstraint(\"My constraint\");"))});
    }

    @Test
    void triPenalizeConfigurableIdMatchWeigherInt() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .penalizeConfigurable(\"My package\", \"My constraint\", (a, b, c) -> 7);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .penalizeConfigurable((a, b, c) -> 7)\n                .asConstraint(\"My package\", \"My constraint\");"))});
    }

    @Test
    void triPenalizeNameMatchWeigherLong() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .penalizeLong(\"My constraint\", HardSoftLongScore.ONE_HARD, (a, b, c) -> 7L);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .penalizeLong(HardSoftLongScore.ONE_HARD, (a, b, c) -> 7L)\n                .asConstraint(\"My constraint\");"))});
    }

    @Test
    void triPenalizeIdMatchWeigherLong() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .penalizeLong(\"My package\", \"My constraint\", HardSoftLongScore.ONE_HARD, (a, b, c) -> 7L);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .penalizeLong(HardSoftLongScore.ONE_HARD, (a, b, c) -> 7L)\n                .asConstraint(\"My package\", \"My constraint\");"))});
    }

    @Test
    void triPenalizeConfigurableNameMatchWeigherLong() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .penalizeConfigurableLong(\"My constraint\", (a, b, c) -> 7L);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .penalizeConfigurableLong((a, b, c) -> 7L)\n                .asConstraint(\"My constraint\");"))});
    }

    @Test
    void triPenalizeConfigurableIdMatchWeigherLong() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .penalizeConfigurableLong(\"My package\", \"My constraint\", (a, b, c) -> 7L);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .penalizeConfigurableLong((a, b, c) -> 7L)\n                .asConstraint(\"My package\", \"My constraint\");"))});
    }

    @Test
    void triPenalizeNameMatchWeigherBigDecimal() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .penalizeBigDecimal(\"My constraint\", HardSoftBigDecimalScore.ONE_HARD, (a, b, c) -> BigDecimal.TEN);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .penalizeBigDecimal(HardSoftBigDecimalScore.ONE_HARD, (a, b, c) -> BigDecimal.TEN)\n                .asConstraint(\"My constraint\");"))});
    }

    @Test
    void triPenalizeIdMatchWeigherBigDecimal() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .penalizeBigDecimal(\"My package\", \"My constraint\", HardSoftBigDecimalScore.ONE_HARD, (a, b, c) -> BigDecimal.TEN);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .penalizeBigDecimal(HardSoftBigDecimalScore.ONE_HARD, (a, b, c) -> BigDecimal.TEN)\n                .asConstraint(\"My package\", \"My constraint\");"))});
    }

    @Test
    void triPenalizeConfigurableNameMatchWeigherBigDecimal() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .penalizeConfigurableBigDecimal(\"My constraint\", (a, b, c) -> BigDecimal.TEN);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .penalizeConfigurableBigDecimal((a, b, c) -> BigDecimal.TEN)\n                .asConstraint(\"My constraint\");"))});
    }

    @Test
    void triPenalizeConfigurableIdMatchWeigherBigDecimal() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .penalizeConfigurableBigDecimal(\"My package\", \"My constraint\", (a, b, c) -> BigDecimal.TEN);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .penalizeConfigurableBigDecimal((a, b, c) -> BigDecimal.TEN)\n                .asConstraint(\"My package\", \"My constraint\");"))});
    }

    @Test
    void triRewardName() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .reward(\"My constraint\", HardSoftScore.ONE_HARD);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .reward(HardSoftScore.ONE_HARD)\n                .asConstraint(\"My constraint\");"))});
    }

    @Test
    void triRewardId() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .reward(\"My package\", \"My constraint\", HardSoftScore.ONE_HARD);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .reward(HardSoftScore.ONE_HARD)\n                .asConstraint(\"My package\", \"My constraint\");"))});
    }

    @Test
    void triRewardConfigurableName() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .rewardConfigurable(\"My constraint\");"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .rewardConfigurable()\n                .asConstraint(\"My constraint\");"))});
    }

    @Test
    void triRewardConfigurableId() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .rewardConfigurable(\"My package\", \"My constraint\");"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .rewardConfigurable()\n                .asConstraint(\"My package\", \"My constraint\");"))});
    }

    @Test
    void triRewardNameMatchWeigherInt() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .reward(\"My constraint\", HardSoftScore.ONE_HARD, (a, b, c) -> 7);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .reward(HardSoftScore.ONE_HARD, (a, b, c) -> 7)\n                .asConstraint(\"My constraint\");"))});
    }

    @Test
    void triRewardIdMatchWeigherInt() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .reward(\"My package\", \"My constraint\", HardSoftScore.ONE_HARD, (a, b, c) -> 7);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .reward(HardSoftScore.ONE_HARD, (a, b, c) -> 7)\n                .asConstraint(\"My package\", \"My constraint\");"))});
    }

    @Test
    void triRewardConfigurableNameMatchWeigherInt() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .rewardConfigurable(\"My constraint\", (a, b, c) -> 7);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .rewardConfigurable((a, b, c) -> 7)\n                .asConstraint(\"My constraint\");"))});
    }

    @Test
    void triRewardConfigurableIdMatchWeigherInt() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .rewardConfigurable(\"My package\", \"My constraint\", (a, b, c) -> 7);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .rewardConfigurable((a, b, c) -> 7)\n                .asConstraint(\"My package\", \"My constraint\");"))});
    }

    @Test
    void triRewardNameMatchWeigherLong() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .rewardLong(\"My constraint\", HardSoftLongScore.ONE_HARD, (a, b, c) -> 7L);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .rewardLong(HardSoftLongScore.ONE_HARD, (a, b, c) -> 7L)\n                .asConstraint(\"My constraint\");"))});
    }

    @Test
    void triRewardIdMatchWeigherLong() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .rewardLong(\"My package\", \"My constraint\", HardSoftLongScore.ONE_HARD, (a, b, c) -> 7L);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .rewardLong(HardSoftLongScore.ONE_HARD, (a, b, c) -> 7L)\n                .asConstraint(\"My package\", \"My constraint\");"))});
    }

    @Test
    void triRewardConfigurableNameMatchWeigherLong() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .rewardConfigurableLong(\"My constraint\", (a, b, c) -> 7L);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .rewardConfigurableLong((a, b, c) -> 7L)\n                .asConstraint(\"My constraint\");"))});
    }

    @Test
    void triRewardConfigurableIdMatchWeigherLong() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .rewardConfigurableLong(\"My package\", \"My constraint\", (a, b, c) -> 7L);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .rewardConfigurableLong((a, b, c) -> 7L)\n                .asConstraint(\"My package\", \"My constraint\");"))});
    }

    @Test
    void triRewardNameMatchWeigherBigDecimal() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .rewardBigDecimal(\"My constraint\", HardSoftBigDecimalScore.ONE_HARD, (a, b, c) -> BigDecimal.TEN);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .rewardBigDecimal(HardSoftBigDecimalScore.ONE_HARD, (a, b, c) -> BigDecimal.TEN)\n                .asConstraint(\"My constraint\");"))});
    }

    @Test
    void triRewardIdMatchWeigherBigDecimal() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .rewardBigDecimal(\"My package\", \"My constraint\", HardSoftBigDecimalScore.ONE_HARD, (a, b, c) -> BigDecimal.TEN);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .rewardBigDecimal(HardSoftBigDecimalScore.ONE_HARD, (a, b, c) -> BigDecimal.TEN)\n                .asConstraint(\"My package\", \"My constraint\");"))});
    }

    @Test
    void triRewardConfigurableNameMatchWeigherBigDecimal() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .rewardConfigurableBigDecimal(\"My constraint\", (a, b, c) -> BigDecimal.TEN);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .rewardConfigurableBigDecimal((a, b, c) -> BigDecimal.TEN)\n                .asConstraint(\"My constraint\");"))});
    }

    @Test
    void triRewardConfigurableIdMatchWeigherBigDecimal() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .rewardConfigurableBigDecimal(\"My package\", \"My constraint\", (a, b, c) -> BigDecimal.TEN);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .rewardConfigurableBigDecimal((a, b, c) -> BigDecimal.TEN)\n                .asConstraint(\"My package\", \"My constraint\");"))});
    }

    @Test
    void triImpactName() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .impact(\"My constraint\", HardSoftScore.ONE_HARD);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .impact(HardSoftScore.ONE_HARD)\n                .asConstraint(\"My constraint\");"))});
    }

    @Test
    void triImpactId() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .impact(\"My package\", \"My constraint\", HardSoftScore.ONE_HARD);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .impact(HardSoftScore.ONE_HARD)\n                .asConstraint(\"My package\", \"My constraint\");"))});
    }

    @Test
    void triImpactNameMatchWeigherInt() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .impact(\"My constraint\", HardSoftScore.ONE_HARD, (a, b, c) -> 7);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .impact(HardSoftScore.ONE_HARD, (a, b, c) -> 7)\n                .asConstraint(\"My constraint\");"))});
    }

    @Test
    void triImpactIdMatchWeigherInt() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .impact(\"My package\", \"My constraint\", HardSoftScore.ONE_HARD, (a, b, c) -> 7);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .impact(HardSoftScore.ONE_HARD, (a, b, c) -> 7)\n                .asConstraint(\"My package\", \"My constraint\");"))});
    }

    @Test
    void triImpactNameMatchWeigherLong() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .impactLong(\"My constraint\", HardSoftLongScore.ONE_HARD, (a, b, c) -> 7L);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .impactLong(HardSoftLongScore.ONE_HARD, (a, b, c) -> 7L)\n                .asConstraint(\"My constraint\");"))});
    }

    @Test
    void triImpactIdMatchWeigherLong() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .impactLong(\"My package\", \"My constraint\", HardSoftLongScore.ONE_HARD, (a, b, c) -> 7L);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .impactLong(HardSoftLongScore.ONE_HARD, (a, b, c) -> 7L)\n                .asConstraint(\"My package\", \"My constraint\");"))});
    }

    @Test
    void triImpactNameMatchWeigherBigDecimal() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .impactBigDecimal(\"My constraint\", HardSoftBigDecimalScore.ONE_HARD, (a, b, c) -> BigDecimal.TEN);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .impactBigDecimal(HardSoftBigDecimalScore.ONE_HARD, (a, b, c) -> BigDecimal.TEN)\n                .asConstraint(\"My constraint\");"))});
    }

    @Test
    void triImpactIdMatchWeigherBigDecimal() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .impactBigDecimal(\"My package\", \"My constraint\", HardSoftBigDecimalScore.ONE_HARD, (a, b, c) -> BigDecimal.TEN);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .impactBigDecimal(HardSoftBigDecimalScore.ONE_HARD, (a, b, c) -> BigDecimal.TEN)\n                .asConstraint(\"My package\", \"My constraint\");"))});
    }

    @Test
    void quadPenalizeName() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .join(String.class)\n                .penalize(\"My constraint\", HardSoftScore.ONE_HARD);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .join(String.class)\n                .penalize(HardSoftScore.ONE_HARD)\n                .asConstraint(\"My constraint\");"))});
    }

    @Test
    void quadPenalizeId() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .join(String.class)\n                .penalize(\"My package\", \"My constraint\", HardSoftScore.ONE_HARD);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .join(String.class)\n                .penalize(HardSoftScore.ONE_HARD)\n                .asConstraint(\"My package\", \"My constraint\");"))});
    }

    @Test
    void quadPenalizeConfigurableName() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .join(String.class)\n                .penalizeConfigurable(\"My constraint\");"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .join(String.class)\n                .penalizeConfigurable()\n                .asConstraint(\"My constraint\");"))});
    }

    @Test
    void quadPenalizeConfigurableId() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .join(String.class)\n                .penalizeConfigurable(\"My package\", \"My constraint\");"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .join(String.class)\n                .penalizeConfigurable()\n                .asConstraint(\"My package\", \"My constraint\");"))});
    }

    @Test
    void quadPenalizeNameMatchWeigherInt() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .join(String.class)\n                .penalize(\"My constraint\", HardSoftScore.ONE_HARD, (a, b, c, d) -> 7);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .join(String.class)\n                .penalize(HardSoftScore.ONE_HARD, (a, b, c, d) -> 7)\n                .asConstraint(\"My constraint\");"))});
    }

    @Test
    void quadPenalizeIdMatchWeigherInt() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .join(String.class)\n                .penalize(\"My package\", \"My constraint\", HardSoftScore.ONE_HARD, (a, b, c, d) -> 7);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .join(String.class)\n                .penalize(HardSoftScore.ONE_HARD, (a, b, c, d) -> 7)\n                .asConstraint(\"My package\", \"My constraint\");"))});
    }

    @Test
    void quadPenalizeConfigurableNameMatchWeigherInt() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .join(String.class)\n                .penalizeConfigurable(\"My constraint\", (a, b, c, d) -> 7);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .join(String.class)\n                .penalizeConfigurable((a, b, c, d) -> 7)\n                .asConstraint(\"My constraint\");"))});
    }

    @Test
    void quadPenalizeConfigurableIdMatchWeigherInt() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .join(String.class)\n                .penalizeConfigurable(\"My package\", \"My constraint\", (a, b, c, d) -> 7);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .join(String.class)\n                .penalizeConfigurable((a, b, c, d) -> 7)\n                .asConstraint(\"My package\", \"My constraint\");"))});
    }

    @Test
    void quadPenalizeNameMatchWeigherLong() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .join(String.class)\n                .penalizeLong(\"My constraint\", HardSoftLongScore.ONE_HARD, (a, b, c, d) -> 7L);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .join(String.class)\n                .penalizeLong(HardSoftLongScore.ONE_HARD, (a, b, c, d) -> 7L)\n                .asConstraint(\"My constraint\");"))});
    }

    @Test
    void quadPenalizeIdMatchWeigherLong() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .join(String.class)\n                .penalizeLong(\"My package\", \"My constraint\", HardSoftLongScore.ONE_HARD, (a, b, c, d) -> 7L);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .join(String.class)\n                .penalizeLong(HardSoftLongScore.ONE_HARD, (a, b, c, d) -> 7L)\n                .asConstraint(\"My package\", \"My constraint\");"))});
    }

    @Test
    void quadPenalizeConfigurableNameMatchWeigherLong() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .join(String.class)\n                .penalizeConfigurableLong(\"My constraint\", (a, b, c, d) -> 7L);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .join(String.class)\n                .penalizeConfigurableLong((a, b, c, d) -> 7L)\n                .asConstraint(\"My constraint\");"))});
    }

    @Test
    void quadPenalizeConfigurableIdMatchWeigherLong() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .join(String.class)\n                .penalizeConfigurableLong(\"My package\", \"My constraint\", (a, b, c, d) -> 7L);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .join(String.class)\n                .penalizeConfigurableLong((a, b, c, d) -> 7L)\n                .asConstraint(\"My package\", \"My constraint\");"))});
    }

    @Test
    void quadPenalizeNameMatchWeigherBigDecimal() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .join(String.class)\n                .penalizeBigDecimal(\"My constraint\", HardSoftBigDecimalScore.ONE_HARD, (a, b, c, d) -> BigDecimal.TEN);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .join(String.class)\n                .penalizeBigDecimal(HardSoftBigDecimalScore.ONE_HARD, (a, b, c, d) -> BigDecimal.TEN)\n                .asConstraint(\"My constraint\");"))});
    }

    @Test
    void quadPenalizeIdMatchWeigherBigDecimal() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .join(String.class)\n                .penalizeBigDecimal(\"My package\", \"My constraint\", HardSoftBigDecimalScore.ONE_HARD, (a, b, c, d) -> BigDecimal.TEN);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .join(String.class)\n                .penalizeBigDecimal(HardSoftBigDecimalScore.ONE_HARD, (a, b, c, d) -> BigDecimal.TEN)\n                .asConstraint(\"My package\", \"My constraint\");"))});
    }

    @Test
    void quadPenalizeConfigurableNameMatchWeigherBigDecimal() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .join(String.class)\n                .penalizeConfigurableBigDecimal(\"My constraint\", (a, b, c, d) -> BigDecimal.TEN);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .join(String.class)\n                .penalizeConfigurableBigDecimal((a, b, c, d) -> BigDecimal.TEN)\n                .asConstraint(\"My constraint\");"))});
    }

    @Test
    void quadPenalizeConfigurableIdMatchWeigherBigDecimal() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .join(String.class)\n                .penalizeConfigurableBigDecimal(\"My package\", \"My constraint\", (a, b, c, d) -> BigDecimal.TEN);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .join(String.class)\n                .penalizeConfigurableBigDecimal((a, b, c, d) -> BigDecimal.TEN)\n                .asConstraint(\"My package\", \"My constraint\");"))});
    }

    @Test
    void quadRewardName() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .join(String.class)\n                .reward(\"My constraint\", HardSoftScore.ONE_HARD);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .join(String.class)\n                .reward(HardSoftScore.ONE_HARD)\n                .asConstraint(\"My constraint\");"))});
    }

    @Test
    void quadRewardId() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .join(String.class)\n                .reward(\"My package\", \"My constraint\", HardSoftScore.ONE_HARD);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .join(String.class)\n                .reward(HardSoftScore.ONE_HARD)\n                .asConstraint(\"My package\", \"My constraint\");"))});
    }

    @Test
    void quadRewardConfigurableName() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .join(String.class)\n                .rewardConfigurable(\"My constraint\");"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .join(String.class)\n                .rewardConfigurable()\n                .asConstraint(\"My constraint\");"))});
    }

    @Test
    void quadRewardConfigurableId() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .join(String.class)\n                .rewardConfigurable(\"My package\", \"My constraint\");"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .join(String.class)\n                .rewardConfigurable()\n                .asConstraint(\"My package\", \"My constraint\");"))});
    }

    @Test
    void quadRewardNameMatchWeigherInt() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .join(String.class)\n                .reward(\"My constraint\", HardSoftScore.ONE_HARD, (a, b, c, d) -> 7);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .join(String.class)\n                .reward(HardSoftScore.ONE_HARD, (a, b, c, d) -> 7)\n                .asConstraint(\"My constraint\");"))});
    }

    @Test
    void quadRewardIdMatchWeigherInt() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .join(String.class)\n                .reward(\"My package\", \"My constraint\", HardSoftScore.ONE_HARD, (a, b, c, d) -> 7);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .join(String.class)\n                .reward(HardSoftScore.ONE_HARD, (a, b, c, d) -> 7)\n                .asConstraint(\"My package\", \"My constraint\");"))});
    }

    @Test
    void quadRewardConfigurableNameMatchWeigherInt() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .join(String.class)\n                .rewardConfigurable(\"My constraint\", (a, b, c, d) -> 7);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .join(String.class)\n                .rewardConfigurable((a, b, c, d) -> 7)\n                .asConstraint(\"My constraint\");"))});
    }

    @Test
    void quadRewardConfigurableIdMatchWeigherInt() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .join(String.class)\n                .rewardConfigurable(\"My package\", \"My constraint\", (a, b, c, d) -> 7);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .join(String.class)\n                .rewardConfigurable((a, b, c, d) -> 7)\n                .asConstraint(\"My package\", \"My constraint\");"))});
    }

    @Test
    void quadRewardNameMatchWeigherLong() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .join(String.class)\n                .rewardLong(\"My constraint\", HardSoftLongScore.ONE_HARD, (a, b, c, d) -> 7L);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .join(String.class)\n                .rewardLong(HardSoftLongScore.ONE_HARD, (a, b, c, d) -> 7L)\n                .asConstraint(\"My constraint\");"))});
    }

    @Test
    void quadRewardIdMatchWeigherLong() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .join(String.class)\n                .rewardLong(\"My package\", \"My constraint\", HardSoftLongScore.ONE_HARD, (a, b, c, d) -> 7L);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .join(String.class)\n                .rewardLong(HardSoftLongScore.ONE_HARD, (a, b, c, d) -> 7L)\n                .asConstraint(\"My package\", \"My constraint\");"))});
    }

    @Test
    void quadRewardConfigurableNameMatchWeigherLong() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .join(String.class)\n                .rewardConfigurableLong(\"My constraint\", (a, b, c, d) -> 7L);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .join(String.class)\n                .rewardConfigurableLong((a, b, c, d) -> 7L)\n                .asConstraint(\"My constraint\");"))});
    }

    @Test
    void quadRewardConfigurableIdMatchWeigherLong() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .join(String.class)\n                .rewardConfigurableLong(\"My package\", \"My constraint\", (a, b, c, d) -> 7L);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .join(String.class)\n                .rewardConfigurableLong((a, b, c, d) -> 7L)\n                .asConstraint(\"My package\", \"My constraint\");"))});
    }

    @Test
    void quadRewardNameMatchWeigherBigDecimal() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .join(String.class)\n                .rewardBigDecimal(\"My constraint\", HardSoftBigDecimalScore.ONE_HARD, (a, b, c, d) -> BigDecimal.TEN);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .join(String.class)\n                .rewardBigDecimal(HardSoftBigDecimalScore.ONE_HARD, (a, b, c, d) -> BigDecimal.TEN)\n                .asConstraint(\"My constraint\");"))});
    }

    @Test
    void quadRewardIdMatchWeigherBigDecimal() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .join(String.class)\n                .rewardBigDecimal(\"My package\", \"My constraint\", HardSoftBigDecimalScore.ONE_HARD, (a, b, c, d) -> BigDecimal.TEN);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .join(String.class)\n                .rewardBigDecimal(HardSoftBigDecimalScore.ONE_HARD, (a, b, c, d) -> BigDecimal.TEN)\n                .asConstraint(\"My package\", \"My constraint\");"))});
    }

    @Test
    void quadRewardConfigurableNameMatchWeigherBigDecimal() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .join(String.class)\n                .rewardConfigurableBigDecimal(\"My constraint\", (a, b, c, d) -> BigDecimal.TEN);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .join(String.class)\n                .rewardConfigurableBigDecimal((a, b, c, d) -> BigDecimal.TEN)\n                .asConstraint(\"My constraint\");"))});
    }

    @Test
    void quadRewardConfigurableIdMatchWeigherBigDecimal() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .join(String.class)\n                .rewardConfigurableBigDecimal(\"My package\", \"My constraint\", (a, b, c, d) -> BigDecimal.TEN);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .join(String.class)\n                .rewardConfigurableBigDecimal((a, b, c, d) -> BigDecimal.TEN)\n                .asConstraint(\"My package\", \"My constraint\");"))});
    }

    @Test
    void quadImpactName() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .join(String.class)\n                .impact(\"My constraint\", HardSoftScore.ONE_HARD);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .join(String.class)\n                .impact(HardSoftScore.ONE_HARD)\n                .asConstraint(\"My constraint\");"))});
    }

    @Test
    void quadImpactId() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .join(String.class)\n                .impact(\"My package\", \"My constraint\", HardSoftScore.ONE_HARD);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .join(String.class)\n                .impact(HardSoftScore.ONE_HARD)\n                .asConstraint(\"My package\", \"My constraint\");"))});
    }

    @Test
    void quadImpactNameMatchWeigherInt() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .join(String.class)\n                .impact(\"My constraint\", HardSoftScore.ONE_HARD, (a, b, c, d) -> 7);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .join(String.class)\n                .impact(HardSoftScore.ONE_HARD, (a, b, c, d) -> 7)\n                .asConstraint(\"My constraint\");"))});
    }

    @Test
    void quadImpactIdMatchWeigherInt() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .join(String.class)\n                .impact(\"My package\", \"My constraint\", HardSoftScore.ONE_HARD, (a, b, c, d) -> 7);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .join(String.class)\n                .impact(HardSoftScore.ONE_HARD, (a, b, c, d) -> 7)\n                .asConstraint(\"My package\", \"My constraint\");"))});
    }

    @Test
    void quadImpactNameMatchWeigherLong() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .join(String.class)\n                .impactLong(\"My constraint\", HardSoftLongScore.ONE_HARD, (a, b, c, d) -> 7L);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .join(String.class)\n                .impactLong(HardSoftLongScore.ONE_HARD, (a, b, c, d) -> 7L)\n                .asConstraint(\"My constraint\");"))});
    }

    @Test
    void quadImpactIdMatchWeigherLong() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .join(String.class)\n                .impactLong(\"My package\", \"My constraint\", HardSoftLongScore.ONE_HARD, (a, b, c, d) -> 7L);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .join(String.class)\n                .impactLong(HardSoftLongScore.ONE_HARD, (a, b, c, d) -> 7L)\n                .asConstraint(\"My package\", \"My constraint\");"))});
    }

    @Test
    void quadImpactNameMatchWeigherBigDecimal() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .join(String.class)\n                .impactBigDecimal(\"My constraint\", HardSoftBigDecimalScore.ONE_HARD, (a, b, c, d) -> BigDecimal.TEN);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .join(String.class)\n                .impactBigDecimal(HardSoftBigDecimalScore.ONE_HARD, (a, b, c, d) -> BigDecimal.TEN)\n                .asConstraint(\"My constraint\");"))});
    }

    @Test
    void quadImpactIdMatchWeigherBigDecimal() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .join(String.class)\n                .impactBigDecimal(\"My package\", \"My constraint\", HardSoftBigDecimalScore.ONE_HARD, (a, b, c, d) -> BigDecimal.TEN);"), (String)AsConstraintRecipeTest.wrap("        return f.forEach(String.class)\n                .join(String.class)\n                .join(String.class)\n                .join(String.class)\n                .impactBigDecimal(HardSoftBigDecimalScore.ONE_HARD, (a, b, c, d) -> BigDecimal.TEN)\n                .asConstraint(\"My package\", \"My constraint\");"))});
    }

    private static String wrap(String content) {
        return "import java.math.BigDecimal;\nimport org.optaplanner.core.api.score.buildin.hardsoft.HardSoftScore;\nimport org.optaplanner.core.api.score.buildin.hardsoftlong.HardSoftLongScore;\nimport org.optaplanner.core.api.score.buildin.hardsoftbigdecimal.HardSoftBigDecimalScore;\nimport org.optaplanner.core.api.score.stream.ConstraintFactory;\nimport org.optaplanner.core.api.score.stream.Constraint;\n\nclass Test {\n    Constraint myConstraint(ConstraintFactory f) {\n" + content + "\n    }}\n";
    }
}

