/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.operator.impl.solver.model;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.EnvVarFluent;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.apps.DeploymentFluent;
import io.fabric8.kubernetes.api.model.apps.DeploymentSpecBuilder;
import io.fabric8.kubernetes.api.model.apps.DeploymentSpecFluent;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.javaoperatorsdk.operator.api.reconciler.Context;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.CRUDKubernetesDependentResource;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.KubernetesDependent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.optaplanner.operator.impl.solver.model.OptaPlannerSolver;
import org.optaplanner.operator.impl.solver.model.OptaPlannerSolverSpec;

@KubernetesDependent
public final class DeploymentDependentResource
extends CRUDKubernetesDependentResource<Deployment, OptaPlannerSolver> {
    private static final String ENV_SOLVER_MESSAGE_IN = "SOLVER_MESSAGE_INPUT";
    private static final String ENV_SOLVER_MESSAGE_OUT = "SOLVER_MESSAGE_OUTPUT";
    private static final String ENV_AMQ_HOST = "SOLVER_MESSAGE_AMQ_HOST";
    private static final String ENV_AMQ_PORT = "SOLVER_MESSAGE_AMQ_PORT";
    private static final String ENV_AMQ_USERNAME = "SOLVER_MESSAGE_AMQ_USERNAME";
    private static final String ENV_AMQ_PASSWORD = "SOLVER_MESSAGE_AMQ_PASSWORD";

    public DeploymentDependentResource(KubernetesClient k8s) {
        super(Deployment.class);
        this.setKubernetesClient(k8s);
    }

    protected Deployment desired(OptaPlannerSolver solver, Context<OptaPlannerSolver> context) {
        PodTemplateSpec podTemplateSpec;
        String deploymentName = solver.getDeploymentName();
        DeploymentSpecBuilder deploymentSpecBuilder = (DeploymentSpecBuilder)((DeploymentSpecFluent.SelectorNested)new DeploymentSpecBuilder().withNewSelector().withMatchLabels(Map.of("app", deploymentName))).endSelector();
        if (!((OptaPlannerSolverSpec)solver.getSpec()).getScaling().isDynamic()) {
            deploymentSpecBuilder.withReplicas(Integer.valueOf(((OptaPlannerSolverSpec)solver.getSpec()).getScaling().getReplicas()));
        }
        if ((podTemplateSpec = ((OptaPlannerSolverSpec)solver.getSpec()).getTemplate()) == null) {
            throw new IllegalStateException("Solver (" + solver.getMetadata().getName() + ") pod template is missing.\nMaybe check the related " + solver.getFullResourceName() + " resource.");
        }
        PodTemplateSpec updatedPodTemplateSpec = this.addPodAppLabel(podTemplateSpec, deploymentName);
        if (updatedPodTemplateSpec.getSpec() == null || updatedPodTemplateSpec.getSpec().getContainers() == null || updatedPodTemplateSpec.getSpec().getContainers().isEmpty()) {
            throw new IllegalStateException("Solver (" + solver.getMetadata().getName() + ") pod template does not contain any container.\nMaybe check the related " + solver.getFullResourceName() + " resource.");
        }
        List containers = updatedPodTemplateSpec.getSpec().getContainers();
        for (Container container : containers) {
            if (container.getEnv() == null) {
                container.setEnv(new ArrayList());
            }
            container.getEnv().addAll(this.buildEnvironmentVariablesMapping(solver));
        }
        deploymentSpecBuilder.withTemplate(updatedPodTemplateSpec);
        return ((DeploymentBuilder)((DeploymentBuilder)((DeploymentFluent.MetadataNested)((DeploymentFluent.MetadataNested)new DeploymentBuilder().withNewMetadata().withName(deploymentName)).withNamespace(solver.getNamespace())).endMetadata()).withSpec(deploymentSpecBuilder.build())).build();
    }

    private PodTemplateSpec addPodAppLabel(PodTemplateSpec podTemplateSpec, String deploymentName) {
        return ((PodTemplateSpecBuilder)((PodTemplateSpecFluent.MetadataNested)new PodTemplateSpecBuilder(podTemplateSpec).editOrNewMetadata().addToLabels("app", deploymentName)).endMetadata()).build();
    }

    private List<EnvVar> buildEnvironmentVariablesMapping(OptaPlannerSolver solver) {
        String configMapName = solver.getConfigMapName();
        EnvVar envVarMessageInput = this.buildEnvVarFromConfigMap(ENV_SOLVER_MESSAGE_IN, configMapName, "solver.message.input");
        EnvVar envVarMessageOutput = this.buildEnvVarFromConfigMap(ENV_SOLVER_MESSAGE_OUT, configMapName, "solver.message.output");
        EnvVar envVarAmqHost = this.buildEnvVarFromConfigMap(ENV_AMQ_HOST, configMapName, "solver.amq.host");
        EnvVar envVarAmqPort = this.buildEnvVarFromConfigMap(ENV_AMQ_PORT, configMapName, "solver.amq.port");
        EnvVar envVarAmqUsername = this.buildEnvVarFromSecretKeySelector(ENV_AMQ_USERNAME, ((OptaPlannerSolverSpec)solver.getSpec()).getAmqBroker().getUsernameSecretRef());
        EnvVar envVarAmqPassword = this.buildEnvVarFromSecretKeySelector(ENV_AMQ_PASSWORD, ((OptaPlannerSolverSpec)solver.getSpec()).getAmqBroker().getPasswordSecretRef());
        return List.of(envVarMessageInput, envVarMessageOutput, envVarAmqHost, envVarAmqPort, envVarAmqUsername, envVarAmqPassword);
    }

    private EnvVar buildEnvVarFromConfigMap(String envVariable, String configMapName, String configMapKey) {
        return ((EnvVarBuilder)((EnvVarFluent.ValueFromNested)((EnvVarBuilder)new EnvVarBuilder().withName(envVariable)).withNewValueFrom().withNewConfigMapKeyRef(configMapKey, configMapName, Boolean.valueOf(false))).endValueFrom()).build();
    }

    private EnvVar buildEnvVarFromSecretKeySelector(String envVariable, SecretKeySelector secretKeySelector) {
        return ((EnvVarBuilder)((EnvVarFluent.ValueFromNested)((EnvVarBuilder)new EnvVarBuilder().withName(envVariable)).withNewValueFrom().withNewSecretKeyRef(secretKeySelector.getKey(), secretKeySelector.getName(), secretKeySelector.getOptional())).endValueFrom()).build();
    }
}

