/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.operator.impl.solver.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.model.Namespaced;
import io.fabric8.kubernetes.client.CustomResource;
import io.fabric8.kubernetes.model.annotation.Group;
import io.fabric8.kubernetes.model.annotation.Kind;
import io.fabric8.kubernetes.model.annotation.Plural;
import io.fabric8.kubernetes.model.annotation.Singular;
import io.fabric8.kubernetes.model.annotation.Version;
import org.optaplanner.operator.impl.solver.model.OptaPlannerSolverSpec;
import org.optaplanner.operator.impl.solver.model.OptaPlannerSolverStatus;
import org.optaplanner.operator.impl.solver.model.messaging.MessageAddress;

@Group(value="org.optaplanner.solver")
@Plural(value="solvers")
@Singular(value="solver")
@Version(value="v1alpha1")
@Kind(value="Solver")
public final class OptaPlannerSolver
extends CustomResource<OptaPlannerSolverSpec, OptaPlannerSolverStatus>
implements Namespaced {
    public static final String GROUP = "org.optaplanner.solver";
    public static final String PLURAL = "solvers";
    public static final String SINGULAR = "solver";
    public static final String API_VERSION = "v1alpha1";
    public static final String KIND = "Solver";

    protected OptaPlannerSolverStatus initStatus() {
        return new OptaPlannerSolverStatus();
    }

    @JsonIgnore
    public String getNamespace() {
        return this.getMetadata().getNamespace();
    }

    @JsonIgnore
    public String getConfigMapName() {
        return this.getSolverName();
    }

    @JsonIgnore
    public String getDeploymentName() {
        return this.getSolverName();
    }

    @JsonIgnore
    public String getInputMessageAddressName() {
        return this.getMessageAddressName(MessageAddress.INPUT);
    }

    @JsonIgnore
    public String getOutputMessageAddressName() {
        return this.getMessageAddressName(MessageAddress.OUTPUT);
    }

    @JsonIgnore
    public String getMessageAddressName(MessageAddress messageAddress) {
        return String.format("%s-%s", this.getSolverName(), messageAddress.getName());
    }

    @JsonIgnore
    public String getTriggerAuthenticationName() {
        return this.getSolverName();
    }

    @JsonIgnore
    public String getScaledObjectName() {
        return this.getSolverName();
    }

    @JsonIgnore
    public String getScaledObjectTriggerName() {
        return this.getSolverName();
    }

    @JsonIgnore
    private String getSolverName() {
        return this.getMetadata().getName();
    }
}

