/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.operator.impl.solver.model.messaging;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.javaoperatorsdk.operator.api.reconciler.Context;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.CRUDKubernetesDependentResource;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.KubernetesDependent;
import org.optaplanner.operator.impl.solver.model.OptaPlannerSolver;
import org.optaplanner.operator.impl.solver.model.messaging.ArtemisQueue;
import org.optaplanner.operator.impl.solver.model.messaging.ArtemisQueueSpec;
import org.optaplanner.operator.impl.solver.model.messaging.MessageAddress;

@KubernetesDependent
public final class ArtemisQueueDependentResource
extends CRUDKubernetesDependentResource<ArtemisQueue, OptaPlannerSolver> {
    private final MessageAddress messageAddress;

    public ArtemisQueueDependentResource(MessageAddress messageAddress, KubernetesClient kubernetesClient) {
        super(ArtemisQueue.class);
        this.messageAddress = messageAddress;
        this.setKubernetesClient(kubernetesClient);
    }

    protected ArtemisQueue desired(OptaPlannerSolver solver, Context<OptaPlannerSolver> context) {
        String queueName = solver.getMessageAddressName(this.messageAddress);
        ObjectMeta objectMeta = ((ObjectMetaBuilder)((ObjectMetaBuilder)new ObjectMetaBuilder().withName(queueName)).withNamespace(solver.getNamespace())).build();
        ArtemisQueueSpec spec = new ArtemisQueueSpec();
        spec.setAddressName(queueName);
        spec.setQueueName(queueName);
        ArtemisQueue artemisQueue = new ArtemisQueue();
        artemisQueue.setMetadata(objectMeta);
        artemisQueue.setSpec(spec);
        return artemisQueue;
    }
}

