/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.persistence.jackson.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.junit.Assert;
import org.junit.Test;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.bendable.BendableScore;
import org.optaplanner.core.api.score.buildin.hardsoft.HardSoftScore;
import org.optaplanner.persistence.jackson.api.AbstractJacksonJsonSerializerAndDeserializerTest;
import org.optaplanner.persistence.jackson.api.OptaPlannerJacksonModule;

public class OptaPlannerJacksonModuleTest
extends AbstractJacksonJsonSerializerAndDeserializerTest {
    @Test
    public void polymorphicScore() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(OptaPlannerJacksonModule.createModule());
        TestOptaPlannerJacksonModuleWrapper input = new TestOptaPlannerJacksonModuleWrapper();
        input.setHardSoftScore(HardSoftScore.valueOf((int)-1, (int)-20));
        input.setPolymorphicScore((Score)HardSoftScore.valueOf((int)-20, (int)-300));
        TestOptaPlannerJacksonModuleWrapper output = OptaPlannerJacksonModuleTest.serializeAndDeserialize(objectMapper, input);
        Assert.assertEquals((Object)HardSoftScore.valueOf((int)-1, (int)-20), (Object)output.getHardSoftScore());
        Assert.assertEquals((Object)HardSoftScore.valueOf((int)-20, (int)-300), (Object)output.getPolymorphicScore());
        input.setPolymorphicScore((Score)BendableScore.valueOf((int[])new int[]{-1, -20}, (int[])new int[]{-300, -4000, -50000}));
        output = OptaPlannerJacksonModuleTest.serializeAndDeserialize(objectMapper, input);
        Assert.assertEquals((Object)HardSoftScore.valueOf((int)-1, (int)-20), (Object)output.getHardSoftScore());
        Assert.assertEquals((Object)BendableScore.valueOf((int[])new int[]{-1, -20}, (int[])new int[]{-300, -4000, -50000}), (Object)output.getPolymorphicScore());
    }

    public static class TestOptaPlannerJacksonModuleWrapper {
        private HardSoftScore hardSoftScore;
        private Score polymorphicScore;

        private TestOptaPlannerJacksonModuleWrapper() {
        }

        public HardSoftScore getHardSoftScore() {
            return this.hardSoftScore;
        }

        public void setHardSoftScore(HardSoftScore hardSoftScore) {
            this.hardSoftScore = hardSoftScore;
        }

        public Score getPolymorphicScore() {
            return this.polymorphicScore;
        }

        public void setPolymorphicScore(Score polymorphicScore) {
            this.polymorphicScore = polymorphicScore;
        }
    }
}

