/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.persistence.jpa;

import java.util.Map;
import javax.naming.InitialContext;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.kie.test.util.db.PersistenceUtil;
import org.optaplanner.core.api.score.Score;

public abstract class AbstractScoreJpaTest {
    protected Map<String, Object> context;
    protected EntityManagerFactory entityManagerFactory;
    protected TransactionManager transactionManager;

    @BeforeEach
    public void setUp() throws Exception {
        this.context = PersistenceUtil.setupWithPoolingDataSource((String)"org.optaplanner.persistence.jpa.test");
        this.entityManagerFactory = (EntityManagerFactory)this.context.get("org.kie.api.persistence.jpa.EntityManagerFactory");
        this.transactionManager = (TransactionManager)InitialContext.doLookup("java:comp/TransactionManager");
    }

    @AfterEach
    public void tearDown() {
        PersistenceUtil.cleanUp(this.context);
    }

    protected <S extends Score, E extends AbstractTestJpaEntity<S>> Long persistAndAssert(E jpaEntity) {
        try {
            this.transactionManager.begin();
            EntityManager em = this.entityManagerFactory.createEntityManager();
            em.persist(jpaEntity);
            this.transactionManager.commit();
        }
        catch (HeuristicMixedException | HeuristicRollbackException | NotSupportedException | RollbackException | SystemException e) {
            throw new RuntimeException("Transaction failed.", e);
        }
        Long id = jpaEntity.getId();
        Assertions.assertThat((Long)id).isNotNull();
        return id;
    }

    @SafeVarargs
    protected final <S extends Score, E extends AbstractTestJpaEntity<S>> void persistAndMerge(E jpaEntity, S ... newScores) {
        Long id = this.persistAndAssert(jpaEntity);
        Class<?> jpaEntityClass = jpaEntity.getClass();
        S oldScore = jpaEntity.getScore();
        for (S newScore : newScores) {
            this.findAssertAndChangeScore((Class<E>)jpaEntityClass, id, oldScore, newScore);
            this.findAndAssert((Class<E>)jpaEntityClass, id, newScore);
            oldScore = newScore;
        }
    }

    protected <S extends Score, E extends AbstractTestJpaEntity<S>> void findAssertAndChangeScore(Class<E> jpaEntityClass, Long id, S oldScore, S newScore) {
        try {
            this.transactionManager.begin();
            EntityManager em = this.entityManagerFactory.createEntityManager();
            AbstractTestJpaEntity jpaEntity = (AbstractTestJpaEntity)em.find(jpaEntityClass, (Object)id);
            em.persist((Object)jpaEntity);
            Assertions.assertThat(jpaEntity.getScore()).isEqualTo(oldScore);
            jpaEntity.setScore(newScore);
            jpaEntity = (AbstractTestJpaEntity)em.merge((Object)jpaEntity);
            this.transactionManager.commit();
        }
        catch (HeuristicMixedException | HeuristicRollbackException | NotSupportedException | RollbackException | SystemException e) {
            throw new RuntimeException("Transaction failed.", e);
        }
    }

    protected <S extends Score, E extends AbstractTestJpaEntity<S>> void findAndAssert(Class<E> jpaEntityClass, Long id, S score) {
        try {
            this.transactionManager.begin();
            EntityManager em = this.entityManagerFactory.createEntityManager();
            AbstractTestJpaEntity jpaEntity = (AbstractTestJpaEntity)em.find(jpaEntityClass, (Object)id);
            Assertions.assertThat(jpaEntity.getScore()).isEqualTo(score);
            this.transactionManager.commit();
        }
        catch (HeuristicMixedException | HeuristicRollbackException | NotSupportedException | RollbackException | SystemException e) {
            throw new RuntimeException("Transaction failed.", e);
        }
    }

    @MappedSuperclass
    protected static abstract class AbstractTestJpaEntity<S extends Score> {
        @Id
        @GeneratedValue(strategy=GenerationType.AUTO)
        protected Long id;

        protected AbstractTestJpaEntity() {
        }

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public abstract S getScore();

        public abstract void setScore(S var1);
    }
}

