/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.quarkus.jackson.it;

import java.util.concurrent.ExecutionException;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.optaplanner.core.api.solver.SolverJob;
import org.optaplanner.core.api.solver.SolverManager;
import org.optaplanner.quarkus.jackson.it.domain.ITestdataPlanningSolution;

@Path(value="/optaplanner/test")
public class OptaPlannerTestResource {
    @Inject
    SolverManager<ITestdataPlanningSolution, Long> solverManager;

    @POST
    @Path(value="/solver-factory")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public ITestdataPlanningSolution solveWithSolverFactory(ITestdataPlanningSolution problem) {
        SolverJob solverJob = this.solverManager.solve((Object)1L, (Object)problem);
        try {
            return (ITestdataPlanningSolution)solverJob.getFinalBestSolution();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IllegalStateException("Solving failed.", e);
        }
    }
}

