/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.guidedrule.client.widget;

import com.google.gwt.dom.client.Style;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.drools.workbench.models.datamodel.rule.RuleModel;
import org.drools.workbench.screens.guided.rule.client.editor.RuleModeller;
import org.drools.workbench.screens.guided.rule.client.widget.RuleModellerWidget;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.optaplanner.workbench.models.datamodel.rule.ActionConstraintMatch;
import org.optaplanner.workbench.screens.guidedrule.client.widget.ScoreHolderGlobalAware;
import org.uberfire.client.views.pfly.widgets.HelpIcon;

public abstract class AbstractConstraintMatchRuleModellerWidget
extends RuleModellerWidget
implements ScoreHolderGlobalAware {
    protected TranslationService translationService;
    protected HelpIcon helpIcon = new HelpIcon();
    protected Set<String> messages = new HashSet<String>();

    public AbstractConstraintMatchRuleModellerWidget(RuleModeller modeller, EventBus eventBus, TranslationService translationService) {
        super(modeller, eventBus);
        this.translationService = translationService;
    }

    protected HorizontalPanel createLabelPanel(String labelText) {
        HorizontalPanel labelPanel = new HorizontalPanel();
        labelPanel.add((Widget)new Label(labelText));
        this.helpIcon.setVisible(false);
        this.helpIcon.getElement().getStyle().setPaddingLeft(5.0, Style.Unit.PX);
        labelPanel.add((Widget)this.helpIcon);
        this.checkMultipleActionConstraintMatchesExist();
        return labelPanel;
    }

    @Override
    public void scoreHolderGlobalIssueDetected(String message) {
        this.messages.add(message);
        this.displayMessages();
    }

    protected void checkMultipleActionConstraintMatchesExist() {
        RuleModel model = this.getModeller().getModel();
        long actionConstraintMatchCount = Arrays.stream(model.rhs).filter(a -> a instanceof ActionConstraintMatch).count();
        if (actionConstraintMatchCount > 1L) {
            this.messages.add(this.translationService.getTranslation("RuleModellerActionPlugin.AmbigiousConstraintMatchesDetected"));
            this.displayMessages();
        }
    }

    private void displayMessages() {
        String joinedMessages = this.messages.stream().collect(Collectors.joining("<br/>"));
        this.helpIcon.setHelpContent(joinedMessages);
        this.helpIcon.setVisible(true);
    }

    public boolean isReadOnly() {
        return false;
    }

    public boolean isFactTypeKnown() {
        return true;
    }
}

