/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.service.employee;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import org.optaweb.employeerostering.domain.employee.Employee;
import org.optaweb.employeerostering.domain.employee.view.EmployeeAvailabilityView;
import org.optaweb.employeerostering.domain.employee.view.EmployeeView;
import org.optaweb.employeerostering.service.employee.EmployeeService;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest/tenant/{tenantId}/employee"})
@Validated
@Api(tags={"Employee"})
public class EmployeeController {
    private final EmployeeService employeeService;

    public EmployeeController(EmployeeService employeeService) {
        this.employeeService = employeeService;
        Assert.notNull((Object)employeeService, (String)"employeeService must not be null.");
    }

    @ApiOperation(value="Get a list of all employees")
    @GetMapping(value={"/"})
    public ResponseEntity<List<Employee>> getEmployeeList(@PathVariable @Min(value=0L) @Min(value=0L) Integer tenantId) {
        return new ResponseEntity((Object)this.employeeService.getEmployeeList(tenantId), HttpStatus.OK);
    }

    @ApiOperation(value="Get an employee by id")
    @GetMapping(value={"/{id}"})
    public ResponseEntity<Employee> getEmployee(@PathVariable @Min(value=0L) @Min(value=0L) Integer tenantId, @PathVariable @Min(value=0L) @Min(value=0L) Long id) {
        return new ResponseEntity((Object)this.employeeService.getEmployee(tenantId, id), HttpStatus.OK);
    }

    @ApiOperation(value="Delete an employee")
    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Boolean> deleteEmployee(@PathVariable @Min(value=0L) @Min(value=0L) Integer tenantId, @PathVariable @Min(value=0L) @Min(value=0L) Long id) {
        return new ResponseEntity((Object)this.employeeService.deleteEmployee(tenantId, id), HttpStatus.OK);
    }

    @ApiOperation(value="Add a new employee")
    @PostMapping(value={"/add"})
    public ResponseEntity<Employee> createEmployee(@PathVariable @Min(value=0L) @Min(value=0L) Integer tenantId, @RequestBody @Valid EmployeeView employeeView) {
        return new ResponseEntity((Object)this.employeeService.createEmployee(tenantId, employeeView), HttpStatus.OK);
    }

    @ApiOperation(value="Update an employee")
    @PostMapping(value={"/update"})
    public ResponseEntity<Employee> updateEmployee(@PathVariable @Min(value=0L) @Min(value=0L) Integer tenantId, @RequestBody @Valid EmployeeView employeeView) {
        return new ResponseEntity((Object)this.employeeService.updateEmployee(tenantId, employeeView), HttpStatus.OK);
    }

    @ApiOperation(value="Get an employee availability by id")
    @GetMapping(value={"/availability/{id}"})
    public ResponseEntity<EmployeeAvailabilityView> getEmployeeAvailability(@PathVariable @Min(value=0L) @Min(value=0L) Integer tenantId, @PathVariable @Min(value=0L) @Min(value=0L) Long id) {
        return new ResponseEntity((Object)this.employeeService.getEmployeeAvailability(tenantId, id), HttpStatus.OK);
    }

    @ApiOperation(value="Add a new employee availability")
    @PostMapping(value={"/availability/add"})
    public ResponseEntity<EmployeeAvailabilityView> createEmployeeAvailability(@PathVariable @Min(value=0L) @Min(value=0L) Integer tenantId, @RequestBody @Valid EmployeeAvailabilityView employeeAvailabilityView) {
        return new ResponseEntity((Object)this.employeeService.createEmployeeAvailability(tenantId, employeeAvailabilityView), HttpStatus.OK);
    }

    @ApiOperation(value="Update an employee availability")
    @PutMapping(value={"/availability/update"})
    public ResponseEntity<EmployeeAvailabilityView> updateEmployeeAvailability(@PathVariable @Min(value=0L) @Min(value=0L) Integer tenantId, @RequestBody @Valid EmployeeAvailabilityView employeeAvailabilityView) {
        return new ResponseEntity((Object)this.employeeService.updateEmployeeAvailability(tenantId, employeeAvailabilityView), HttpStatus.OK);
    }

    @ApiOperation(value="Delete an employee availability")
    @DeleteMapping(value={"/availability/{id}"})
    public ResponseEntity<Boolean> deleteEmployeeAvailability(@PathVariable @Min(value=0L) @Min(value=0L) Integer tenantId, @PathVariable @Min(value=0L) @Min(value=0L) Long id) {
        return new ResponseEntity((Object)this.employeeService.deleteEmployeeAvailability(tenantId, id), HttpStatus.OK);
    }
}

