/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.service.roster;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import org.optaweb.employeerostering.domain.employee.Employee;
import org.optaweb.employeerostering.domain.roster.PublishResult;
import org.optaweb.employeerostering.domain.roster.RosterState;
import org.optaweb.employeerostering.domain.roster.view.AvailabilityRosterView;
import org.optaweb.employeerostering.domain.roster.view.ShiftRosterView;
import org.optaweb.employeerostering.domain.spot.Spot;
import org.optaweb.employeerostering.service.roster.RosterService;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest/tenant/{tenantId}/roster"})
@Validated
@Api(tags={"Roster"})
public class RosterController {
    private final RosterService rosterService;

    public RosterController(RosterService rosterService) {
        this.rosterService = rosterService;
        Assert.notNull((Object)rosterService, (String)"rosterService must not be null.");
    }

    @ApiOperation(value="Get the current roster state")
    @GetMapping(value={"/{id}"})
    public ResponseEntity<RosterState> getRosterState(@PathVariable @Min(value=0L) @Min(value=0L) Integer tenantId) {
        return new ResponseEntity((Object)this.rosterService.getRosterState(tenantId), HttpStatus.OK);
    }

    @ApiOperation(value="Get the current shift roster view")
    @GetMapping(value={"/shiftRosterView/current"})
    public ResponseEntity<ShiftRosterView> getCurrentShiftRosterView(@PathVariable @Min(value=0L) @Min(value=0L) Integer tenantId, @RequestParam(name="p", required=false) Integer pageNumber, @RequestParam(name="n", required=false) Integer numberOfItemsPerPage) {
        return new ResponseEntity((Object)this.rosterService.getCurrentShiftRosterView(tenantId, pageNumber, numberOfItemsPerPage), HttpStatus.OK);
    }

    @ApiOperation(value="Get a shift roster view between two dates")
    @GetMapping(value={"/shiftRosterView"})
    public ResponseEntity<ShiftRosterView> getShiftRosterView(@PathVariable @Min(value=0L) @Min(value=0L) Integer tenantId, @RequestParam(name="p", required=false) Integer pageNumber, @RequestParam(name="n", required=false) Integer numberOfItemsPerPage, @RequestParam(name="startDate") String startDateString, @RequestParam(name="endDate") String endDateString) {
        return new ResponseEntity((Object)this.rosterService.getShiftRosterView(tenantId, pageNumber, numberOfItemsPerPage, startDateString, endDateString), HttpStatus.OK);
    }

    @ApiOperation(value="Get a shift roster view between two dates for a subset of the spots")
    @PostMapping(value={"/shiftRosterView/for"})
    public ResponseEntity<ShiftRosterView> getShiftRosterViewFor(@PathVariable @Min(value=0L) @Min(value=0L) Integer tenantId, @RequestParam(name="startDate") String startDateString, @RequestParam(name="endDate") String endDateString, @RequestBody @Valid List<Spot> spots) {
        return new ResponseEntity((Object)this.rosterService.getShiftRosterViewFor(tenantId, startDateString, endDateString, spots), HttpStatus.OK);
    }

    @ApiOperation(value="Get the current availability roster view")
    @GetMapping(value={"/availabilityRosterView/current"})
    public ResponseEntity<AvailabilityRosterView> getCurrentAvailabilityRosterView(@PathVariable @Min(value=0L) @Min(value=0L) Integer tenantId, @RequestParam(name="p", required=false) Integer pageNumber, @RequestParam(name="n", required=false) Integer numberOfItemsPerPage) {
        return new ResponseEntity((Object)this.rosterService.getCurrentAvailabilityRosterView(tenantId, pageNumber, numberOfItemsPerPage), HttpStatus.OK);
    }

    @ApiOperation(value="Get an availability roster view between two dates")
    @GetMapping(value={"/availabilityRosterView"})
    public ResponseEntity<AvailabilityRosterView> getAvailabilityRosterView(@PathVariable @Min(value=0L) @Min(value=0L) Integer tenantId, @RequestParam(name="p", required=false) Integer pageNumber, @RequestParam(name="n", required=false) Integer numberOfItemsPerPage, @RequestParam(name="startDate") String startDateString, @RequestParam(name="endDate") String endDateString) {
        return new ResponseEntity((Object)this.rosterService.getAvailabilityRosterView(tenantId, pageNumber, numberOfItemsPerPage, startDateString, endDateString), HttpStatus.OK);
    }

    @ApiOperation(value="Get an availability roster view between two dates for a subset of the employees")
    @PostMapping(value={"/availabilityRosterView/for"})
    public ResponseEntity<AvailabilityRosterView> getAvailabilityRosterViewFor(@PathVariable @Min(value=0L) @Min(value=0L) Integer tenantId, @RequestParam(name="startDate") String startDateString, @RequestParam(name="endDate") String endDateString, @RequestBody @Valid List<Employee> employees) {
        return new ResponseEntity((Object)this.rosterService.getAvailabilityRosterViewFor(tenantId, startDateString, endDateString, employees), HttpStatus.OK);
    }

    @ApiOperation(value="Start solving the roster. This will assign each shift to an employee")
    @PostMapping(value={"/solve"})
    public void solveRoster(@PathVariable @Min(value=0L) @Min(value=0L) Integer tenantId) {
        this.rosterService.solveRoster(tenantId);
    }

    @ApiOperation(value="Stop solving the roster, if it hasn't terminated automatically already")
    @PostMapping(value={"/terminate"})
    public void terminateRosterEarly(@PathVariable @Min(value=0L) @Min(value=0L) Integer tenantId) {
        this.rosterService.terminateRosterEarly(tenantId);
    }

    @ApiOperation(value="Publish the next set of draft shifts and create a new draft shift from the rotation template")
    @PostMapping(value={"/publishAndProvision"})
    public ResponseEntity<PublishResult> publishAndProvision(@PathVariable @Min(value=0L) @Min(value=0L) Integer tenantId) {
        return new ResponseEntity((Object)this.rosterService.publishAndProvision(tenantId), HttpStatus.OK);
    }
}

