/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.service.shift;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import org.optaweb.employeerostering.domain.shift.view.ShiftView;
import org.optaweb.employeerostering.service.shift.ShiftService;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest/tenant/{tenantId}/shift"})
@Validated
@Api(tags={"Shift"})
public class ShiftController {
    private final ShiftService shiftService;

    public ShiftController(ShiftService shiftService) {
        this.shiftService = shiftService;
        Assert.notNull((Object)shiftService, (String)"shiftService must not be null.");
    }

    @ApiOperation(value="Get a list of all shifts")
    @GetMapping(value={"/"})
    public ResponseEntity<List<ShiftView>> getShiftList(@PathVariable @Min(value=0L) @Min(value=0L) Integer tenantId) {
        return new ResponseEntity((Object)this.shiftService.getShiftList(tenantId), HttpStatus.OK);
    }

    @ApiOperation(value="Get a shift by id")
    @GetMapping(value={"/{id}"})
    public ResponseEntity<ShiftView> getShift(@PathVariable @Min(value=0L) @Min(value=0L) Integer tenantId, @PathVariable @Min(value=0L) @Min(value=0L) Long id) {
        return new ResponseEntity((Object)this.shiftService.getShift(tenantId, id), HttpStatus.OK);
    }

    @ApiOperation(value="Delete a shift")
    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Boolean> deleteShift(@PathVariable @Min(value=0L) @Min(value=0L) Integer tenantId, @PathVariable @Min(value=0L) @Min(value=0L) Long id) {
        return new ResponseEntity((Object)this.shiftService.deleteShift(tenantId, id), HttpStatus.OK);
    }

    @ApiOperation(value="Add a new shift")
    @PostMapping(value={"/add"})
    public ResponseEntity<ShiftView> createShift(@PathVariable @Min(value=0L) @Min(value=0L) Integer tenantId, @RequestBody @Valid ShiftView shiftView) {
        return new ResponseEntity((Object)this.shiftService.createShift(tenantId, shiftView), HttpStatus.OK);
    }

    @ApiOperation(value="Update a shift")
    @PutMapping(value={"/update"})
    public ResponseEntity<ShiftView> updateShift(@PathVariable @Min(value=0L) @Min(value=0L) Integer tenantId, @RequestBody @Valid ShiftView shiftView) {
        return new ResponseEntity((Object)this.shiftService.updateShift(tenantId, shiftView), HttpStatus.OK);
    }
}

