/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.service.spot;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import org.optaweb.employeerostering.domain.spot.Spot;
import org.optaweb.employeerostering.domain.spot.view.SpotView;
import org.optaweb.employeerostering.service.spot.SpotService;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest/tenant/{tenantId}/spot"})
@Validated
@Api(tags={"Spot"})
public class SpotController {
    private final SpotService spotService;

    public SpotController(SpotService spotService) {
        this.spotService = spotService;
        Assert.notNull((Object)spotService, (String)"spotService must not be null.");
    }

    @ApiOperation(value="Get a list of all spots")
    @GetMapping(value={"/"})
    public ResponseEntity<List<Spot>> getSpotList(@PathVariable @Min(value=0L) @Min(value=0L) Integer tenantId) {
        return new ResponseEntity((Object)this.spotService.getSpotList(tenantId), HttpStatus.OK);
    }

    @ApiOperation(value="Get a spot by id")
    @GetMapping(value={"/{id}"})
    public ResponseEntity<Spot> getSpot(@PathVariable @Min(value=0L) @Min(value=0L) Integer tenantId, @PathVariable @Min(value=0L) @Min(value=0L) Long id) {
        return new ResponseEntity((Object)this.spotService.getSpot(tenantId, id), HttpStatus.OK);
    }

    @ApiOperation(value="Delete a spot")
    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Boolean> deleteSpot(@PathVariable @Min(value=0L) @Min(value=0L) Integer tenantId, @PathVariable @Min(value=0L) @Min(value=0L) Long id) {
        return new ResponseEntity((Object)this.spotService.deleteSpot(tenantId, id), HttpStatus.OK);
    }

    @ApiOperation(value="Add a new spot")
    @PostMapping(value={"/add"})
    public ResponseEntity<Spot> createSpot(@PathVariable @Min(value=0L) @Min(value=0L) Integer tenantId, @RequestBody @Valid SpotView spotView) {
        return new ResponseEntity((Object)this.spotService.createSpot(tenantId, spotView), HttpStatus.OK);
    }

    @ApiOperation(value="Update a spot")
    @PostMapping(value={"/update"})
    public ResponseEntity<Spot> updateSpot(@PathVariable @Min(value=0L) @Min(value=0L) Integer tenantId, @RequestBody @Valid SpotView spotView) {
        return new ResponseEntity((Object)this.spotService.updateSpot(tenantId, spotView), HttpStatus.OK);
    }
}

