/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.service.tenant;

import java.time.ZoneId;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.EntityNotFoundException;
import org.optaweb.employeerostering.domain.roster.RosterState;
import org.optaweb.employeerostering.domain.roster.view.RosterStateView;
import org.optaweb.employeerostering.domain.tenant.RosterParametrization;
import org.optaweb.employeerostering.domain.tenant.Tenant;
import org.optaweb.employeerostering.domain.tenant.view.RosterParametrizationView;
import org.optaweb.employeerostering.service.common.AbstractRestService;
import org.optaweb.employeerostering.service.employee.EmployeeAvailabilityRepository;
import org.optaweb.employeerostering.service.employee.EmployeeRepository;
import org.optaweb.employeerostering.service.roster.RosterStateRepository;
import org.optaweb.employeerostering.service.rotation.ShiftTemplateRepository;
import org.optaweb.employeerostering.service.shift.ShiftRepository;
import org.optaweb.employeerostering.service.skill.SkillRepository;
import org.optaweb.employeerostering.service.spot.SpotRepository;
import org.optaweb.employeerostering.service.tenant.RosterParametrizationRepository;
import org.optaweb.employeerostering.service.tenant.TenantRepository;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TenantService
extends AbstractRestService {
    private final TenantRepository tenantRepository;
    private final RosterParametrizationRepository rosterParametrizationRepository;
    private final RosterStateRepository rosterStateRepository;
    private final ShiftRepository shiftRepository;
    private final EmployeeAvailabilityRepository employeeAvailabilityRepository;
    private final ShiftTemplateRepository shiftTemplateRepository;
    private final EmployeeRepository employeeRepository;
    private final SpotRepository spotRepository;
    private final SkillRepository skillRepository;

    public TenantService(TenantRepository tenantRepository, RosterParametrizationRepository rosterParametrizationRepository, RosterStateRepository rosterStateRepository, ShiftRepository shiftRepository, EmployeeAvailabilityRepository employeeAvailabilityRepository, ShiftTemplateRepository shiftTemplateRepository, EmployeeRepository employeeRepository, SpotRepository spotRepository, SkillRepository skillRepository) {
        this.tenantRepository = tenantRepository;
        this.rosterParametrizationRepository = rosterParametrizationRepository;
        this.rosterStateRepository = rosterStateRepository;
        this.shiftRepository = shiftRepository;
        this.employeeAvailabilityRepository = employeeAvailabilityRepository;
        this.shiftTemplateRepository = shiftTemplateRepository;
        this.employeeRepository = employeeRepository;
        this.spotRepository = spotRepository;
        this.skillRepository = skillRepository;
    }

    public RosterState convertFromRosterStateView(RosterStateView rosterStateView) {
        RosterState rosterState = new RosterState(rosterStateView.getTenantId(), rosterStateView.getPublishNotice(), rosterStateView.getFirstDraftDate(), rosterStateView.getPublishLength(), rosterStateView.getDraftLength(), rosterStateView.getUnplannedRotationOffset(), rosterStateView.getRotationLength(), rosterStateView.getLastHistoricDate(), rosterStateView.getTimeZone());
        rosterState.setTenant(rosterStateView.getTenant());
        return rosterState;
    }

    @Transactional
    public List<Tenant> getTenantList() {
        return this.tenantRepository.findAll();
    }

    @Transactional
    public Tenant getTenant(Integer id) {
        return (Tenant)this.tenantRepository.findById((Object)id).orElseThrow(() -> new EntityNotFoundException("No Tenant entity found with ID (" + id + ")."));
    }

    @Transactional
    public Tenant createTenant(RosterStateView initialRosterStateView) {
        RosterState initialRosterState = this.convertFromRosterStateView(initialRosterStateView);
        Tenant databaseTenant = (Tenant)this.tenantRepository.save((Object)initialRosterState.getTenant());
        initialRosterState.setTenant(databaseTenant);
        initialRosterState.setTenantId(databaseTenant.getId());
        RosterParametrization rosterParametrization = new RosterParametrization();
        rosterParametrization.setTenantId(databaseTenant.getId());
        this.rosterStateRepository.save((Object)initialRosterState);
        this.rosterParametrizationRepository.save((Object)rosterParametrization);
        return databaseTenant;
    }

    @Transactional
    public Boolean deleteTenant(Integer id) {
        this.shiftRepository.deleteForTenant(id);
        this.employeeAvailabilityRepository.deleteForTenant(id);
        this.shiftTemplateRepository.deleteForTenant(id);
        this.employeeRepository.deleteForTenant(id);
        this.spotRepository.deleteForTenant(id);
        this.skillRepository.deleteForTenant(id);
        this.rosterParametrizationRepository.deleteForTenant(id);
        this.rosterStateRepository.deleteForTenant(id);
        this.tenantRepository.deleteById((Object)id);
        return true;
    }

    @Transactional
    public RosterParametrization getRosterParametrization(Integer tenantId) {
        return (RosterParametrization)this.rosterParametrizationRepository.findByTenantId(tenantId).orElseThrow(() -> new EntityNotFoundException("No RosterParametrization entity found with tenantId (" + tenantId + ")."));
    }

    @Transactional
    public RosterParametrization updateRosterParametrization(RosterParametrizationView rosterParametrizationView) {
        RosterParametrization oldRosterParametrization = (RosterParametrization)this.rosterParametrizationRepository.findByTenantId(rosterParametrizationView.getTenantId()).orElseThrow(() -> new EntityNotFoundException("RosterParametrization entity with tenantId (" + rosterParametrizationView.getTenantId() + ") not found."));
        if (!oldRosterParametrization.getTenantId().equals(rosterParametrizationView.getTenantId())) {
            throw new IllegalStateException("RosterParametrization entity with tenantId (" + oldRosterParametrization.getTenantId() + ") cannot change tenants.");
        }
        oldRosterParametrization.setDesiredTimeSlotWeight(rosterParametrizationView.getDesiredTimeSlotWeight());
        oldRosterParametrization.setRotationEmployeeMatchWeight(rosterParametrizationView.getRotationEmployeeMatchWeight());
        oldRosterParametrization.setUndesiredTimeSlotWeight(rosterParametrizationView.getUndesiredTimeSlotWeight());
        oldRosterParametrization.setWeekStartDay(rosterParametrizationView.getWeekStartDay());
        return (RosterParametrization)this.rosterParametrizationRepository.save((Object)oldRosterParametrization);
    }

    public List<ZoneId> getSupportedTimezones() {
        return ZoneId.getAvailableZoneIds().stream().sorted().map(zoneId -> ZoneId.of(zoneId)).collect(Collectors.toList());
    }
}

