/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.solver;

import java.util.concurrent.CountDownLatch;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.optaplanner.core.api.score.buildin.hardmediumsoftlong.HardMediumSoftLongScore;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaweb.employeerostering.domain.roster.Roster;
import org.optaweb.employeerostering.service.roster.RosterGenerator;
import org.optaweb.employeerostering.service.roster.RosterService;
import org.optaweb.employeerostering.service.solver.WannabeSolverManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.jdbc.AutoConfigureTestDatabase;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(value=SpringRunner.class)
@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.DEFINED_PORT)
@AutoConfigureTestDatabase
public class SolverManagerTest {
    @Autowired
    private ThreadPoolTaskExecutor taskExecutor;
    @Autowired
    private RosterService rosterService;
    @Autowired
    private RosterGenerator rosterGenerator;
    @PersistenceContext
    private EntityManager entityManager;

    @Test
    public void testSolverManager() throws InterruptedException {
        WannabeSolverManager solverManager = new WannabeSolverManager(this.taskExecutor, this.rosterService);
        solverManager.setUpSolverFactory();
        Roster roster = this.rosterGenerator.generateRoster(10, 7);
        CountDownLatch solverEndedLatch = solverManager.solve(roster.getTenantId());
        solverEndedLatch.await();
        ScoreDirector scoreDirector = solverManager.getScoreDirector();
        scoreDirector.setWorkingSolution((Object)roster);
        roster.setScore((HardMediumSoftLongScore)scoreDirector.calculateScore());
        Assert.assertNotNull((Object)roster.getScore());
        Assert.assertTrue((boolean)roster.getScore().isFeasible());
        Assert.assertFalse((boolean)roster.getShiftList().isEmpty());
        Assert.assertTrue((boolean)roster.getShiftList().stream().anyMatch(s -> s.getEmployee() != null));
    }
}

