/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.util;

import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.optaweb.employeerostering.util.HierarchyTree;

public class HierarchyTreeTest {
    private HierarchyTree<Integer, String> tested;

    @Before
    public void setup() {
        this.tested = new HierarchyTree((a, b) -> {
            if (a == b) {
                return HierarchyTree.HierarchyRelationship.IS_THE_SAME_AS;
            }
            if (a % b == 0) {
                return HierarchyTree.HierarchyRelationship.IS_BELOW;
            }
            if (b % a == 0) {
                return HierarchyTree.HierarchyRelationship.IS_ABOVE;
            }
            return HierarchyTree.HierarchyRelationship.HAS_NO_DIRECT_RELATION;
        });
    }

    @Test
    public void testPutInHierarchyAndGetHierarchyClassValue() {
        Assert.assertEquals(Optional.empty(), (Object)this.tested.getHierarchyClassValue((Object)2));
        Assert.assertEquals(Optional.empty(), (Object)this.tested.getHierarchyClassValue((Object)4));
        Assert.assertEquals(Optional.empty(), (Object)this.tested.getHierarchyClassValue((Object)6));
        Assert.assertEquals(Optional.empty(), (Object)this.tested.getHierarchyClassValue((Object)3));
        this.tested.putInHierarchy((Object)4, (Object)"4");
        Assert.assertEquals(Optional.empty(), (Object)this.tested.getHierarchyClassValue((Object)2));
        Assert.assertEquals(Optional.of("4"), (Object)this.tested.getHierarchyClassValue((Object)4));
        Assert.assertEquals(Optional.of("4"), (Object)this.tested.getHierarchyClassValue((Object)12));
        Assert.assertEquals(Optional.empty(), (Object)this.tested.getHierarchyClassValue((Object)3));
        this.tested.putInHierarchy((Object)12, (Object)"12");
        Assert.assertEquals(Optional.empty(), (Object)this.tested.getHierarchyClassValue((Object)2));
        Assert.assertEquals(Optional.of("4"), (Object)this.tested.getHierarchyClassValue((Object)4));
        Assert.assertEquals(Optional.of("12"), (Object)this.tested.getHierarchyClassValue((Object)12));
        Assert.assertEquals(Optional.empty(), (Object)this.tested.getHierarchyClassValue((Object)3));
        this.tested.putInHierarchy((Object)3, (Object)"3");
        Assert.assertEquals(Optional.empty(), (Object)this.tested.getHierarchyClassValue((Object)2));
        Assert.assertEquals(Optional.of("4"), (Object)this.tested.getHierarchyClassValue((Object)4));
        Assert.assertEquals(Optional.of("12"), (Object)this.tested.getHierarchyClassValue((Object)12));
        Assert.assertEquals(Optional.of("3"), (Object)this.tested.getHierarchyClassValue((Object)3));
        this.tested.putInHierarchy((Object)2, (Object)"2");
        Assert.assertEquals(Optional.of("2"), (Object)this.tested.getHierarchyClassValue((Object)2));
        Assert.assertEquals(Optional.of("4"), (Object)this.tested.getHierarchyClassValue((Object)4));
        Assert.assertEquals(Optional.of("12"), (Object)this.tested.getHierarchyClassValue((Object)12));
        Assert.assertEquals(Optional.of("3"), (Object)this.tested.getHierarchyClassValue((Object)3));
    }
}

