/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.service.admin;

import java.time.DateTimeException;
import java.time.ZoneId;

public class SystemPropertiesRetriever {
    public static final String ZONE_ID_SYSTEM_PROPERTY = "optaweb.generator.timeZoneId";
    public static final String INITIAL_DATA_PROPERTY = "optaweb.generator.initial.data";

    public static ZoneId determineZoneId() {
        String zoneIdProperty = System.getProperty(ZONE_ID_SYSTEM_PROPERTY);
        if (zoneIdProperty != null) {
            try {
                return ZoneId.of(zoneIdProperty);
            }
            catch (DateTimeException e) {
                throw new IllegalStateException("The system property (optaweb.generator.timeZoneId) has an invalid value (" + zoneIdProperty + ").", e);
            }
        }
        return ZoneId.systemDefault();
    }

    public static InitialData determineInitialData() {
        String initialDataProperty = System.getProperty(INITIAL_DATA_PROPERTY);
        if (initialDataProperty != null) {
            try {
                return InitialData.valueOf(initialDataProperty);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalStateException("The system property (optaweb.generator.initial.data) has an invalid value (" + initialDataProperty + ").", e);
            }
        }
        return InitialData.DEMO_DATA;
    }

    private SystemPropertiesRetriever() {
    }

    public static enum InitialData {
        EMPTY,
        DEMO_DATA;

    }
}

