/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.employee;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.HashSet;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.optaweb.employeerostering.AbstractEntityRequireTenantRestServiceTest;
import org.optaweb.employeerostering.domain.contract.Contract;
import org.optaweb.employeerostering.domain.contract.view.ContractView;
import org.optaweb.employeerostering.domain.employee.Employee;
import org.optaweb.employeerostering.domain.employee.EmployeeAvailabilityState;
import org.optaweb.employeerostering.domain.employee.view.EmployeeAvailabilityView;
import org.optaweb.employeerostering.domain.employee.view.EmployeeView;
import org.optaweb.employeerostering.domain.skill.Skill;
import org.optaweb.employeerostering.domain.skill.view.SkillView;
import org.optaweb.employeerostering.service.contract.ContractService;
import org.optaweb.employeerostering.service.employee.EmployeeService;
import org.optaweb.employeerostering.service.skill.SkillService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.jdbc.AutoConfigureTestDatabase;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureMockMvc;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.http.MediaType;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=SpringRunner.class)
@SpringBootTest
@AutoConfigureTestDatabase
@AutoConfigureMockMvc
@Transactional
public class EmployeeServiceTest
extends AbstractEntityRequireTenantRestServiceTest {
    private static final Logger logger = LoggerFactory.getLogger(EmployeeServiceTest.class);
    @Autowired
    private MockMvc mvc;
    @Autowired
    private EmployeeService employeeService;
    @Autowired
    private SkillService skillService;
    @Autowired
    private ContractService contractService;

    private Skill createSkill(Integer tenantId, String name) {
        SkillView skillView = new SkillView(tenantId, name);
        return this.skillService.createSkill(tenantId, skillView);
    }

    private Contract createContract(Integer tenantId, String name) {
        ContractView contractView = new ContractView(tenantId, name);
        return this.contractService.createContract(tenantId, contractView);
    }

    private EmployeeAvailabilityView createEmployeeAvailability(Integer tenantId, Employee employee, LocalDateTime startDateTime, LocalDateTime endDateTime, EmployeeAvailabilityState state) {
        EmployeeAvailabilityView employeeAvailabilityView = new EmployeeAvailabilityView(tenantId, employee, startDateTime, endDateTime, state);
        return this.employeeService.createEmployeeAvailability(tenantId, employeeAvailabilityView);
    }

    @Before
    public void setup() {
        this.createTestTenant();
    }

    @After
    public void cleanup() {
        this.deleteTestTenant();
    }

    @Test
    public void getEmployeeListTest() throws Exception {
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/rest/tenant/{tenantId}/employee/", (Object[])new Object[]{this.TENANT_ID}).accept(new MediaType[]{MediaType.APPLICATION_JSON})).andDo(mvcResult -> logger.info(mvcResult.toString())).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void getEmployeeTest() throws Exception {
        Skill skillA = this.createSkill(this.TENANT_ID, "A");
        Skill skillB = this.createSkill(this.TENANT_ID, "B");
        HashSet<Skill> testSkillSet = new HashSet<Skill>();
        testSkillSet.add(skillA);
        testSkillSet.add(skillB);
        Contract contract = this.createContract(this.TENANT_ID, "contract");
        EmployeeView employeeView = new EmployeeView(this.TENANT_ID, "employee", contract, testSkillSet);
        Employee employee = this.employeeService.createEmployee(this.TENANT_ID, employeeView);
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/rest/tenant/{tenantId}/employee/{id}", (Object[])new Object[]{this.TENANT_ID, employee.getId()}).accept(new MediaType[]{MediaType.APPLICATION_JSON})).andDo(mvcResult -> logger.info(mvcResult.toString())).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.tenantId", (Object[])new Object[0]).value((Object)this.TENANT_ID)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.name", (Object[])new Object[0]).value((Object)"employee")).andExpect(MockMvcResultMatchers.jsonPath((String)"$.contract", (Object[])new Object[0]).value((Object)contract)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.skillProficiencySet", (Object[])new Object[0]).isNotEmpty());
    }

    @Test
    public void getNonExistentEmployeeTest() throws Exception {
        String exceptionMessage = "No Employee entity found with ID (0).";
        String exceptionClass = "javax.persistence.EntityNotFoundException";
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/rest/tenant/{tenantId}/employee/{id}", (Object[])new Object[]{this.TENANT_ID, 0}).accept(new MediaType[]{MediaType.APPLICATION_JSON})).andDo(mvcResult -> logger.info(mvcResult.toString())).andExpect(MockMvcResultMatchers.status().isNotFound()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.exceptionMessage", (Object[])new Object[0]).value((Object)exceptionMessage)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.exceptionClass", (Object[])new Object[0]).value((Object)exceptionClass));
    }

    @Test
    public void getNonMatchingEmployeeTest() throws Exception {
        String exceptionMessage = "The tenantId (0) does not match the persistable (employee)'s tenantId (" + this.TENANT_ID + ").";
        String exceptionClass = "java.lang.IllegalStateException";
        Skill skillA = this.createSkill(this.TENANT_ID, "A");
        Skill skillB = this.createSkill(this.TENANT_ID, "B");
        HashSet<Skill> testSkillSet = new HashSet<Skill>();
        testSkillSet.add(skillA);
        testSkillSet.add(skillB);
        Contract contract = this.createContract(this.TENANT_ID, "contract");
        EmployeeView employeeView = new EmployeeView(this.TENANT_ID, "employee", contract, testSkillSet);
        Employee employee = this.employeeService.createEmployee(this.TENANT_ID, employeeView);
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/rest/tenant/{tenantId}/employee/{id}", (Object[])new Object[]{0, employee.getId()}).accept(new MediaType[]{MediaType.APPLICATION_JSON})).andDo(mvcResult -> logger.info(mvcResult.toString())).andExpect(MockMvcResultMatchers.status().isInternalServerError()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.exceptionMessage", (Object[])new Object[0]).value((Object)exceptionMessage)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.exceptionClass", (Object[])new Object[0]).value((Object)exceptionClass));
    }

    @Test
    public void deleteEmployeeTest() throws Exception {
        Skill skillA = this.createSkill(this.TENANT_ID, "A");
        Skill skillB = this.createSkill(this.TENANT_ID, "B");
        HashSet<Skill> testSkillSet = new HashSet<Skill>();
        testSkillSet.add(skillA);
        testSkillSet.add(skillB);
        Contract contract = this.createContract(this.TENANT_ID, "contract");
        EmployeeView employeeView = new EmployeeView(this.TENANT_ID, "employee", contract, testSkillSet);
        Employee employee = this.employeeService.createEmployee(this.TENANT_ID, employeeView);
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/rest/tenant/{tenantId}/employee/{id}", (Object[])new Object[]{this.TENANT_ID, employee.getId()}).accept(new MediaType[]{MediaType.APPLICATION_JSON})).andDo(mvcResult -> logger.info(mvcResult.toString())).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType("application/json")).andExpect(MockMvcResultMatchers.content().string("true"));
    }

    @Test
    public void deleteNonExistentEmployeeTest() throws Exception {
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/rest/tenant/{tenantId}/employee/{id}", (Object[])new Object[]{this.TENANT_ID, 0}).accept(new MediaType[]{MediaType.APPLICATION_JSON})).andDo(mvcResult -> logger.info(mvcResult.toString())).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType("application/json")).andExpect(MockMvcResultMatchers.content().string("false"));
    }

    @Test
    public void deleteNonMatchingEmployeeTest() throws Exception {
        String exceptionMessage = "The tenantId (0) does not match the persistable (employee)'s tenantId (" + this.TENANT_ID + ").";
        String exceptionClass = "java.lang.IllegalStateException";
        Skill skillA = this.createSkill(this.TENANT_ID, "A");
        Skill skillB = this.createSkill(this.TENANT_ID, "B");
        HashSet<Skill> testSkillSet = new HashSet<Skill>();
        testSkillSet.add(skillA);
        testSkillSet.add(skillB);
        Contract contract = this.createContract(this.TENANT_ID, "contract");
        EmployeeView employeeView = new EmployeeView(this.TENANT_ID, "employee", contract, testSkillSet);
        Employee employee = this.employeeService.createEmployee(this.TENANT_ID, employeeView);
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/rest/tenant/{tenantId}/employee/{id}", (Object[])new Object[]{0, employee.getId()}).accept(new MediaType[]{MediaType.APPLICATION_JSON})).andDo(mvcResult -> logger.info(mvcResult.toString())).andExpect(MockMvcResultMatchers.status().isInternalServerError()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.exceptionMessage", (Object[])new Object[0]).value((Object)exceptionMessage)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.exceptionClass", (Object[])new Object[0]).value((Object)exceptionClass));
    }

    @Test
    public void createEmployeeTest() throws Exception {
        Skill skillA = this.createSkill(this.TENANT_ID, "A");
        Skill skillB = this.createSkill(this.TENANT_ID, "B");
        HashSet<Skill> testSkillSet = new HashSet<Skill>();
        testSkillSet.add(skillA);
        testSkillSet.add(skillB);
        Contract contract = this.createContract(this.TENANT_ID, "contract");
        EmployeeView employeeView = new EmployeeView(this.TENANT_ID, "employee", contract, testSkillSet);
        String body = new ObjectMapper().writeValueAsString((Object)employeeView);
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/rest/tenant/{tenantId}/employee/add", (Object[])new Object[]{this.TENANT_ID}).contentType(MediaType.APPLICATION_JSON).content(body).accept(new MediaType[]{MediaType.APPLICATION_JSON})).andDo(mvcResult -> logger.info(mvcResult.toString())).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.tenantId", (Object[])new Object[0]).value((Object)this.TENANT_ID)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.name", (Object[])new Object[0]).value((Object)"employee")).andExpect(MockMvcResultMatchers.jsonPath((String)"$.contract", (Object[])new Object[0]).value((Object)contract)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.skillProficiencySet", (Object[])new Object[0]).isNotEmpty());
    }

    @Test
    public void createNonMatchingEmployeeTest() throws Exception {
        String exceptionMessage = "The tenantId (0) does not match the persistable (employee)'s tenantId (" + this.TENANT_ID + ").";
        String exceptionClass = "java.lang.IllegalStateException";
        Skill skillA = this.createSkill(this.TENANT_ID, "A");
        Skill skillB = this.createSkill(this.TENANT_ID, "B");
        HashSet<Skill> testSkillSet = new HashSet<Skill>();
        testSkillSet.add(skillA);
        testSkillSet.add(skillB);
        Contract contract = this.createContract(this.TENANT_ID, "contract");
        EmployeeView employeeView = new EmployeeView(this.TENANT_ID, "employee", contract, testSkillSet);
        String body = new ObjectMapper().writeValueAsString((Object)employeeView);
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/rest/tenant/{tenantId}/employee/add", (Object[])new Object[]{0}).contentType(MediaType.APPLICATION_JSON).content(body)).andDo(mvcResult -> logger.info(mvcResult.toString())).andExpect(MockMvcResultMatchers.status().isInternalServerError()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.exceptionMessage", (Object[])new Object[0]).value((Object)exceptionMessage)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.exceptionClass", (Object[])new Object[0]).value((Object)exceptionClass));
    }

    @Test
    public void createNonMatchingSkillProficiencyTest() throws Exception {
        String exceptionMessage = "The tenantId (" + this.TENANT_ID + ") does not match the skillProficiency (A)'s tenantId (0).";
        String exceptionClass = "java.lang.IllegalStateException";
        Skill skillA = this.createSkill(0, "A");
        HashSet<Skill> testSkillSet = new HashSet<Skill>();
        testSkillSet.add(skillA);
        Contract contract = this.createContract(this.TENANT_ID, "contract");
        EmployeeView employeeView = new EmployeeView(this.TENANT_ID, "employee", contract, testSkillSet);
        String body = new ObjectMapper().writeValueAsString((Object)employeeView);
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/rest/tenant/{tenantId}/employee/add", (Object[])new Object[]{this.TENANT_ID}).contentType(MediaType.APPLICATION_JSON).content(body)).andDo(mvcResult -> logger.info(mvcResult.toString())).andExpect(MockMvcResultMatchers.status().isInternalServerError()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.exceptionMessage", (Object[])new Object[0]).value((Object)exceptionMessage)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.exceptionClass", (Object[])new Object[0]).value((Object)exceptionClass));
    }

    @Test
    public void updateEmployeeTest() throws Exception {
        Skill skillA = this.createSkill(this.TENANT_ID, "A");
        Skill skillB = this.createSkill(this.TENANT_ID, "B");
        HashSet<Skill> testSkillSet = new HashSet<Skill>();
        testSkillSet.add(skillA);
        testSkillSet.add(skillB);
        Contract contract = this.createContract(this.TENANT_ID, "contract");
        EmployeeView employeeView = new EmployeeView(this.TENANT_ID, "employee", contract, Collections.emptySet());
        Employee employee = this.employeeService.createEmployee(this.TENANT_ID, employeeView);
        EmployeeView updatedEmployee = new EmployeeView(this.TENANT_ID, "updatedEmployee", contract, testSkillSet);
        updatedEmployee.setId(employee.getId());
        String body = new ObjectMapper().writeValueAsString((Object)updatedEmployee);
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/rest/tenant/{tenantId}/employee/update", (Object[])new Object[]{this.TENANT_ID}).contentType(MediaType.APPLICATION_JSON).content(body).accept(new MediaType[]{MediaType.APPLICATION_JSON})).andDo(mvcResult -> logger.info(mvcResult.toString())).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.tenantId", (Object[])new Object[0]).value((Object)this.TENANT_ID)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.name", (Object[])new Object[0]).value((Object)"updatedEmployee")).andExpect(MockMvcResultMatchers.jsonPath((String)"$.contract", (Object[])new Object[0]).value((Object)contract)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.skillProficiencySet", (Object[])new Object[0]).isNotEmpty());
    }

    @Test
    public void updateNonMatchingEmployeeTest() throws Exception {
        String exceptionMessage = "The tenantId (0) does not match the persistable (updatedEmployee)'s tenantId (" + this.TENANT_ID + ").";
        String exceptionClass = "java.lang.IllegalStateException";
        Skill skillA = this.createSkill(this.TENANT_ID, "A");
        Skill skillB = this.createSkill(this.TENANT_ID, "B");
        HashSet<Skill> testSkillSet = new HashSet<Skill>();
        testSkillSet.add(skillA);
        testSkillSet.add(skillB);
        Contract contract = this.createContract(this.TENANT_ID, "contract");
        EmployeeView employeeView = new EmployeeView(this.TENANT_ID, "employee", contract, testSkillSet);
        this.employeeService.createEmployee(this.TENANT_ID, employeeView);
        EmployeeView updatedEmployee = new EmployeeView(this.TENANT_ID, "updatedEmployee", contract, testSkillSet);
        String body = new ObjectMapper().writeValueAsString((Object)updatedEmployee);
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/rest/tenant/{tenantId}/employee/update", (Object[])new Object[]{0}).contentType(MediaType.APPLICATION_JSON).content(body)).andDo(mvcResult -> logger.info(mvcResult.toString())).andExpect(MockMvcResultMatchers.status().isInternalServerError()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.exceptionMessage", (Object[])new Object[0]).value((Object)exceptionMessage)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.exceptionClass", (Object[])new Object[0]).value((Object)exceptionClass));
    }

    @Test
    public void updateNonExistentEmployeeTest() throws Exception {
        String exceptionMessage = "Employee entity with ID (0) not found.";
        String exceptionClass = "javax.persistence.EntityNotFoundException";
        Contract contract = new Contract();
        EmployeeView employeeView = new EmployeeView(this.TENANT_ID, "employee", contract, Collections.emptySet());
        employeeView.setId(Long.valueOf(0L));
        String body = new ObjectMapper().writeValueAsString((Object)employeeView);
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/rest/tenant/{tenantId}/employee/update", (Object[])new Object[]{this.TENANT_ID}).contentType(MediaType.APPLICATION_JSON).content(body)).andDo(mvcResult -> logger.info(mvcResult.toString())).andExpect(MockMvcResultMatchers.status().isNotFound()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.exceptionMessage", (Object[])new Object[0]).value((Object)exceptionMessage)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.exceptionClass", (Object[])new Object[0]).value((Object)exceptionClass));
    }

    @Test
    public void updateChangeTenantIdEmployeeTest() throws Exception {
        String exceptionMessage = "Employee entity with tenantId (" + this.TENANT_ID + ") cannot change tenants.";
        String exceptionClass = "java.lang.IllegalStateException";
        Skill skillA = this.createSkill(this.TENANT_ID, "A");
        Skill skillB = this.createSkill(this.TENANT_ID, "B");
        HashSet<Skill> testSkillSet = new HashSet<Skill>();
        testSkillSet.add(skillA);
        testSkillSet.add(skillB);
        Contract contractA = this.createContract(this.TENANT_ID, "A");
        Contract contractB = this.createContract(0, "B");
        EmployeeView employeeView = new EmployeeView(this.TENANT_ID, "employee", contractA, testSkillSet);
        Employee employee = this.employeeService.createEmployee(this.TENANT_ID, employeeView);
        EmployeeView updatedEmployee = new EmployeeView(Integer.valueOf(0), "updatedEmployee", contractB, Collections.emptySet());
        updatedEmployee.setId(employee.getId());
        String body = new ObjectMapper().writeValueAsString((Object)updatedEmployee);
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/rest/tenant/{tenantId}/employee/update", (Object[])new Object[]{0}).contentType(MediaType.APPLICATION_JSON).content(body)).andDo(mvcResult -> logger.info(mvcResult.toString())).andExpect(MockMvcResultMatchers.status().isInternalServerError()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.exceptionMessage", (Object[])new Object[0]).value((Object)exceptionMessage)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.exceptionClass", (Object[])new Object[0]).value((Object)exceptionClass));
    }

    @Test
    public void getEmployeeAvailabilityTest() throws Exception {
        Contract contract = this.createContract(this.TENANT_ID, "contract");
        EmployeeView employeeView = new EmployeeView(this.TENANT_ID, "employee", contract, Collections.emptySet());
        Employee employee = this.employeeService.createEmployee(this.TENANT_ID, employeeView);
        LocalDateTime startDateTime = LocalDateTime.of(1999, 12, 31, 23, 59);
        LocalDateTime endDateTime = LocalDateTime.of(2000, 1, 1, 0, 0);
        EmployeeAvailabilityView employeeAvailabilityView = new EmployeeAvailabilityView(this.TENANT_ID, employee, startDateTime, endDateTime, EmployeeAvailabilityState.UNAVAILABLE);
        EmployeeAvailabilityView persistedEmployeeAvailabilityView = this.employeeService.createEmployeeAvailability(this.TENANT_ID, employeeAvailabilityView);
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/rest/tenant/{tenantId}/employee/availability/{id}", (Object[])new Object[]{this.TENANT_ID, persistedEmployeeAvailabilityView.getId()}).accept(new MediaType[]{MediaType.APPLICATION_JSON})).andDo(mvcResult -> logger.info(mvcResult.toString())).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.tenantId", (Object[])new Object[0]).value((Object)this.TENANT_ID)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.employeeId", (Object[])new Object[0]).value((Object)employee.getId())).andExpect(MockMvcResultMatchers.jsonPath((String)"$.startDateTime", (Object[])new Object[0]).value((Object)"1999-12-31T23:59:00")).andExpect(MockMvcResultMatchers.jsonPath((String)"$.endDateTime", (Object[])new Object[0]).value((Object)"2000-01-01T00:00:00")).andExpect(MockMvcResultMatchers.jsonPath((String)"$.state", (Object[])new Object[0]).value((Object)"UNAVAILABLE"));
    }

    @Test
    public void getNonExistentEmployeeAvailabilityTest() throws Exception {
        String exceptionMessage = "No EmployeeAvailability entity found with ID (0).";
        String exceptionClass = "javax.persistence.EntityNotFoundException";
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/rest/tenant/{tenantId}/employee/availability/{id}", (Object[])new Object[]{this.TENANT_ID, 0}).accept(new MediaType[]{MediaType.APPLICATION_JSON})).andDo(mvcResult -> logger.info(mvcResult.toString())).andExpect(MockMvcResultMatchers.status().isNotFound()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.exceptionMessage", (Object[])new Object[0]).value((Object)exceptionMessage)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.exceptionClass", (Object[])new Object[0]).value((Object)exceptionClass));
    }

    @Test
    public void getNonMatchingEmployeeAvailabilityTest() throws Exception {
        String exceptionMessage = "The tenantId (0) does not match the persistable (employee:1999-12-31T23:59Z-2000-01-01T00:00Z)'s tenantId (" + this.TENANT_ID + ").";
        String exceptionClass = "java.lang.IllegalStateException";
        Contract contract = this.createContract(this.TENANT_ID, "contract");
        EmployeeView employeeView = new EmployeeView(this.TENANT_ID, "employee", contract, Collections.emptySet());
        Employee employee = this.employeeService.createEmployee(this.TENANT_ID, employeeView);
        LocalDateTime startDateTime = LocalDateTime.of(1999, 12, 31, 23, 59);
        LocalDateTime endDateTime = LocalDateTime.of(2000, 1, 1, 0, 0);
        EmployeeAvailabilityView employeeAvailabilityView = new EmployeeAvailabilityView(this.TENANT_ID, employee, startDateTime, endDateTime, EmployeeAvailabilityState.UNAVAILABLE);
        EmployeeAvailabilityView persistedEmployeeAvailabilityView = this.employeeService.createEmployeeAvailability(this.TENANT_ID, employeeAvailabilityView);
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/rest/tenant/{tenantId}/employee/availability/{id}", (Object[])new Object[]{0, persistedEmployeeAvailabilityView.getId()}).accept(new MediaType[]{MediaType.APPLICATION_JSON})).andDo(mvcResult -> logger.info(mvcResult.toString())).andExpect(MockMvcResultMatchers.status().isInternalServerError()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.exceptionMessage", (Object[])new Object[0]).value((Object)exceptionMessage)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.exceptionClass", (Object[])new Object[0]).value((Object)exceptionClass));
    }

    @Test
    public void deleteEmployeeAvailabilityTest() throws Exception {
        Contract contract = this.createContract(this.TENANT_ID, "contract");
        EmployeeView employeeView = new EmployeeView(this.TENANT_ID, "employee", contract, Collections.emptySet());
        Employee employee = this.employeeService.createEmployee(this.TENANT_ID, employeeView);
        LocalDateTime startDateTime = LocalDateTime.of(1999, 12, 31, 23, 59);
        LocalDateTime endDateTime = LocalDateTime.of(2000, 1, 1, 0, 0);
        EmployeeAvailabilityView employeeAvailabilityView = new EmployeeAvailabilityView(this.TENANT_ID, employee, startDateTime, endDateTime, EmployeeAvailabilityState.UNAVAILABLE);
        EmployeeAvailabilityView persistedEmployeeAvailabilityView = this.employeeService.createEmployeeAvailability(this.TENANT_ID, employeeAvailabilityView);
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/rest/tenant/{tenantId}/employee/availability/{id}", (Object[])new Object[]{this.TENANT_ID, persistedEmployeeAvailabilityView.getId()}).accept(new MediaType[]{MediaType.APPLICATION_JSON})).andDo(mvcResult -> logger.info(mvcResult.toString())).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType("application/json")).andExpect(MockMvcResultMatchers.content().string("true"));
    }

    @Test
    public void deleteNonExistentEmployeeAvailabilityTest() throws Exception {
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/rest/tenant/{tenantId}/employee/availability/{id}", (Object[])new Object[]{this.TENANT_ID, 0}).accept(new MediaType[]{MediaType.APPLICATION_JSON})).andDo(mvcResult -> logger.info(mvcResult.toString())).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType("application/json")).andExpect(MockMvcResultMatchers.content().string("false"));
    }

    @Test
    public void deleteNonMatchingEmployeeAvailabilityTest() throws Exception {
        String exceptionMessage = "The tenantId (0) does not match the persistable (employee:1999-12-31T23:59Z-2000-01-01T00:00Z)'s tenantId (" + this.TENANT_ID + ").";
        String exceptionClass = "java.lang.IllegalStateException";
        Contract contract = this.createContract(this.TENANT_ID, "contract");
        EmployeeView employeeView = new EmployeeView(this.TENANT_ID, "employee", contract, Collections.emptySet());
        Employee employee = this.employeeService.createEmployee(this.TENANT_ID, employeeView);
        LocalDateTime startDateTime = LocalDateTime.of(1999, 12, 31, 23, 59);
        LocalDateTime endDateTime = LocalDateTime.of(2000, 1, 1, 0, 0);
        EmployeeAvailabilityView employeeAvailabilityView = new EmployeeAvailabilityView(this.TENANT_ID, employee, startDateTime, endDateTime, EmployeeAvailabilityState.UNAVAILABLE);
        EmployeeAvailabilityView persistedEmployeeAvailabilityView = this.employeeService.createEmployeeAvailability(this.TENANT_ID, employeeAvailabilityView);
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/rest/tenant/{tenantId}/employee/availability/{id}", (Object[])new Object[]{0, persistedEmployeeAvailabilityView.getId()}).accept(new MediaType[]{MediaType.APPLICATION_JSON})).andDo(mvcResult -> logger.info(mvcResult.toString())).andExpect(MockMvcResultMatchers.status().isInternalServerError()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.exceptionMessage", (Object[])new Object[0]).value((Object)exceptionMessage)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.exceptionClass", (Object[])new Object[0]).value((Object)exceptionClass));
    }

    @Test
    public void createEmployeeAvailabilityTest() throws Exception {
        Contract contract = this.createContract(this.TENANT_ID, "contract");
        EmployeeView employeeView = new EmployeeView(this.TENANT_ID, "employee", contract, Collections.emptySet());
        Employee employee = this.employeeService.createEmployee(this.TENANT_ID, employeeView);
        LocalDateTime startDateTime = LocalDateTime.of(1999, 12, 31, 23, 59);
        LocalDateTime endDateTime = LocalDateTime.of(2000, 1, 1, 0, 0);
        EmployeeAvailabilityView employeeAvailabilityView = new EmployeeAvailabilityView(this.TENANT_ID, employee, startDateTime, endDateTime, EmployeeAvailabilityState.UNAVAILABLE);
        String body = new ObjectMapper().writeValueAsString((Object)employeeAvailabilityView);
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/rest/tenant/{tenantId}/employee/availability/add", (Object[])new Object[]{this.TENANT_ID}).contentType(MediaType.APPLICATION_JSON).content(body).accept(new MediaType[]{MediaType.APPLICATION_JSON})).andDo(mvcResult -> logger.info(mvcResult.toString())).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.tenantId", (Object[])new Object[0]).value((Object)this.TENANT_ID)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.employeeId", (Object[])new Object[0]).value((Object)employee.getId())).andExpect(MockMvcResultMatchers.jsonPath((String)"$.startDateTime", (Object[])new Object[0]).value((Object)"1999-12-31T23:59:00")).andExpect(MockMvcResultMatchers.jsonPath((String)"$.endDateTime", (Object[])new Object[0]).value((Object)"2000-01-01T00:00:00")).andExpect(MockMvcResultMatchers.jsonPath((String)"$.state", (Object[])new Object[0]).value((Object)"UNAVAILABLE"));
    }

    @Test
    public void createNonMatchingEmployeeAvailabilityTest() throws Exception {
        Contract contract = this.createContract(this.TENANT_ID, "contract");
        EmployeeView employeeView = new EmployeeView(this.TENANT_ID, "employee", contract, Collections.emptySet());
        Employee employee = this.employeeService.createEmployee(this.TENANT_ID, employeeView);
        LocalDateTime startDateTime = LocalDateTime.of(1999, 12, 31, 23, 59);
        LocalDateTime endDateTime = LocalDateTime.of(2000, 1, 1, 0, 0);
        EmployeeAvailabilityView employeeAvailabilityView = new EmployeeAvailabilityView(this.TENANT_ID, employee, startDateTime, endDateTime, EmployeeAvailabilityState.UNAVAILABLE);
        String body = new ObjectMapper().writeValueAsString((Object)employeeAvailabilityView);
        String employeeAvailabilityName = employeeAvailabilityView.getEmployeeId() + ":" + startDateTime + "-" + endDateTime;
        String exceptionMessage = "The tenantId (0) does not match the persistable (" + employeeAvailabilityName + ")'s tenantId (" + this.TENANT_ID + ").";
        String exceptionClass = "java.lang.IllegalStateException";
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/rest/tenant/{tenantId}/employee/availability/add", (Object[])new Object[]{0}).contentType(MediaType.APPLICATION_JSON).content(body)).andDo(mvcResult -> logger.info(mvcResult.toString())).andExpect(MockMvcResultMatchers.status().isInternalServerError()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.exceptionMessage", (Object[])new Object[0]).value((Object)exceptionMessage)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.exceptionClass", (Object[])new Object[0]).value((Object)exceptionClass));
    }

    @Test
    public void updateEmployeeAvailabilityTest() throws Exception {
        Contract contract = this.createContract(this.TENANT_ID, "contract");
        EmployeeView employeeView = new EmployeeView(this.TENANT_ID, "employee", contract, Collections.emptySet());
        Employee employee = this.employeeService.createEmployee(this.TENANT_ID, employeeView);
        LocalDateTime startDateTime = LocalDateTime.of(1999, 12, 31, 23, 59);
        LocalDateTime endDateTime = LocalDateTime.of(2000, 1, 1, 0, 0);
        EmployeeAvailabilityView employeeAvailabilityView = new EmployeeAvailabilityView(this.TENANT_ID, employee, startDateTime, endDateTime, EmployeeAvailabilityState.UNAVAILABLE);
        EmployeeAvailabilityView persistedEmployeeAvailabilityView = this.employeeService.createEmployeeAvailability(this.TENANT_ID, employeeAvailabilityView);
        EmployeeAvailabilityView updatedEmployeeAvailability = new EmployeeAvailabilityView(this.TENANT_ID, employee, startDateTime, endDateTime, EmployeeAvailabilityState.DESIRED);
        updatedEmployeeAvailability.setId(persistedEmployeeAvailabilityView.getId());
        String body = new ObjectMapper().writeValueAsString((Object)updatedEmployeeAvailability);
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/rest/tenant/{tenantId}/employee/availability/update", (Object[])new Object[]{this.TENANT_ID}).contentType(MediaType.APPLICATION_JSON).content(body).accept(new MediaType[]{MediaType.APPLICATION_JSON})).andDo(mvcResult -> logger.info(mvcResult.toString())).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.tenantId", (Object[])new Object[0]).value((Object)this.TENANT_ID)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.employeeId", (Object[])new Object[0]).value((Object)employee.getId())).andExpect(MockMvcResultMatchers.jsonPath((String)"$.startDateTime", (Object[])new Object[0]).value((Object)"1999-12-31T23:59:00")).andExpect(MockMvcResultMatchers.jsonPath((String)"$.endDateTime", (Object[])new Object[0]).value((Object)"2000-01-01T00:00:00")).andExpect(MockMvcResultMatchers.jsonPath((String)"$.state", (Object[])new Object[0]).value((Object)"DESIRED"));
    }

    @Test
    public void updateNonMatchingEmployeeAvailabilityTest() throws Exception {
        Contract contract = this.createContract(this.TENANT_ID, "contract");
        EmployeeView employeeView = new EmployeeView(this.TENANT_ID, "employee", contract, Collections.emptySet());
        Employee employee = this.employeeService.createEmployee(this.TENANT_ID, employeeView);
        LocalDateTime startDateTime = LocalDateTime.of(1999, 12, 31, 23, 59);
        LocalDateTime endDateTime = LocalDateTime.of(2000, 1, 1, 0, 0);
        EmployeeAvailabilityView employeeAvailabilityView = new EmployeeAvailabilityView(this.TENANT_ID, employee, startDateTime, endDateTime, EmployeeAvailabilityState.UNAVAILABLE);
        EmployeeAvailabilityView persistedEmployeeAvailabilityView = this.employeeService.createEmployeeAvailability(this.TENANT_ID, employeeAvailabilityView);
        EmployeeAvailabilityView updatedEmployeeAvailability = new EmployeeAvailabilityView(this.TENANT_ID, employee, startDateTime, endDateTime, EmployeeAvailabilityState.DESIRED);
        updatedEmployeeAvailability.setId(persistedEmployeeAvailabilityView.getId());
        String body = new ObjectMapper().writeValueAsString((Object)updatedEmployeeAvailability);
        String employeeAvailabilityName = updatedEmployeeAvailability.getEmployeeId() + ":" + startDateTime + "-" + endDateTime;
        String exceptionMessage = "The tenantId (0) does not match the persistable (" + employeeAvailabilityName + ")'s tenantId (" + this.TENANT_ID + ").";
        String exceptionClass = "java.lang.IllegalStateException";
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/rest/tenant/{tenantId}/employee/availability/update", (Object[])new Object[]{0}).contentType(MediaType.APPLICATION_JSON).content(body)).andDo(mvcResult -> logger.info(mvcResult.toString())).andExpect(MockMvcResultMatchers.status().isInternalServerError()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.exceptionMessage", (Object[])new Object[0]).value((Object)exceptionMessage)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.exceptionClass", (Object[])new Object[0]).value((Object)exceptionClass));
    }

    @Test
    public void updateNonExistentEmployeeAvailabilityTest() throws Exception {
        String exceptionMessage = "EmployeeAvailability entity with ID (0) not found.";
        String exceptionClass = "javax.persistence.EntityNotFoundException";
        Contract contract = this.createContract(this.TENANT_ID, "contract");
        EmployeeView employeeView = new EmployeeView(this.TENANT_ID, "employee", contract, Collections.emptySet());
        Employee employee = this.employeeService.createEmployee(this.TENANT_ID, employeeView);
        LocalDateTime startDateTime = LocalDateTime.of(1999, 12, 31, 23, 59);
        LocalDateTime endDateTime = LocalDateTime.of(2000, 1, 1, 0, 0);
        EmployeeAvailabilityView employeeAvailabilityView = new EmployeeAvailabilityView(this.TENANT_ID, employee, startDateTime, endDateTime, EmployeeAvailabilityState.DESIRED);
        employeeAvailabilityView.setId(Long.valueOf(0L));
        String body = new ObjectMapper().writeValueAsString((Object)employeeAvailabilityView);
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/rest/tenant/{tenantId}/employee/availability/update", (Object[])new Object[]{this.TENANT_ID}).contentType(MediaType.APPLICATION_JSON).content(body)).andDo(mvcResult -> logger.info(mvcResult.toString())).andExpect(MockMvcResultMatchers.status().isNotFound()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.exceptionMessage", (Object[])new Object[0]).value((Object)exceptionMessage)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.exceptionClass", (Object[])new Object[0]).value((Object)exceptionClass));
    }
}

