/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.roster;

import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.optaweb.employeerostering.AbstractEntityRequireTenantRestServiceTest;
import org.optaweb.employeerostering.domain.contract.Contract;
import org.optaweb.employeerostering.domain.contract.view.ContractView;
import org.optaweb.employeerostering.domain.employee.Employee;
import org.optaweb.employeerostering.domain.employee.EmployeeAvailabilityState;
import org.optaweb.employeerostering.domain.employee.view.EmployeeAvailabilityView;
import org.optaweb.employeerostering.domain.roster.PublishResult;
import org.optaweb.employeerostering.domain.roster.RosterState;
import org.optaweb.employeerostering.domain.roster.view.AvailabilityRosterView;
import org.optaweb.employeerostering.domain.roster.view.RosterStateView;
import org.optaweb.employeerostering.domain.roster.view.ShiftRosterView;
import org.optaweb.employeerostering.domain.shift.view.ShiftView;
import org.optaweb.employeerostering.domain.spot.Spot;
import org.optaweb.employeerostering.domain.spot.view.SpotView;
import org.optaweb.employeerostering.domain.tenant.Tenant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.jdbc.AutoConfigureTestDatabase;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.web.client.TestRestTemplate;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

@RunWith(value=SpringRunner.class)
@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.DEFINED_PORT)
@AutoConfigureTestDatabase
public class RosterRestControllerTest
extends AbstractEntityRequireTenantRestServiceTest {
    @Autowired
    private TestRestTemplate restTemplate;
    private final String rosterPathURI = "http://localhost:8080/rest/tenant/{tenantId}/roster/";
    private final String spotPathURI = "http://localhost:8080/rest/tenant/{tenantId}/spot/";
    private final String contractPathURI = "http://localhost:8080/rest/tenant/{tenantId}/contract/";
    private final String employeePathURI = "http://localhost:8080/rest/tenant/{tenantId}/employee/";
    private final String shiftPathURI = "http://localhost:8080/rest/tenant/{tenantId}/shift/";
    private final String employeeAvailabilityPathURI = "http://localhost:8080/rest/tenant/{tenantId}/employee/availability/";
    private List<Spot> spotList;
    private List<Employee> employeeList;
    private List<ShiftView> shiftViewList;
    private List<EmployeeAvailabilityView> employeeAvailabilityViewList;

    private ResponseEntity<RosterState> getRosterState(Integer id) {
        return this.restTemplate.getForEntity("http://localhost:8080/rest/tenant/{tenantId}/roster/" + id, RosterState.class, new Object[]{this.TENANT_ID});
    }

    private ResponseEntity<ShiftRosterView> getCurrentShiftRosterView(Integer pageNumber, Integer numberOfItemsPerPage) {
        UriComponents uriComponents = UriComponentsBuilder.fromUriString((String)"http://localhost:8080/rest/tenant/{tenantId}/roster/shiftRosterView/current").queryParam("p", new Object[]{pageNumber}).queryParam("n", new Object[]{numberOfItemsPerPage}).build().expand(Collections.singletonMap("tenantId", this.TENANT_ID));
        return this.restTemplate.getForEntity(uriComponents.toUriString(), ShiftRosterView.class, new Object[0]);
    }

    private ResponseEntity<ShiftRosterView> getShiftRosterView(Integer pageNumber, Integer numberOfItemsPerPage, String startDateString, String endDateString) {
        UriComponents uriComponents = UriComponentsBuilder.fromUriString((String)"http://localhost:8080/rest/tenant/{tenantId}/roster/shiftRosterView").queryParam("p", new Object[]{pageNumber}).queryParam("n", new Object[]{numberOfItemsPerPage}).queryParam("startDate", new Object[]{startDateString}).queryParam("endDate", new Object[]{endDateString}).build().expand(Collections.singletonMap("tenantId", this.TENANT_ID));
        return this.restTemplate.getForEntity(uriComponents.toUriString(), ShiftRosterView.class, new Object[0]);
    }

    private ResponseEntity<ShiftRosterView> getShiftRosterViewFor(String startDateString, String endDateString, List<Spot> spots) {
        UriComponents uriComponents = UriComponentsBuilder.fromUriString((String)"http://localhost:8080/rest/tenant/{tenantId}/roster/shiftRosterView/for").queryParam("startDate", new Object[]{startDateString}).queryParam("endDate", new Object[]{endDateString}).build().expand(Collections.singletonMap("tenantId", this.TENANT_ID));
        return this.restTemplate.postForEntity(uriComponents.toUriString(), spots, ShiftRosterView.class, new Object[0]);
    }

    private ResponseEntity<AvailabilityRosterView> getCurrentAvailabilityRosterView(Integer pageNumber, Integer numberOfItemsPerPage) {
        UriComponents uriComponents = UriComponentsBuilder.fromUriString((String)"http://localhost:8080/rest/tenant/{tenantId}/roster/availabilityRosterView/current").queryParam("p", new Object[]{pageNumber}).queryParam("n", new Object[]{numberOfItemsPerPage}).build().expand(Collections.singletonMap("tenantId", this.TENANT_ID));
        return this.restTemplate.getForEntity(uriComponents.toUriString(), AvailabilityRosterView.class, new Object[0]);
    }

    private ResponseEntity<AvailabilityRosterView> getAvailabilityRosterView(Integer pageNumber, Integer numberOfItemsPerPage, String startDateString, String endDateString) {
        UriComponents uriComponents = UriComponentsBuilder.fromUriString((String)"http://localhost:8080/rest/tenant/{tenantId}/roster/availabilityRosterView").queryParam("p", new Object[]{pageNumber}).queryParam("n", new Object[]{numberOfItemsPerPage}).queryParam("startDate", new Object[]{startDateString}).queryParam("endDate", new Object[]{endDateString}).build().expand(Collections.singletonMap("tenantId", this.TENANT_ID));
        return this.restTemplate.getForEntity(uriComponents.toUriString(), AvailabilityRosterView.class, new Object[0]);
    }

    private ResponseEntity<AvailabilityRosterView> getAvailabilityRosterViewFor(String startDateString, String endDateString, List<Employee> employees) {
        UriComponents uriComponents = UriComponentsBuilder.fromUriString((String)"http://localhost:8080/rest/tenant/{tenantId}/roster/availabilityRosterView/for").queryParam("startDate", new Object[]{startDateString}).queryParam("endDate", new Object[]{endDateString}).build().expand(Collections.singletonMap("tenantId", this.TENANT_ID));
        return this.restTemplate.postForEntity(uriComponents.toUriString(), employees, AvailabilityRosterView.class, new Object[0]);
    }

    private ResponseEntity<PublishResult> publishAndProvision() {
        return this.restTemplate.postForEntity("http://localhost:8080/rest/tenant/{tenantId}/roster/publishAndProvision", null, PublishResult.class, new Object[]{this.TENANT_ID});
    }

    private Spot addSpot(String name) {
        SpotView spotView = new SpotView(this.TENANT_ID, name, Collections.emptySet());
        return (Spot)this.restTemplate.postForEntity("http://localhost:8080/rest/tenant/{tenantId}/spot/add", (Object)spotView, Spot.class, new Object[]{this.TENANT_ID}).getBody();
    }

    private Contract addContract(String name) {
        ContractView contractView = new ContractView(this.TENANT_ID, name);
        return (Contract)this.restTemplate.postForEntity("http://localhost:8080/rest/tenant/{tenantId}/contract/add", (Object)contractView, Contract.class, new Object[]{this.TENANT_ID}).getBody();
    }

    private Employee addEmployee(String name, Contract contract) {
        Employee employee = new Employee(this.TENANT_ID, name, contract, Collections.emptySet());
        return (Employee)this.restTemplate.postForEntity("http://localhost:8080/rest/tenant/{tenantId}/employee/add", (Object)employee, Employee.class, new Object[]{this.TENANT_ID}).getBody();
    }

    private ShiftView addShift(Spot spot, Employee employee, LocalDateTime startDateTime, Duration duration) {
        ShiftView shiftView = new ShiftView(this.TENANT_ID, spot, startDateTime, startDateTime.plus(duration));
        if (employee != null) {
            shiftView.setEmployeeId(employee.getId());
        }
        return (ShiftView)this.restTemplate.postForEntity("http://localhost:8080/rest/tenant/{tenantId}/shift/add", (Object)shiftView, ShiftView.class, new Object[]{this.TENANT_ID}).getBody();
    }

    private EmployeeAvailabilityView addEmployeeAvailability(Employee employee, EmployeeAvailabilityState employeeAvailabilityState, LocalDateTime startDateTime, Duration duration) {
        EmployeeAvailabilityView employeeAvailabilityView = new EmployeeAvailabilityView(this.TENANT_ID, employee, startDateTime, startDateTime.plus(duration), employeeAvailabilityState);
        return (EmployeeAvailabilityView)this.restTemplate.postForEntity("http://localhost:8080/rest/tenant/{tenantId}/employee/availability/add", (Object)employeeAvailabilityView, EmployeeAvailabilityView.class, new Object[]{this.TENANT_ID}).getBody();
    }

    private void createTestRoster() {
        this.createTestTenant();
        Contract contract = this.addContract("contract");
        Employee employeeA = this.addEmployee("Employee A", contract);
        Employee employeeB = this.addEmployee("Employee B", contract);
        Spot spotA = this.addSpot("Spot A");
        Spot spotB = this.addSpot("Spot B");
        EmployeeAvailabilityView employeeAvailabilityA = this.addEmployeeAvailability(employeeA, EmployeeAvailabilityState.UNAVAILABLE, LocalDateTime.of(2000, 1, 1, 0, 0), Duration.ofDays(1L));
        ShiftView shiftA = this.addShift(spotA, null, LocalDateTime.of(2000, 1, 1, 9, 0), Duration.ofHours(8L));
        ShiftView shiftB = this.addShift(spotB, employeeB, LocalDateTime.of(2000, 1, 1, 9, 0), Duration.ofHours(8L));
        ShiftView shiftC = this.addShift(spotA, employeeA, LocalDateTime.of(2000, 1, 2, 9, 0), Duration.ofHours(8L));
        ShiftView shiftD = this.addShift(spotB, employeeB, LocalDateTime.of(2000, 1, 2, 9, 0), Duration.ofHours(8L));
        this.spotList = Arrays.asList(spotA, spotB);
        this.employeeList = Arrays.asList(employeeA, employeeB);
        this.shiftViewList = Arrays.asList(shiftA, shiftB, shiftC, shiftD);
        this.employeeAvailabilityViewList = Arrays.asList(employeeAvailabilityA);
    }

    @After
    public void cleanup() {
        this.deleteTestTenant();
    }

    @Test
    public void getRosterStateTest() {
        RosterStateView rosterStateView = new RosterStateView(null, Integer.valueOf(7), LocalDate.of(2000, 1, 1), Integer.valueOf(7), Integer.valueOf(7), Integer.valueOf(0), Integer.valueOf(7), LocalDate.of(1999, 12, 24), (ZoneId)ZoneOffset.UTC);
        rosterStateView.setTenant(new Tenant("test"));
        Tenant tenant = this.createTestTenant(rosterStateView);
        rosterStateView.setTenant(tenant);
        rosterStateView.setTenantId(tenant.getId());
        ResponseEntity<RosterState> rosterStateResponseEntity = this.getRosterState(this.TENANT_ID);
        Assertions.assertThat((Comparable)rosterStateResponseEntity.getStatusCode()).isEqualTo((Object)HttpStatus.OK);
        Assertions.assertThat((Integer)((RosterState)rosterStateResponseEntity.getBody()).getPublishNotice()).isEqualTo(7);
        Assertions.assertThat((String)((RosterState)rosterStateResponseEntity.getBody()).getFirstDraftDate().toString()).isEqualTo("2000-01-01");
        Assertions.assertThat((Integer)((RosterState)rosterStateResponseEntity.getBody()).getPublishLength()).isEqualTo(7);
        Assertions.assertThat((Integer)((RosterState)rosterStateResponseEntity.getBody()).getDraftLength()).isEqualTo(7);
        Assertions.assertThat((Integer)((RosterState)rosterStateResponseEntity.getBody()).getUnplannedRotationOffset()).isEqualTo(0);
        Assertions.assertThat((Integer)((RosterState)rosterStateResponseEntity.getBody()).getRotationLength()).isEqualTo(7);
        Assertions.assertThat((String)((RosterState)rosterStateResponseEntity.getBody()).getLastHistoricDate().toString()).isEqualTo("1999-12-24");
        Assertions.assertThat((String)((RosterState)rosterStateResponseEntity.getBody()).getTimeZone().toString()).isEqualTo("Z");
        Assertions.assertThat((Integer)((RosterState)rosterStateResponseEntity.getBody()).getTenantId()).isEqualTo((Object)this.TENANT_ID);
        Assertions.assertThat((String)((RosterState)rosterStateResponseEntity.getBody()).getTenant().getName()).isEqualTo("TestTenant");
        Assertions.assertThat((Integer)((RosterState)rosterStateResponseEntity.getBody()).getTenant().getId()).isEqualTo((Object)this.TENANT_ID);
    }

    @Test
    public void testGetCurrentShiftRosterView() {
        this.createTestRoster();
        ResponseEntity<ShiftRosterView> shiftRosterViewResponse = this.getCurrentShiftRosterView(0, 1);
        ShiftRosterView shiftRosterView = (ShiftRosterView)shiftRosterViewResponse.getBody();
        Assertions.assertThat((Comparable)shiftRosterViewResponse.getStatusCode()).isEqualTo((Object)HttpStatus.OK);
        Assertions.assertThat((Object)shiftRosterView).isNotNull();
        Assertions.assertThat((List)shiftRosterView.getEmployeeList()).containsExactlyElementsOf(this.employeeList);
        Assertions.assertThat((List)shiftRosterView.getSpotList()).containsExactlyElementsOf(this.spotList.subList(0, 1));
        Assertions.assertThat((Integer)shiftRosterView.getTenantId()).isEqualTo((Object)this.TENANT_ID);
        shiftRosterViewResponse = this.getCurrentShiftRosterView(1, 1);
        shiftRosterView = (ShiftRosterView)shiftRosterViewResponse.getBody();
        Assertions.assertThat((Comparable)shiftRosterViewResponse.getStatusCode()).isEqualTo((Object)HttpStatus.OK);
        Assertions.assertThat((Object)shiftRosterView).isNotNull();
        Assertions.assertThat((List)shiftRosterView.getEmployeeList()).containsExactlyElementsOf(this.employeeList);
        Assertions.assertThat((List)shiftRosterView.getSpotList()).containsExactlyElementsOf(this.spotList.subList(1, 2));
        Assertions.assertThat((Integer)shiftRosterView.getTenantId()).isEqualTo((Object)this.TENANT_ID);
    }

    @Test
    public void testGetShiftRosterView() {
        this.createTestRoster();
        LocalDate startDate = LocalDate.of(2000, 1, 1);
        LocalDate endDate = LocalDate.of(2000, 1, 2);
        ResponseEntity<ShiftRosterView> shiftRosterViewResponse = this.getShiftRosterView(0, 1, startDate.toString(), endDate.toString());
        ShiftRosterView shiftRosterView = (ShiftRosterView)shiftRosterViewResponse.getBody();
        Assertions.assertThat((Comparable)shiftRosterViewResponse.getStatusCode()).isEqualTo((Object)HttpStatus.OK);
        Assertions.assertThat((Object)shiftRosterView).isNotNull();
        Assertions.assertThat((List)shiftRosterView.getEmployeeList()).containsExactlyElementsOf(this.employeeList);
        Assertions.assertThat((List)shiftRosterView.getSpotList()).containsExactlyElementsOf(this.spotList.subList(0, 1));
        Assertions.assertThat((LocalDate)shiftRosterView.getStartDate()).isEqualTo((Object)startDate);
        Assertions.assertThat((LocalDate)shiftRosterView.getEndDate()).isEqualTo((Object)endDate);
        Assertions.assertThat((Map)shiftRosterView.getSpotIdToShiftViewListMap()).containsOnly(new Map.Entry[]{Assertions.entry((Object)this.spotList.get(0).getId(), Arrays.asList(this.shiftViewList.get(0)))});
        Assertions.assertThat((Integer)shiftRosterView.getTenantId()).isEqualTo((Object)this.TENANT_ID);
        shiftRosterViewResponse = this.getShiftRosterView(1, 1, startDate.toString(), endDate.toString());
        shiftRosterView = (ShiftRosterView)shiftRosterViewResponse.getBody();
        Assertions.assertThat((Comparable)shiftRosterViewResponse.getStatusCode()).isEqualTo((Object)HttpStatus.OK);
        Assertions.assertThat((Object)shiftRosterView).isNotNull();
        Assertions.assertThat((List)shiftRosterView.getEmployeeList()).containsExactlyElementsOf(this.employeeList);
        Assertions.assertThat((List)shiftRosterView.getSpotList()).containsExactlyElementsOf(this.spotList.subList(1, 2));
        Assertions.assertThat((LocalDate)shiftRosterView.getStartDate()).isEqualTo((Object)startDate);
        Assertions.assertThat((LocalDate)shiftRosterView.getEndDate()).isEqualTo((Object)endDate);
        Assertions.assertThat((Map)shiftRosterView.getSpotIdToShiftViewListMap()).containsOnly(new Map.Entry[]{Assertions.entry((Object)this.spotList.get(1).getId(), Arrays.asList(this.shiftViewList.get(1)))});
        Assertions.assertThat((Integer)shiftRosterView.getTenantId()).isEqualTo((Object)this.TENANT_ID);
    }

    @Test
    public void testGetShiftRosterViewFor() {
        this.createTestRoster();
        LocalDate startDate = LocalDate.of(2000, 1, 1);
        LocalDate endDate = LocalDate.of(2000, 1, 2);
        ResponseEntity<ShiftRosterView> shiftRosterViewResponse = this.getShiftRosterViewFor(startDate.toString(), endDate.toString(), Collections.emptyList());
        ShiftRosterView shiftRosterView = (ShiftRosterView)shiftRosterViewResponse.getBody();
        Assertions.assertThat((Comparable)shiftRosterViewResponse.getStatusCode()).isEqualTo((Object)HttpStatus.OK);
        Assertions.assertThat((Object)shiftRosterView).isNotNull();
        Assertions.assertThat((List)shiftRosterView.getEmployeeList()).containsExactlyElementsOf(this.employeeList);
        Assertions.assertThat((List)shiftRosterView.getSpotList()).isEmpty();
        Assertions.assertThat((LocalDate)shiftRosterView.getStartDate()).isEqualTo((Object)startDate);
        Assertions.assertThat((LocalDate)shiftRosterView.getEndDate()).isEqualTo((Object)endDate);
        Assertions.assertThat((Integer)shiftRosterView.getTenantId()).isEqualTo((Object)this.TENANT_ID);
        shiftRosterViewResponse = this.getShiftRosterViewFor(startDate.toString(), endDate.toString(), Collections.emptyList());
        shiftRosterView = (ShiftRosterView)shiftRosterViewResponse.getBody();
        Assertions.assertThat((Comparable)shiftRosterViewResponse.getStatusCode()).isEqualTo((Object)HttpStatus.OK);
        Assertions.assertThat((Object)shiftRosterView).isNotNull();
        Assertions.assertThat((List)shiftRosterView.getEmployeeList()).containsExactlyElementsOf(this.employeeList);
        Assertions.assertThat((List)shiftRosterView.getSpotList()).isEmpty();
        Assertions.assertThat((LocalDate)shiftRosterView.getStartDate()).isEqualTo((Object)startDate);
        Assertions.assertThat((LocalDate)shiftRosterView.getEndDate()).isEqualTo((Object)endDate);
        Assertions.assertThat((Integer)shiftRosterView.getTenantId()).isEqualTo((Object)this.TENANT_ID);
    }

    @Test
    public void testCurrentGetAvailabilityRosterView() {
        this.createTestRoster();
        LocalDate startDate = LocalDate.of(1999, 12, 24);
        LocalDate endDate = LocalDate.of(2000, 1, 25);
        ResponseEntity<AvailabilityRosterView> availabilityRosterViewResponse = this.getCurrentAvailabilityRosterView(0, 1);
        AvailabilityRosterView availabilityRosterView = (AvailabilityRosterView)availabilityRosterViewResponse.getBody();
        Assertions.assertThat((Comparable)availabilityRosterViewResponse.getStatusCode()).isEqualTo((Object)HttpStatus.OK);
        Assertions.assertThat((Object)availabilityRosterView).isNotNull();
        Assertions.assertThat((List)availabilityRosterView.getEmployeeList()).containsExactlyElementsOf(this.employeeList.subList(0, 1));
        Assertions.assertThat((List)availabilityRosterView.getSpotList()).containsExactlyElementsOf(this.spotList);
        Assertions.assertThat((LocalDate)availabilityRosterView.getStartDate()).isEqualTo((Object)startDate);
        Assertions.assertThat((LocalDate)availabilityRosterView.getEndDate()).isEqualTo((Object)endDate);
        Assertions.assertThat((Map)availabilityRosterView.getEmployeeIdToAvailabilityViewListMap()).containsOnly(new Map.Entry[]{Assertions.entry((Object)this.employeeList.get(0).getId(), Arrays.asList(this.employeeAvailabilityViewList.get(0)))});
        Assertions.assertThat((Integer)availabilityRosterView.getTenantId()).isEqualTo((Object)this.TENANT_ID);
        availabilityRosterViewResponse = this.getCurrentAvailabilityRosterView(1, 1);
        availabilityRosterView = (AvailabilityRosterView)availabilityRosterViewResponse.getBody();
        Assertions.assertThat((Comparable)availabilityRosterViewResponse.getStatusCode()).isEqualTo((Object)HttpStatus.OK);
        Assertions.assertThat((Object)availabilityRosterView).isNotNull();
        Assertions.assertThat((List)availabilityRosterView.getEmployeeList()).containsExactlyElementsOf(this.employeeList.subList(1, 2));
        Assertions.assertThat((List)availabilityRosterView.getSpotList()).containsExactlyElementsOf(this.spotList);
        Assertions.assertThat((LocalDate)availabilityRosterView.getStartDate()).isEqualTo((Object)startDate);
        Assertions.assertThat((LocalDate)availabilityRosterView.getEndDate()).isEqualTo((Object)endDate);
        Assertions.assertThat((Map)availabilityRosterView.getEmployeeIdToAvailabilityViewListMap()).isEmpty();
        Assertions.assertThat((Integer)availabilityRosterView.getTenantId()).isEqualTo((Object)this.TENANT_ID);
    }

    @Test
    public void testGetAvailabilityRosterView() {
        this.createTestRoster();
        LocalDate startDate = LocalDate.of(2000, 1, 1);
        LocalDate endDate = LocalDate.of(2000, 1, 2);
        ResponseEntity<AvailabilityRosterView> availabilityRosterViewResponse = this.getAvailabilityRosterView(0, 1, startDate.toString(), endDate.toString());
        AvailabilityRosterView availabilityRosterView = (AvailabilityRosterView)availabilityRosterViewResponse.getBody();
        Assertions.assertThat((Comparable)availabilityRosterViewResponse.getStatusCode()).isEqualTo((Object)HttpStatus.OK);
        Assertions.assertThat((Object)availabilityRosterView).isNotNull();
        Assertions.assertThat((List)availabilityRosterView.getEmployeeList()).containsExactlyElementsOf(this.employeeList.subList(0, 1));
        Assertions.assertThat((List)availabilityRosterView.getSpotList()).containsExactlyElementsOf(this.spotList);
        Assertions.assertThat((LocalDate)availabilityRosterView.getStartDate()).isEqualTo((Object)startDate);
        Assertions.assertThat((LocalDate)availabilityRosterView.getEndDate()).isEqualTo((Object)endDate);
        Assertions.assertThat((Map)availabilityRosterView.getEmployeeIdToAvailabilityViewListMap()).containsOnly(new Map.Entry[]{Assertions.entry((Object)this.employeeList.get(0).getId(), Arrays.asList(this.employeeAvailabilityViewList.get(0)))});
        Assertions.assertThat((Map)availabilityRosterView.getEmployeeIdToShiftViewListMap()).isEmpty();
        Assertions.assertThat((Integer)availabilityRosterView.getTenantId()).isEqualTo((Object)this.TENANT_ID);
        availabilityRosterViewResponse = this.getAvailabilityRosterView(1, 1, startDate.toString(), endDate.toString());
        availabilityRosterView = (AvailabilityRosterView)availabilityRosterViewResponse.getBody();
        Assertions.assertThat((Comparable)availabilityRosterViewResponse.getStatusCode()).isEqualTo((Object)HttpStatus.OK);
        Assertions.assertThat((Object)availabilityRosterView).isNotNull();
        Assertions.assertThat((List)availabilityRosterView.getEmployeeList()).containsExactlyElementsOf(this.employeeList.subList(1, 2));
        Assertions.assertThat((List)availabilityRosterView.getSpotList()).containsExactlyElementsOf(this.spotList);
        Assertions.assertThat((LocalDate)availabilityRosterView.getStartDate()).isEqualTo((Object)startDate);
        Assertions.assertThat((LocalDate)availabilityRosterView.getEndDate()).isEqualTo((Object)endDate);
        Assertions.assertThat((Map)availabilityRosterView.getEmployeeIdToAvailabilityViewListMap()).isEmpty();
        Assertions.assertThat((Map)availabilityRosterView.getEmployeeIdToShiftViewListMap()).containsOnly(new Map.Entry[]{Assertions.entry((Object)this.employeeList.get(1).getId(), Arrays.asList(this.shiftViewList.get(1)))});
        Assertions.assertThat((Integer)availabilityRosterView.getTenantId()).isEqualTo((Object)this.TENANT_ID);
    }

    @Test
    public void testGetAvailabilityRosterViewFor() {
        this.createTestRoster();
        LocalDate startDate = LocalDate.of(2000, 1, 1);
        LocalDate endDate = LocalDate.of(2000, 1, 2);
        ResponseEntity<AvailabilityRosterView> availabilityRosterViewResponse = this.getAvailabilityRosterViewFor(startDate.toString(), endDate.toString(), Collections.emptyList());
        AvailabilityRosterView availabilityRosterView = (AvailabilityRosterView)availabilityRosterViewResponse.getBody();
        Assertions.assertThat((Comparable)availabilityRosterViewResponse.getStatusCode()).isEqualTo((Object)HttpStatus.OK);
        Assertions.assertThat((Object)availabilityRosterView).isNotNull();
        Assertions.assertThat((List)availabilityRosterView.getEmployeeList()).isEmpty();
        Assertions.assertThat((List)availabilityRosterView.getSpotList()).containsExactlyElementsOf(this.spotList);
        Assertions.assertThat((LocalDate)availabilityRosterView.getStartDate()).isEqualTo((Object)startDate);
        Assertions.assertThat((LocalDate)availabilityRosterView.getEndDate()).isEqualTo((Object)endDate);
        Assertions.assertThat((Map)availabilityRosterView.getEmployeeIdToShiftViewListMap()).isEmpty();
        Assertions.assertThat((Integer)availabilityRosterView.getTenantId()).isEqualTo((Object)this.TENANT_ID);
        availabilityRosterViewResponse = this.getAvailabilityRosterViewFor(startDate.toString(), endDate.toString(), Collections.emptyList());
        availabilityRosterView = (AvailabilityRosterView)availabilityRosterViewResponse.getBody();
        Assertions.assertThat((Comparable)availabilityRosterViewResponse.getStatusCode()).isEqualTo((Object)HttpStatus.OK);
        Assertions.assertThat((Object)availabilityRosterView).isNotNull();
        Assertions.assertThat((List)availabilityRosterView.getEmployeeList()).isEmpty();
        Assertions.assertThat((List)availabilityRosterView.getSpotList()).containsExactlyElementsOf(this.spotList);
        Assertions.assertThat((LocalDate)availabilityRosterView.getStartDate()).isEqualTo((Object)startDate);
        Assertions.assertThat((LocalDate)availabilityRosterView.getEndDate()).isEqualTo((Object)endDate);
        Assertions.assertThat((Map)availabilityRosterView.getEmployeeIdToAvailabilityViewListMap()).isEmpty();
        Assertions.assertThat((Integer)availabilityRosterView.getTenantId()).isEqualTo((Object)this.TENANT_ID);
    }

    @Test
    public void testPublishAndProvision() {
        this.createTestRoster();
        ResponseEntity<PublishResult> publishResultResponseEntity = this.publishAndProvision();
        Assertions.assertThat((Comparable)publishResultResponseEntity.getStatusCode()).isEqualTo((Object)HttpStatus.OK);
        Assertions.assertThat((LocalDate)((PublishResult)publishResultResponseEntity.getBody()).getPublishedFromDate()).isEqualTo("2000-01-01");
        Assertions.assertThat((LocalDate)((PublishResult)publishResultResponseEntity.getBody()).getPublishedToDate()).isEqualTo("2000-01-08");
    }
}

