/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.shift;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.LocalDateTime;
import java.util.Collections;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.optaweb.employeerostering.AbstractEntityRequireTenantRestServiceTest;
import org.optaweb.employeerostering.domain.contract.Contract;
import org.optaweb.employeerostering.domain.contract.view.ContractView;
import org.optaweb.employeerostering.domain.employee.Employee;
import org.optaweb.employeerostering.domain.employee.view.EmployeeView;
import org.optaweb.employeerostering.domain.shift.view.ShiftView;
import org.optaweb.employeerostering.domain.spot.Spot;
import org.optaweb.employeerostering.domain.spot.view.SpotView;
import org.optaweb.employeerostering.service.contract.ContractService;
import org.optaweb.employeerostering.service.employee.EmployeeService;
import org.optaweb.employeerostering.service.shift.ShiftService;
import org.optaweb.employeerostering.service.spot.SpotService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.jdbc.AutoConfigureTestDatabase;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureMockMvc;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.http.MediaType;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=SpringRunner.class)
@SpringBootTest
@AutoConfigureTestDatabase
@AutoConfigureMockMvc
@Transactional
public class ShiftServiceTest
extends AbstractEntityRequireTenantRestServiceTest {
    private static final Logger logger = LoggerFactory.getLogger(ShiftServiceTest.class);
    @Autowired
    private MockMvc mvc;
    @Autowired
    private ShiftService shiftService;
    @Autowired
    private SpotService spotService;
    @Autowired
    private ContractService contractService;
    @Autowired
    private EmployeeService employeeService;

    private Spot createSpot(Integer tenantId, String name) {
        SpotView spotView = new SpotView(tenantId, name, Collections.emptySet());
        return this.spotService.createSpot(tenantId, spotView);
    }

    private Contract createContract(Integer tenantId, String name) {
        ContractView contractView = new ContractView(tenantId, name);
        return this.contractService.createContract(tenantId, contractView);
    }

    private Employee createEmployee(Integer tenantId, String name, Contract contract) {
        EmployeeView employeeView = new EmployeeView(tenantId, name, contract, Collections.emptySet());
        return this.employeeService.createEmployee(tenantId, employeeView);
    }

    @Before
    public void setup() {
        this.createTestTenant();
    }

    @After
    public void cleanup() {
        this.deleteTestTenant();
    }

    @Test
    public void getShiftListTest() throws Exception {
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/rest/tenant/{tenantId}/shift/", (Object[])new Object[]{this.TENANT_ID}).accept(new MediaType[]{MediaType.APPLICATION_JSON})).andDo(mvcResult -> logger.info(mvcResult.toString())).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void getShiftTest() throws Exception {
        Spot spot = this.createSpot(this.TENANT_ID, "spot");
        Contract contract = this.createContract(this.TENANT_ID, "contract");
        Employee rotationEmployee = this.createEmployee(this.TENANT_ID, "rotationEmployee", contract);
        LocalDateTime startDateTime = LocalDateTime.of(2000, 1, 1, 0, 0, 0, 0);
        LocalDateTime endDateTime = startDateTime.plusHours(8L);
        ShiftView shiftView = new ShiftView(this.TENANT_ID, spot, startDateTime, endDateTime, rotationEmployee);
        ShiftView persistedShift = this.shiftService.createShift(this.TENANT_ID, shiftView);
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/rest/tenant/{tenantId}/shift/{id}", (Object[])new Object[]{this.TENANT_ID, persistedShift.getId()}).accept(new MediaType[]{MediaType.APPLICATION_JSON})).andDo(mvcResult -> logger.info(mvcResult.toString())).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.rotationEmployeeId", (Object[])new Object[0]).value((Object)persistedShift.getRotationEmployeeId())).andExpect(MockMvcResultMatchers.jsonPath((String)"$.spotId", (Object[])new Object[0]).value((Object)persistedShift.getSpotId())).andExpect(MockMvcResultMatchers.jsonPath((String)"$.startDateTime", (Object[])new Object[0]).value((Object)"2000-01-01T00:00:00")).andExpect(MockMvcResultMatchers.jsonPath((String)"$.endDateTime", (Object[])new Object[0]).value((Object)"2000-01-01T08:00:00"));
    }

    @Test
    public void getNonExistentShiftTest() throws Exception {
        String exceptionMessage = "No Shift entity found with ID (0).";
        String exceptionClass = "javax.persistence.EntityNotFoundException";
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/rest/tenant/{tenantId}/shift/{id}", (Object[])new Object[]{this.TENANT_ID, 0}).accept(new MediaType[]{MediaType.APPLICATION_JSON})).andDo(mvcResult -> logger.info(mvcResult.toString())).andExpect(MockMvcResultMatchers.status().isNotFound()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.exceptionMessage", (Object[])new Object[0]).value((Object)exceptionMessage)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.exceptionClass", (Object[])new Object[0]).value((Object)exceptionClass));
    }

    @Test
    public void deleteShiftTest() throws Exception {
        Spot spot = this.createSpot(this.TENANT_ID, "spot");
        Contract contract = this.createContract(this.TENANT_ID, "contract");
        Employee rotationEmployee = this.createEmployee(this.TENANT_ID, "rotationEmployee", contract);
        LocalDateTime startDateTime = LocalDateTime.of(2000, 1, 1, 0, 0, 0, 0);
        LocalDateTime endDateTime = startDateTime.plusHours(8L);
        ShiftView shiftView = new ShiftView(this.TENANT_ID, spot, startDateTime, endDateTime, rotationEmployee);
        ShiftView persistedShift = this.shiftService.createShift(this.TENANT_ID, shiftView);
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/rest/tenant/{tenantId}/shift/{id}", (Object[])new Object[]{this.TENANT_ID, persistedShift.getId()}).accept(new MediaType[]{MediaType.APPLICATION_JSON})).andDo(mvcResult -> logger.info(mvcResult.toString())).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType("application/json")).andExpect(MockMvcResultMatchers.content().string("true"));
    }

    @Test
    public void deleteNonExistentShiftTest() throws Exception {
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/rest/tenant/{tenantId}/shift/{id}", (Object[])new Object[]{this.TENANT_ID, 0}).accept(new MediaType[]{MediaType.APPLICATION_JSON})).andDo(mvcResult -> logger.info(mvcResult.toString())).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType("application/json")).andExpect(MockMvcResultMatchers.content().string("false"));
    }

    @Test
    public void createShiftTest() throws Exception {
        Spot spot = this.createSpot(this.TENANT_ID, "spot");
        Contract contract = this.createContract(this.TENANT_ID, "contract");
        Employee rotationEmployee = this.createEmployee(this.TENANT_ID, "rotationEmployee", contract);
        LocalDateTime startDateTime = LocalDateTime.of(2000, 1, 1, 0, 0, 0, 0);
        LocalDateTime endDateTime = startDateTime.plusHours(8L);
        ShiftView shiftView = new ShiftView(this.TENANT_ID, spot, startDateTime, endDateTime, rotationEmployee);
        String body = new ObjectMapper().writeValueAsString((Object)shiftView);
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/rest/tenant/{tenantId}/shift/add", (Object[])new Object[]{this.TENANT_ID}).contentType(MediaType.APPLICATION_JSON).content(body).accept(new MediaType[]{MediaType.APPLICATION_JSON})).andDo(mvcResult -> logger.info(mvcResult.toString())).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.rotationEmployeeId", (Object[])new Object[0]).value((Object)shiftView.getRotationEmployeeId())).andExpect(MockMvcResultMatchers.jsonPath((String)"$.spotId", (Object[])new Object[0]).value((Object)shiftView.getSpotId())).andExpect(MockMvcResultMatchers.jsonPath((String)"$.startDateTime", (Object[])new Object[0]).value((Object)"2000-01-01T00:00:00")).andExpect(MockMvcResultMatchers.jsonPath((String)"$.endDateTime", (Object[])new Object[0]).value((Object)"2000-01-01T08:00:00"));
    }

    @Test
    public void updateShiftTest() throws Exception {
        Spot spot = this.createSpot(this.TENANT_ID, "spot");
        Contract contract = this.createContract(this.TENANT_ID, "contract");
        Employee rotationEmployee = this.createEmployee(this.TENANT_ID, "rotationEmployee", contract);
        LocalDateTime startDateTime = LocalDateTime.of(2000, 1, 1, 0, 0, 0, 0);
        LocalDateTime endDateTime = startDateTime.plusHours(8L);
        ShiftView shiftView = new ShiftView(this.TENANT_ID, spot, startDateTime, endDateTime, rotationEmployee);
        ShiftView persistedShift = this.shiftService.createShift(this.TENANT_ID, shiftView);
        startDateTime = LocalDateTime.of(1999, 12, 31, 23, 59, 59, 0);
        endDateTime = startDateTime.plusHours(10L);
        ShiftView updatedShift = new ShiftView(this.TENANT_ID, spot, startDateTime, endDateTime, rotationEmployee);
        updatedShift.setId(persistedShift.getId());
        String body = new ObjectMapper().writeValueAsString((Object)updatedShift);
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/rest/tenant/{tenantId}/shift/update", (Object[])new Object[]{this.TENANT_ID}).contentType(MediaType.APPLICATION_JSON).content(body).accept(new MediaType[]{MediaType.APPLICATION_JSON})).andDo(mvcResult -> logger.info(mvcResult.toString())).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.startDateTime", (Object[])new Object[0]).value((Object)"1999-12-31T23:59:59")).andExpect(MockMvcResultMatchers.jsonPath((String)"$.endDateTime", (Object[])new Object[0]).value((Object)"2000-01-01T09:59:59"));
    }

    @Test
    public void updateNonExistentShiftTest() throws Exception {
        String exceptionMessage = "Shift entity with ID (0) not found.";
        String exceptionClass = "javax.persistence.EntityNotFoundException";
        Spot spot = this.createSpot(this.TENANT_ID, "spot");
        LocalDateTime startDateTime = LocalDateTime.of(1999, 12, 31, 23, 59, 59, 0);
        LocalDateTime endDateTime = startDateTime.plusHours(10L);
        ShiftView updatedShift = new ShiftView(this.TENANT_ID, spot, startDateTime, endDateTime);
        updatedShift.setId(Long.valueOf(0L));
        String body = new ObjectMapper().writeValueAsString((Object)updatedShift);
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/rest/tenant/{tenantId}/shift/update", (Object[])new Object[]{this.TENANT_ID}).contentType(MediaType.APPLICATION_JSON).content(body)).andDo(mvcResult -> logger.info(mvcResult.toString())).andExpect(MockMvcResultMatchers.status().isNotFound()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.exceptionMessage", (Object[])new Object[0]).value((Object)exceptionMessage)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.exceptionClass", (Object[])new Object[0]).value((Object)exceptionClass));
    }
}

