/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.solver;

import java.time.DayOfWeek;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.persistence.EntityManager;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.optaplanner.core.api.score.buildin.hardmediumsoft.HardMediumSoftScore;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.core.config.solver.termination.TerminationConfig;
import org.optaplanner.test.impl.score.buildin.hardmediumsoftlong.HardMediumSoftLongScoreVerifier;
import org.optaweb.employeerostering.domain.common.AbstractPersistable;
import org.optaweb.employeerostering.domain.contract.Contract;
import org.optaweb.employeerostering.domain.employee.Employee;
import org.optaweb.employeerostering.domain.employee.EmployeeAvailability;
import org.optaweb.employeerostering.domain.employee.EmployeeAvailabilityState;
import org.optaweb.employeerostering.domain.roster.Roster;
import org.optaweb.employeerostering.domain.roster.RosterState;
import org.optaweb.employeerostering.domain.shift.Shift;
import org.optaweb.employeerostering.domain.skill.Skill;
import org.optaweb.employeerostering.domain.spot.Spot;
import org.optaweb.employeerostering.domain.tenant.RosterParametrization;
import org.optaweb.employeerostering.domain.tenant.Tenant;
import org.optaweb.employeerostering.service.roster.RosterGenerator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.jdbc.AutoConfigureTestDatabase;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.web.client.TestRestTemplate;
import org.springframework.http.ResponseEntity;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(value=SpringRunner.class)
@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.DEFINED_PORT)
@AutoConfigureTestDatabase
public class SolverTest {
    private static final int TENANT_ID = 0;
    private static final LocalDate START_DATE = LocalDate.of(2019, 5, 13);
    private static final RosterParametrization ROSTER_PARAMETRIZATION = new RosterParametrization();
    @Autowired
    private TestRestTemplate restTemplate;
    private final String rosterPathURI = "http://localhost:8080/rest/tenant/{tenantId}/roster/";

    private ResponseEntity<Void> solveForTenant(Integer tenantId) {
        return this.restTemplate.postForEntity("http://localhost:8080/rest/tenant/{tenantId}/roster/solve", null, Void.class, new Object[]{tenantId});
    }

    private ResponseEntity<Void> terminateSolver(Integer tenantId) {
        return this.restTemplate.postForEntity("http://localhost:8080/rest/tenant/{tenantId}/roster/terminate", null, Void.class, new Object[]{tenantId});
    }

    private SolverFactory<Roster> getSolverFactory() {
        SolverFactory solverFactory = SolverFactory.createFromXmlResource((String)"org/optaweb/employeerostering/service/solver/employeeRosteringSolverConfig.xml");
        solverFactory.getSolverConfig().setTerminationConfig(new TerminationConfig().withScoreCalculationCountLimit(Long.valueOf(10000L)));
        return solverFactory;
    }

    private HardMediumSoftLongScoreVerifier<Roster> getScoreVerifier() {
        return new HardMediumSoftLongScoreVerifier(this.getSolverFactory());
    }

    @Test
    public void testTerminateNonExistentSolver() {
        try {
            ResponseEntity<Void> responseEntity = this.terminateSolver(0);
        }
        catch (IllegalStateException e) {
            Assertions.assertThat((String)e.getMessage()).isEqualTo("The roster with tenantId (0) is not being solved currently.");
        }
    }

    @Test(timeout=600000L)
    public void testFeasibleSolution() {
        Solver solver = this.getSolverFactory().buildSolver();
        RosterGenerator rosterGenerator = this.buildRosterGenerator();
        Roster roster = rosterGenerator.generateRoster(10, 7);
        roster = (Roster)solver.solve((Object)roster);
        Assert.assertNotNull((Object)roster.getScore());
        Assert.assertTrue((boolean)roster.getScore().isFeasible());
        Assert.assertFalse((boolean)roster.getShiftList().isEmpty());
        Assert.assertTrue((boolean)roster.getShiftList().stream().anyMatch(s -> s.getEmployee() != null));
    }

    private void testContractConstraint(ContractField contractField) {
        HardMediumSoftLongScoreVerifier<Roster> scoreVerifier = this.getScoreVerifier();
        AtomicLong idGenerator = new AtomicLong(1L);
        Roster roster = new Roster();
        Tenant tenant = new Tenant("Test Tenant");
        tenant.setId(Integer.valueOf(0));
        RosterState rosterState = this.getRosterState(idGenerator);
        RosterParametrization rosterParametrization = this.getRosterParametrization(idGenerator);
        Contract contract = contractField.getContract(idGenerator);
        Employee employeeA = new Employee(Integer.valueOf(0), "Bill", contract, Collections.emptySet());
        employeeA.setId(Long.valueOf(idGenerator.getAndIncrement()));
        Spot spotA = new Spot(Integer.valueOf(0), "Spot", Collections.emptySet());
        spotA.setId(Long.valueOf(idGenerator.getAndIncrement()));
        LocalDate firstDayOfWeek = START_DATE.with(TemporalAdjusters.previousOrSame(DayOfWeek.MONDAY));
        OffsetDateTime firstDateTime = OffsetDateTime.of(firstDayOfWeek, LocalTime.MIDNIGHT, ZoneOffset.UTC);
        ShiftBuilder shiftBuilder = new ShiftBuilder(idGenerator).forSpot(spotA).startingAtDate(firstDateTime).withShiftLength(Duration.ofHours(1L));
        List<Shift> shiftList = contractField.generateShifts(shiftBuilder);
        roster.setTenantId(Integer.valueOf(0));
        roster.setRosterState(rosterState);
        roster.setSpotList(Collections.singletonList(spotA));
        roster.setEmployeeList(Collections.singletonList(employeeA));
        roster.setSkillList(Collections.emptyList());
        roster.setRosterParametrization(rosterParametrization);
        roster.setEmployeeAvailabilityList(Collections.emptyList());
        roster.setShiftList(shiftList);
        shiftList.get(0).setEmployee(employeeA);
        shiftList.get(1).setEmployee(employeeA);
        shiftList.get(3).setEmployee(employeeA);
        shiftList.get(4).setEmployee(employeeA);
        Constraints constraint = contractField.getConstraint();
        constraint.verifyNumOfInstances(scoreVerifier, roster, 0);
        shiftList.get(2).setEmployee(employeeA);
        constraint.verifyNumOfInstances(scoreVerifier, roster, 3);
        shiftList.get(5).setEmployee(employeeA);
        constraint.verifyNumOfInstances(scoreVerifier, roster, 6);
        shiftList.get(1).setEmployee(null);
        constraint.verifyNumOfInstances(scoreVerifier, roster, 3);
    }

    @Test(timeout=600000L)
    public void testContractConstraints() {
        for (ContractField field : ContractField.values()) {
            this.testContractConstraint(field);
        }
    }

    @Test(timeout=600000L)
    public void testRequiredSkillForShiftConstraint() {
        HardMediumSoftLongScoreVerifier<Roster> scoreVerifier = this.getScoreVerifier();
        AtomicLong idGenerator = new AtomicLong(1L);
        Roster roster = new Roster();
        Tenant tenant = new Tenant("Test Tenant");
        tenant.setId(Integer.valueOf(0));
        RosterState rosterState = this.getRosterState(idGenerator);
        RosterParametrization rosterParametrization = this.getRosterParametrization(idGenerator);
        Skill skillA = new Skill(Integer.valueOf(0), "Skill A");
        Skill skillB = new Skill(Integer.valueOf(0), "Skill B");
        skillA.setId(Long.valueOf(idGenerator.getAndIncrement()));
        skillB.setId(Long.valueOf(idGenerator.getAndIncrement()));
        Spot spotA = new Spot(Integer.valueOf(0), "Spot A", new HashSet<Skill>(Arrays.asList(skillA, skillB)));
        spotA.setId(Long.valueOf(idGenerator.getAndIncrement()));
        Contract contract = this.getDefaultContract(idGenerator);
        Employee employeeA = new Employee(Integer.valueOf(0), "Bill", contract, Collections.emptySet());
        employeeA.setId(Long.valueOf(idGenerator.getAndIncrement()));
        OffsetDateTime firstDateTime = OffsetDateTime.of(START_DATE, LocalTime.MIDNIGHT, ZoneOffset.UTC);
        Shift shift = new Shift(Integer.valueOf(0), spotA, firstDateTime, firstDateTime.plusHours(9L));
        shift.setId(Long.valueOf(idGenerator.getAndIncrement()));
        shift.setEmployee(employeeA);
        roster.setTenantId(Integer.valueOf(0));
        roster.setRosterState(rosterState);
        roster.setSpotList(Collections.singletonList(spotA));
        roster.setEmployeeList(Collections.singletonList(employeeA));
        roster.setSkillList(Arrays.asList(skillA, skillB));
        roster.setRosterParametrization(rosterParametrization);
        roster.setEmployeeAvailabilityList(Collections.emptyList());
        roster.setShiftList(Collections.singletonList(shift));
        Constraints constraint = Constraints.REQUIRED_SKILL_FOR_A_SHIFT;
        constraint.verifyNumOfInstances(scoreVerifier, roster, 1);
        employeeA.setSkillProficiencySet(new HashSet<Skill>(Collections.singleton(skillA)));
        constraint.verifyNumOfInstances(scoreVerifier, roster, 1);
        employeeA.setSkillProficiencySet(new HashSet<Skill>(Collections.singleton(skillB)));
        constraint.verifyNumOfInstances(scoreVerifier, roster, 1);
        employeeA.setSkillProficiencySet(new HashSet<Skill>(Arrays.asList(skillA, skillB)));
        constraint.verifyNumOfInstances(scoreVerifier, roster, 0);
    }

    private void testAvailabilityConstraint(EmployeeAvailabilityState availabilityState) {
        Constraints constraint;
        HardMediumSoftLongScoreVerifier<Roster> scoreVerifier = this.getScoreVerifier();
        AtomicLong idGenerator = new AtomicLong(1L);
        Roster roster = new Roster();
        Tenant tenant = new Tenant("Test Tenant");
        tenant.setId(Integer.valueOf(0));
        RosterState rosterState = this.getRosterState(idGenerator);
        RosterParametrization rosterParametrization = this.getRosterParametrization(idGenerator);
        Contract contract = this.getDefaultContract(idGenerator);
        Employee employeeA = new Employee(Integer.valueOf(0), "Bill", contract, Collections.emptySet());
        employeeA.setId(Long.valueOf(idGenerator.getAndIncrement()));
        Spot spotA = new Spot(Integer.valueOf(0), "Spot", Collections.emptySet());
        spotA.setId(Long.valueOf(idGenerator.getAndIncrement()));
        OffsetDateTime firstDateTime = OffsetDateTime.of(START_DATE, LocalTime.MIDNIGHT, ZoneOffset.UTC);
        Shift shift = new Shift(Integer.valueOf(0), spotA, firstDateTime, firstDateTime.plusHours(9L));
        shift.setId(Long.valueOf(idGenerator.getAndIncrement()));
        shift.setEmployee(employeeA);
        EmployeeAvailability availability = new EmployeeAvailability(Integer.valueOf(0), employeeA, firstDateTime, firstDateTime.plusHours(9L));
        availability.setId(Long.valueOf(idGenerator.getAndIncrement()));
        availability.setState(availabilityState);
        roster.setTenantId(Integer.valueOf(0));
        roster.setRosterState(rosterState);
        roster.setSpotList(Collections.singletonList(spotA));
        roster.setEmployeeList(Collections.singletonList(employeeA));
        roster.setSkillList(Collections.emptyList());
        roster.setRosterParametrization(rosterParametrization);
        roster.setEmployeeAvailabilityList(Collections.singletonList(availability));
        roster.setShiftList(Collections.singletonList(shift));
        switch (availabilityState) {
            case DESIRED: {
                constraint = Constraints.DESIRED_TIME_SLOT_FOR_AN_EMPLOYEE;
                break;
            }
            case UNDESIRED: {
                constraint = Constraints.UNDESIRED_TIME_SLOT_FOR_AN_EMPLOYEE;
                break;
            }
            case UNAVAILABLE: {
                constraint = Constraints.UNAVAILABLE_TIME_SLOT_FOR_AN_EMPLOYEE;
                break;
            }
            default: {
                throw new IllegalArgumentException("No case for (" + availabilityState + ")");
            }
        }
        constraint.verifyNumOfInstances(scoreVerifier, roster, 1);
        shift.setStartDateTime(firstDateTime.minusHours(3L));
        shift.setEndDateTime(firstDateTime.plusHours(6L));
        constraint.verifyNumOfInstances(scoreVerifier, roster, 1);
        shift.setStartDateTime(firstDateTime.plusHours(3L));
        shift.setEndDateTime(firstDateTime.plusHours(12L));
        constraint.verifyNumOfInstances(scoreVerifier, roster, 1);
        shift.setStartDateTime(firstDateTime.plusHours(12L));
        shift.setEndDateTime(firstDateTime.plusHours(21L));
        constraint.verifyNumOfInstances(scoreVerifier, roster, 0);
    }

    @Test(timeout=600000L)
    public void testEmployeeAvilabilityConstraints() {
        for (EmployeeAvailabilityState state : EmployeeAvailabilityState.values()) {
            this.testAvailabilityConstraint(state);
        }
    }

    @Test(timeout=600000L)
    public void testAtMostOneShiftAssignmentPerDayPerEmployee() {
        HardMediumSoftLongScoreVerifier<Roster> scoreVerifier = this.getScoreVerifier();
        AtomicLong idGenerator = new AtomicLong(1L);
        Roster roster = new Roster();
        Tenant tenant = new Tenant("Test Tenant");
        tenant.setId(Integer.valueOf(0));
        RosterState rosterState = this.getRosterState(idGenerator);
        RosterParametrization rosterParametrization = this.getRosterParametrization(idGenerator);
        Contract contract = this.getDefaultContract(idGenerator);
        Employee employeeA = new Employee(Integer.valueOf(0), "Bill", contract, Collections.emptySet());
        employeeA.setId(Long.valueOf(idGenerator.getAndIncrement()));
        Spot spotA = new Spot(Integer.valueOf(0), "Spot", Collections.emptySet());
        spotA.setId(Long.valueOf(idGenerator.getAndIncrement()));
        OffsetDateTime firstDateTime = OffsetDateTime.of(START_DATE, LocalTime.MIDNIGHT, ZoneOffset.UTC);
        ShiftBuilder shiftBuilder = new ShiftBuilder(idGenerator).forSpot(spotA).startingAtDate(firstDateTime).withShiftLength(Duration.ofHours(1L)).withTimeBetweenShifts(Duration.ofHours(1L));
        List<Shift> shiftList = shiftBuilder.generateShifts(2);
        shiftList.forEach(s -> s.setEmployee(employeeA));
        roster.setTenantId(Integer.valueOf(0));
        roster.setRosterState(rosterState);
        roster.setSpotList(Collections.singletonList(spotA));
        roster.setEmployeeList(Collections.singletonList(employeeA));
        roster.setSkillList(Collections.emptyList());
        roster.setRosterParametrization(rosterParametrization);
        roster.setEmployeeAvailabilityList(Collections.emptyList());
        roster.setShiftList(shiftList);
        Constraints constraint = Constraints.AT_MOST_ONE_SHIFT_ASSIGNMENT_PER_DAY_PER_EMPLOYEE;
        constraint.verifyNumOfInstances(scoreVerifier, roster, 2);
        shiftBuilder.withTimeBetweenShifts(Duration.ofDays(1L));
        shiftList = shiftBuilder.generateShifts(2);
        shiftList.forEach(s -> s.setEmployee(employeeA));
        roster.setShiftList(shiftList);
        constraint.verifyNumOfInstances(scoreVerifier, roster, 0);
        shiftBuilder.withTimeBetweenShifts(Duration.ofHours(-1L));
        shiftList = shiftBuilder.generateShifts(2);
        shiftList.forEach(s -> s.setEmployee(employeeA));
        roster.setShiftList(shiftList);
        constraint.verifyNumOfInstances(scoreVerifier, roster, 0);
    }

    @Test(timeout=600000L)
    public void testNoTwoShiftsWithin10HoursOfEachOther() {
        HardMediumSoftLongScoreVerifier<Roster> scoreVerifier = this.getScoreVerifier();
        AtomicLong idGenerator = new AtomicLong(1L);
        Roster roster = new Roster();
        Tenant tenant = new Tenant("Test Tenant");
        tenant.setId(Integer.valueOf(0));
        RosterState rosterState = this.getRosterState(idGenerator);
        RosterParametrization rosterParametrization = this.getRosterParametrization(idGenerator);
        Contract contract = this.getDefaultContract(idGenerator);
        Employee employeeA = new Employee(Integer.valueOf(0), "Bill", contract, Collections.emptySet());
        employeeA.setId(Long.valueOf(idGenerator.getAndIncrement()));
        Spot spotA = new Spot(Integer.valueOf(0), "Spot", Collections.emptySet());
        spotA.setId(Long.valueOf(idGenerator.getAndIncrement()));
        OffsetDateTime firstDateTime = OffsetDateTime.of(START_DATE, LocalTime.MIDNIGHT, ZoneOffset.UTC);
        ShiftBuilder shiftBuilder = new ShiftBuilder(idGenerator).forSpot(spotA).startingAtDate(firstDateTime).withShiftLength(Duration.ofHours(1L)).withTimeBetweenShifts(Duration.ofHours(1L));
        List<Shift> shiftList = shiftBuilder.generateShifts(2);
        shiftList.forEach(s -> s.setEmployee(employeeA));
        roster.setTenantId(Integer.valueOf(0));
        roster.setRosterState(rosterState);
        roster.setSpotList(Collections.singletonList(spotA));
        roster.setEmployeeList(Collections.singletonList(employeeA));
        roster.setSkillList(Collections.emptyList());
        roster.setRosterParametrization(rosterParametrization);
        roster.setEmployeeAvailabilityList(Collections.emptyList());
        roster.setShiftList(shiftList);
        Constraints constraint = Constraints.NO_2_SHIFTS_WITHIN_10_HOURS_FROM_EACH_OTHER;
        constraint.verifyNumOfInstances(scoreVerifier, roster, 1);
        shiftBuilder.withTimeBetweenShifts(Duration.ofHours(10L));
        shiftList = shiftBuilder.generateShifts(2);
        shiftList.forEach(s -> s.setEmployee(employeeA));
        roster.setShiftList(shiftList);
        constraint.verifyNumOfInstances(scoreVerifier, roster, 1);
        shiftBuilder.withTimeBetweenShifts(Duration.ofHours(11L));
        shiftList = shiftBuilder.generateShifts(2);
        shiftList.forEach(s -> s.setEmployee(employeeA));
        roster.setShiftList(shiftList);
        constraint.verifyNumOfInstances(scoreVerifier, roster, 0);
        shiftBuilder.withTimeBetweenShifts(Duration.ofHours(-1L));
        shiftList = shiftBuilder.generateShifts(2);
        shiftList.forEach(s -> s.setEmployee(employeeA));
        roster.setShiftList(shiftList);
        constraint.verifyNumOfInstances(scoreVerifier, roster, 1);
    }

    @Test(timeout=600000L)
    public void testAssignEveryShift() {
        HardMediumSoftLongScoreVerifier<Roster> scoreVerifier = this.getScoreVerifier();
        AtomicLong idGenerator = new AtomicLong(1L);
        Roster roster = new Roster();
        Tenant tenant = new Tenant("Test Tenant");
        tenant.setId(Integer.valueOf(0));
        RosterState rosterState = this.getRosterState(idGenerator);
        RosterParametrization rosterParametrization = this.getRosterParametrization(idGenerator);
        Contract contract = this.getDefaultContract(idGenerator);
        Employee employeeA = new Employee(Integer.valueOf(0), "Bill", contract, Collections.emptySet());
        employeeA.setId(Long.valueOf(idGenerator.getAndIncrement()));
        Spot spotA = new Spot(Integer.valueOf(0), "Spot", Collections.emptySet());
        spotA.setId(Long.valueOf(idGenerator.getAndIncrement()));
        OffsetDateTime firstDateTime = OffsetDateTime.of(START_DATE, LocalTime.MIDNIGHT, ZoneOffset.UTC);
        ShiftBuilder shiftBuilder = new ShiftBuilder(idGenerator).forSpot(spotA).startingAtDate(firstDateTime).withShiftLength(Duration.ofHours(1L)).withTimeBetweenShifts(Duration.ofDays(1L));
        List<Shift> shiftList = shiftBuilder.generateShifts(3);
        roster.setTenantId(Integer.valueOf(0));
        roster.setRosterState(rosterState);
        roster.setSpotList(Collections.singletonList(spotA));
        roster.setEmployeeList(Collections.singletonList(employeeA));
        roster.setSkillList(Collections.emptyList());
        roster.setRosterParametrization(rosterParametrization);
        roster.setEmployeeAvailabilityList(Collections.emptyList());
        roster.setShiftList(shiftList);
        Constraints constraint = Constraints.ASSIGN_EVERY_SHIFT;
        constraint.verifyNumOfInstances(scoreVerifier, roster, 3);
        shiftList.get(0).setEmployee(employeeA);
        constraint.verifyNumOfInstances(scoreVerifier, roster, 2);
        shiftList.get(1).setEmployee(employeeA);
        constraint.verifyNumOfInstances(scoreVerifier, roster, 1);
        shiftList.get(2).setEmployee(employeeA);
        constraint.verifyNumOfInstances(scoreVerifier, roster, 0);
    }

    @Test(timeout=600000L)
    public void testEmployeeIsNotRotationEmployeeConstraint() {
        HardMediumSoftLongScoreVerifier<Roster> scoreVerifier = this.getScoreVerifier();
        AtomicLong idGenerator = new AtomicLong(1L);
        Roster roster = new Roster();
        Tenant tenant = new Tenant("Test Tenant");
        tenant.setId(Integer.valueOf(0));
        RosterState rosterState = this.getRosterState(idGenerator);
        RosterParametrization rosterParametrization = this.getRosterParametrization(idGenerator);
        Spot spotA = new Spot(Integer.valueOf(0), "Spot A", Collections.emptySet());
        spotA.setId(Long.valueOf(idGenerator.getAndIncrement()));
        Contract contract = this.getDefaultContract(idGenerator);
        Employee employeeA = new Employee(Integer.valueOf(0), "Bill", contract, Collections.emptySet());
        employeeA.setId(Long.valueOf(idGenerator.getAndIncrement()));
        Employee rotationEmployee = new Employee(Integer.valueOf(0), "Anna", contract, Collections.emptySet());
        rotationEmployee.setId(Long.valueOf(idGenerator.getAndIncrement()));
        OffsetDateTime firstDateTime = OffsetDateTime.of(START_DATE, LocalTime.MIDNIGHT, ZoneOffset.UTC);
        Shift shift = new Shift(Integer.valueOf(0), spotA, firstDateTime, firstDateTime.plusHours(9L));
        shift.setId(Long.valueOf(idGenerator.getAndIncrement()));
        shift.setEmployee(employeeA);
        shift.setRotationEmployee(rotationEmployee);
        roster.setTenantId(Integer.valueOf(0));
        roster.setRosterState(rosterState);
        roster.setSpotList(Collections.singletonList(spotA));
        roster.setEmployeeList(Collections.singletonList(employeeA));
        roster.setSkillList(Collections.emptyList());
        roster.setRosterParametrization(rosterParametrization);
        roster.setEmployeeAvailabilityList(Collections.emptyList());
        roster.setShiftList(Collections.singletonList(shift));
        Constraints constraint = Constraints.EMPLOYEE_IS_NOT_ROTATION_EMPLOYEE;
        constraint.verifyNumOfInstances(scoreVerifier, roster, 1);
        shift.setEmployee(rotationEmployee);
        constraint.verifyNumOfInstances(scoreVerifier, roster, 0);
    }

    protected RosterGenerator buildRosterGenerator() {
        EntityManager entityManager = (EntityManager)Mockito.mock(EntityManager.class);
        AtomicInteger tenantIdGenerator = new AtomicInteger(0);
        ((EntityManager)Mockito.doAnswer(invocation -> {
            Tenant tenant = (Tenant)invocation.getArgument(0);
            tenant.setId(Integer.valueOf(tenantIdGenerator.getAndIncrement()));
            return invocation;
        }).when((Object)entityManager)).persist(ArgumentMatchers.any(Tenant.class));
        AtomicLong idGenerator = new AtomicLong(0L);
        ((EntityManager)Mockito.doAnswer(invocation -> {
            AbstractPersistable o = (AbstractPersistable)invocation.getArgument(0);
            o.setId(Long.valueOf(idGenerator.getAndIncrement()));
            return invocation;
        }).when((Object)entityManager)).persist(ArgumentMatchers.any(AbstractPersistable.class));
        RosterGenerator rosterGenerator = new RosterGenerator(entityManager);
        rosterGenerator.setUpGeneratedData();
        return rosterGenerator;
    }

    private RosterState getRosterState(AtomicLong idGenerator) {
        int PUBLISH_NOTICE = 7;
        int PUBLISH_LENGTH = 7;
        int DRAFT_LENGTH = 14;
        boolean ROTATION_OFFSET = false;
        int ROTATION_LENGTH = 7;
        RosterState rosterState = new RosterState(Integer.valueOf(0), Integer.valueOf(7), START_DATE.minusDays(7L), Integer.valueOf(7), Integer.valueOf(14), Integer.valueOf(0), Integer.valueOf(7), START_DATE.minusDays(14L), ZoneId.systemDefault());
        rosterState.setId(Long.valueOf(idGenerator.getAndIncrement()));
        return rosterState;
    }

    private Contract getDefaultContract(AtomicLong idGenerator) {
        Contract out = new Contract(Integer.valueOf(0), "Default Contract", null, null, null, null);
        out.setId(Long.valueOf(idGenerator.getAndIncrement()));
        return out;
    }

    private RosterParametrization getRosterParametrization(AtomicLong idGenerator) {
        ROSTER_PARAMETRIZATION.setTenantId(Integer.valueOf(0));
        ROSTER_PARAMETRIZATION.setId(Long.valueOf(idGenerator.getAndIncrement()));
        ROSTER_PARAMETRIZATION.setWeekStartDay(DayOfWeek.MONDAY);
        return ROSTER_PARAMETRIZATION;
    }

    static /* synthetic */ RosterParametrization access$000() {
        return ROSTER_PARAMETRIZATION;
    }

    private static class ShiftBuilder {
        OffsetDateTime firstShiftStartTime;
        Duration lengthOfShift;
        Duration durationBetweenShifts;
        Spot shiftSpot;
        AtomicLong idGenerator;

        public ShiftBuilder(AtomicLong idGenerator) {
            this.idGenerator = idGenerator;
        }

        public ShiftBuilder startingAtDate(OffsetDateTime startDate) {
            this.firstShiftStartTime = startDate;
            return this;
        }

        public ShiftBuilder withShiftLength(Duration duration) {
            this.lengthOfShift = duration;
            return this;
        }

        public ShiftBuilder withTimeBetweenShifts(Duration duration) {
            this.durationBetweenShifts = duration;
            return this;
        }

        public ShiftBuilder forSpot(Spot spot) {
            this.shiftSpot = spot;
            return this;
        }

        public List<Shift> generateShifts(int numberOfShifts) {
            if (this.firstShiftStartTime == null || this.lengthOfShift == null || this.durationBetweenShifts == null || this.shiftSpot == null) {
                throw new IllegalStateException("ShiftBuilder not initialized");
            }
            ArrayList<Shift> out = new ArrayList<Shift>();
            OffsetDateTime shiftStart = this.firstShiftStartTime;
            int i = 0;
            while (i < numberOfShifts) {
                out.add(new Shift(Integer.valueOf(0), this.shiftSpot, shiftStart, shiftStart.plus(this.lengthOfShift)));
                ((Shift)out.get(i)).setId(Long.valueOf(this.idGenerator.getAndIncrement()));
                ++i;
                shiftStart = shiftStart.plus(this.durationBetweenShifts);
            }
            return out;
        }
    }

    private static enum ContractField {
        DAILY(Constraints.DAILY_MINUTES_MUST_NOT_EXCEED_CONTRACT_MAXIMUM, 120, null, null, null, Duration.ofHours(6L), Duration.ofDays(1L)),
        WEEKLY(Constraints.WEEKLY_MINUTES_MUST_NOT_EXCEED_CONTRACT_MAXIMUM, null, 120, null, null, Duration.ofDays(1L), Duration.ofDays(7L)),
        MONTHLY(Constraints.MONTHLY_MINUTES_MUST_NOT_EXCEED_CONTRACT_MAXIMUM, null, null, 120, null, Duration.ofDays(7L), Duration.ofDays(31L)),
        ANNUALLY(Constraints.YEARLY_MINUTES_MUST_NOT_EXCEED_CONTRACT_MAXIMUM, null, null, null, 120, Duration.ofDays(31L), Duration.ofDays(366L));

        Constraints constraint;
        Integer dailyHours;
        Integer weeklyHours;
        Integer monthlyHours;
        Integer yearlyHours;
        Duration timeBetweenShifts;
        Duration periodLength;

        private ContractField(Constraints constraint, Integer dailyHours, Integer weeklyHours, Integer monthlyHours, Integer yearlyHours, Duration timeBetweenShifts, Duration periodLength) {
            this.constraint = constraint;
            this.dailyHours = dailyHours;
            this.weeklyHours = weeklyHours;
            this.monthlyHours = monthlyHours;
            this.yearlyHours = yearlyHours;
            this.timeBetweenShifts = timeBetweenShifts;
            this.periodLength = periodLength;
        }

        public Constraints getConstraint() {
            return this.constraint;
        }

        public Contract getContract(AtomicLong idGenerator) {
            Contract out = new Contract(Integer.valueOf(0), "Contract", this.dailyHours, this.weeklyHours, this.monthlyHours, this.yearlyHours);
            out.setId(Long.valueOf(idGenerator.getAndIncrement()));
            return out;
        }

        public List<Shift> generateShifts(ShiftBuilder shiftBuilder) {
            ArrayList<Shift> out = new ArrayList<Shift>();
            shiftBuilder.withTimeBetweenShifts(this.timeBetweenShifts);
            out.addAll(shiftBuilder.generateShifts(3));
            shiftBuilder.startingAtDate(shiftBuilder.firstShiftStartTime.plus(this.periodLength));
            out.addAll(shiftBuilder.generateShifts(3));
            return out;
        }
    }

    private static enum Constraints {
        REQUIRED_SKILL_FOR_A_SHIFT("Required skill for a shift", HardMediumSoftScore.of((int)-100, (int)0, (int)0)),
        UNAVAILABLE_TIME_SLOT_FOR_AN_EMPLOYEE("Unavailable time slot for an employee", HardMediumSoftScore.of((int)-50, (int)0, (int)0)),
        AT_MOST_ONE_SHIFT_ASSIGNMENT_PER_DAY_PER_EMPLOYEE("At most one shift assignment per day per employee", HardMediumSoftScore.of((int)-10, (int)0, (int)0)),
        NO_2_SHIFTS_WITHIN_10_HOURS_FROM_EACH_OTHER("No 2 shifts within 10 hours from each other", HardMediumSoftScore.of((int)-1, (int)0, (int)0)),
        DAILY_MINUTES_MUST_NOT_EXCEED_CONTRACT_MAXIMUM("Daily minutes must not exceed contract maximum", HardMediumSoftScore.of((int)-1, (int)0, (int)0)),
        WEEKLY_MINUTES_MUST_NOT_EXCEED_CONTRACT_MAXIMUM("Weekly minutes must not exceed contract maximum", HardMediumSoftScore.of((int)-1, (int)0, (int)0)),
        MONTHLY_MINUTES_MUST_NOT_EXCEED_CONTRACT_MAXIMUM("Monthly minutes must not exceed contract maximum", HardMediumSoftScore.of((int)-1, (int)0, (int)0)),
        YEARLY_MINUTES_MUST_NOT_EXCEED_CONTRACT_MAXIMUM("Yearly minutes must not exceed contract maximum", HardMediumSoftScore.of((int)-1, (int)0, (int)0)),
        ASSIGN_EVERY_SHIFT("Assign every shift", HardMediumSoftScore.of((int)0, (int)-1, (int)0)),
        UNDESIRED_TIME_SLOT_FOR_AN_EMPLOYEE("Undesired time slot for an employee", HardMediumSoftScore.of((int)0, (int)0, (int)(-SolverTest.access$000().getUndesiredTimeSlotWeight().intValue()))),
        DESIRED_TIME_SLOT_FOR_AN_EMPLOYEE("Desired time slot for an employee", HardMediumSoftScore.of((int)0, (int)0, (int)SolverTest.access$000().getDesiredTimeSlotWeight())),
        EMPLOYEE_IS_NOT_ROTATION_EMPLOYEE("Employee is not rotation employee", HardMediumSoftScore.of((int)0, (int)0, (int)(-SolverTest.access$000().getRotationEmployeeMatchWeight().intValue())));

        String constraintName;
        HardMediumSoftScore constraintWeight;

        private Constraints(String constraintName, HardMediumSoftScore constraintWeight) {
            this.constraintName = constraintName;
            this.constraintWeight = constraintWeight;
        }

        public void verifyNumOfInstances(HardMediumSoftLongScoreVerifier<Roster> scoreVerifier, Roster roster, int numOfInstances) {
            scoreVerifier.assertHardWeight(this.constraintName, (long)(this.constraintWeight.getHardScore() * numOfInstances), (Object)roster);
            scoreVerifier.assertMediumWeight(this.constraintName, (long)(this.constraintWeight.getMediumScore() * numOfInstances), (Object)roster);
            scoreVerifier.assertSoftWeight(this.constraintName, (long)(this.constraintWeight.getSoftScore() * numOfInstances), (Object)roster);
        }
    }
}

