/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.benchmark;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.optaplanner.benchmark.api.PlannerBenchmark;
import org.optaplanner.benchmark.api.PlannerBenchmarkFactory;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaweb.employeerostering.server.roster.RosterGenerator;
import org.optaweb.employeerostering.shared.roster.Roster;

public class OptaWebEmployeeRosteringBenchmarkApp {
    public static void main(String[] args) {
        List<Roster> rosterList = OptaWebEmployeeRosteringBenchmarkApp.generateRosters();
        SolverFactory solverFactory = SolverFactory.createFromXmlResource((String)"org/optaweb/employeerostering/server/solver/employeeRosteringSolverConfig.xml");
        PlannerBenchmarkFactory benchmarkFactory = PlannerBenchmarkFactory.createFromSolverFactory((SolverFactory)solverFactory);
        PlannerBenchmark plannerBenchmark = benchmarkFactory.buildPlannerBenchmark(rosterList);
        plannerBenchmark.benchmark();
    }

    private static List<Roster> generateRosters() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("javax.persistence.transactionType", "RESOURCE_LOCAL");
        properties.put("javax.persistence.jdbc.driver", "org.hsqldb.jdbcDriver");
        properties.put("javax.persistence.jdbc.url", "jdbc:hsqldb:mem:testdb");
        properties.put("javax.persistence.jdbc.user", "sa");
        properties.put("javax.persistence.jdbc.password", "");
        EntityManagerFactory entityManagerFactory = Persistence.createEntityManagerFactory((String)"optaweb-employee-rostering-persistence-unit", properties);
        EntityManager entityManager = entityManagerFactory.createEntityManager();
        RosterGenerator rosterGenerator = new RosterGenerator(entityManager);
        ArrayList<Roster> rosterList = new ArrayList<Roster>();
        rosterList.add(rosterGenerator.generateRoster(10, 7));
        rosterList.add(rosterGenerator.generateRoster(80, 112));
        entityManager.close();
        entityManagerFactory.close();
        return rosterList;
    }
}

