/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.restclient;

import java.net.URL;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.optaweb.employeerostering.shared.employee.EmployeeRestService;
import org.optaweb.employeerostering.shared.roster.RosterRestService;
import org.optaweb.employeerostering.shared.rotation.RotationRestService;
import org.optaweb.employeerostering.shared.shift.ShiftRestService;
import org.optaweb.employeerostering.shared.skill.SkillRestService;
import org.optaweb.employeerostering.shared.spot.SpotRestService;
import org.optaweb.employeerostering.shared.tenant.TenantRestService;

public final class ServiceClientFactory {
    private static final String REST_API_CONTEXT = "rest";
    private URL baseUrl;
    private ResteasyClient resteasyClient;
    private ResteasyWebTarget target;

    public ServiceClientFactory(URL baseUrl) {
        this(baseUrl, new ResteasyClientBuilder().build());
    }

    public ServiceClientFactory(URL baseUrl, ResteasyClient resteasyClient) {
        this.baseUrl = baseUrl;
        this.resteasyClient = resteasyClient;
        this.target = resteasyClient.target(baseUrl.toExternalForm() + REST_API_CONTEXT);
    }

    public SkillRestService createSkillRestServiceClient() {
        return (SkillRestService)this.target.proxy(SkillRestService.class);
    }

    public EmployeeRestService createEmployeeRestServiceClient() {
        return (EmployeeRestService)this.target.proxy(EmployeeRestService.class);
    }

    public RosterRestService createRosterRestServiceClient() {
        return (RosterRestService)this.target.proxy(RosterRestService.class);
    }

    public ShiftRestService createShiftRestServiceClient() {
        return (ShiftRestService)this.target.proxy(ShiftRestService.class);
    }

    public SpotRestService createSpotRestServiceClient() {
        return (SpotRestService)this.target.proxy(SpotRestService.class);
    }

    public RotationRestService createRotationRestServiceClient() {
        return (RotationRestService)this.target.proxy(RotationRestService.class);
    }

    public TenantRestService createTenantRestServiceClient() {
        return (TenantRestService)this.target.proxy(TenantRestService.class);
    }
}

