/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.server.admin;

import java.time.ZoneId;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaDelete;
import javax.transaction.Transactional;
import org.optaweb.employeerostering.server.admin.SystemPropertiesRetriever;
import org.optaweb.employeerostering.server.common.AbstractRestServiceImpl;
import org.optaweb.employeerostering.server.roster.RosterGenerator;
import org.optaweb.employeerostering.shared.admin.AdminRestService;
import org.optaweb.employeerostering.shared.employee.Employee;
import org.optaweb.employeerostering.shared.employee.EmployeeAvailability;
import org.optaweb.employeerostering.shared.roster.RosterState;
import org.optaweb.employeerostering.shared.rotation.ShiftTemplate;
import org.optaweb.employeerostering.shared.shift.Shift;
import org.optaweb.employeerostering.shared.skill.Skill;
import org.optaweb.employeerostering.shared.spot.Spot;
import org.optaweb.employeerostering.shared.tenant.RosterParametrization;
import org.optaweb.employeerostering.shared.tenant.Tenant;

public class AdminRestServiceImpl
extends AbstractRestServiceImpl
implements AdminRestService {
    @PersistenceContext
    private EntityManager entityManager;
    @Inject
    private RosterGenerator rosterGenerator;

    @Transactional
    public void resetApplication(ZoneId zoneId) {
        if (zoneId == null) {
            zoneId = SystemPropertiesRetriever.determineZoneId();
        }
        this.deleteAllEntities(Shift.class, EmployeeAvailability.class, ShiftTemplate.class, Employee.class, Spot.class, Skill.class, RosterParametrization.class, RosterState.class, Tenant.class);
        this.rosterGenerator.setUpGeneratedData(zoneId);
    }

    private void deleteAllEntities(Class<?> ... entityTypes) {
        for (Class<?> entityType : entityTypes) {
            CriteriaBuilder builder = this.entityManager.getCriteriaBuilder();
            CriteriaDelete query = builder.createCriteriaDelete(entityType);
            query.from(entityType);
            this.entityManager.createQuery(query).executeUpdate();
        }
    }
}

