/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.server.roster;

import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.transaction.Transactional;
import org.optaplanner.core.api.score.constraint.Indictment;
import org.optaweb.employeerostering.server.common.AbstractRestServiceImpl;
import org.optaweb.employeerostering.server.common.IndictmentUtils;
import org.optaweb.employeerostering.server.solver.WannabeSolverManager;
import org.optaweb.employeerostering.shared.common.AbstractPersistable;
import org.optaweb.employeerostering.shared.employee.Employee;
import org.optaweb.employeerostering.shared.employee.EmployeeAvailability;
import org.optaweb.employeerostering.shared.employee.view.EmployeeAvailabilityView;
import org.optaweb.employeerostering.shared.roster.Pagination;
import org.optaweb.employeerostering.shared.roster.PublishResult;
import org.optaweb.employeerostering.shared.roster.Roster;
import org.optaweb.employeerostering.shared.roster.RosterRestService;
import org.optaweb.employeerostering.shared.roster.RosterState;
import org.optaweb.employeerostering.shared.roster.view.AvailabilityRosterView;
import org.optaweb.employeerostering.shared.roster.view.ShiftRosterView;
import org.optaweb.employeerostering.shared.rotation.ShiftTemplate;
import org.optaweb.employeerostering.shared.shift.Shift;
import org.optaweb.employeerostering.shared.shift.view.ShiftView;
import org.optaweb.employeerostering.shared.skill.Skill;
import org.optaweb.employeerostering.shared.spot.Spot;
import org.optaweb.employeerostering.shared.tenant.TenantRestService;

public class RosterRestServiceImpl
extends AbstractRestServiceImpl
implements RosterRestService {
    @PersistenceContext
    private EntityManager entityManager;
    @Inject
    private WannabeSolverManager solverManager;
    @Inject
    private TenantRestService tenantRestService;
    @Inject
    private IndictmentUtils indictmentUtils;

    @Transactional
    public ShiftRosterView getCurrentShiftRosterView(Integer tenantId, Integer pageNumber, Integer numberOfItemsPerPage) {
        RosterState rosterState = this.getRosterState(tenantId);
        LocalDate startDate = rosterState.getFirstPublishedDate();
        LocalDate endDate = rosterState.getFirstUnplannedDate();
        return this.getShiftRosterView(tenantId, startDate, endDate, Pagination.of((Integer)pageNumber, (Integer)numberOfItemsPerPage));
    }

    @Transactional
    public ShiftRosterView getShiftRosterView(Integer tenantId, Integer pageNumber, Integer numberOfItemsPerPage, String startDateString, String endDateString) {
        return this.getShiftRosterView(tenantId, LocalDate.parse(startDateString), LocalDate.parse(endDateString), Pagination.of((Integer)pageNumber, (Integer)numberOfItemsPerPage));
    }

    private ShiftRosterView getShiftRosterView(Integer tenantId, LocalDate startDate, LocalDate endDate, Pagination pagination) {
        List spots = this.entityManager.createNamedQuery("Spot.findAll", Spot.class).setParameter("tenantId", (Object)tenantId).setMaxResults(pagination.getNumberOfItemsPerPage().intValue()).setFirstResult(pagination.getFirstResultIndex().intValue()).getResultList();
        return this.getShiftRosterView(tenantId, startDate, endDate, spots);
    }

    private ShiftRosterView getShiftRosterView(Integer tenantId, LocalDate startDate, LocalDate endDate) {
        List spots = this.entityManager.createNamedQuery("Spot.findAll", Spot.class).setParameter("tenantId", (Object)tenantId).getResultList();
        return this.getShiftRosterView(tenantId, startDate, endDate, spots);
    }

    @Transactional
    public ShiftRosterView getShiftRosterViewFor(Integer tenantId, String startDateString, String endDateString, List<Spot> spots) {
        LocalDate startDate = LocalDate.parse(startDateString);
        LocalDate endDate = LocalDate.parse(endDateString);
        if (null == spots) {
            throw new IllegalArgumentException("spots is null!");
        }
        return this.getShiftRosterView(tenantId, startDate, endDate, spots);
    }

    @Transactional
    protected ShiftRosterView getShiftRosterView(Integer tenantId, LocalDate startDate, LocalDate endDate, List<Spot> spotList) {
        ShiftRosterView shiftRosterView = new ShiftRosterView(tenantId, startDate, endDate);
        shiftRosterView.setSpotList(spotList);
        List employeeList = this.entityManager.createNamedQuery("Employee.findAll", Employee.class).setParameter("tenantId", (Object)tenantId).getResultList();
        shiftRosterView.setEmployeeList(employeeList);
        HashSet<Spot> spotSet = new HashSet<Spot>(spotList);
        ZoneId timeZone = this.getRosterState(tenantId).getTimeZone();
        List shiftList = this.entityManager.createNamedQuery("Shift.filterWithSpots", Shift.class).setParameter("tenantId", (Object)tenantId).setParameter("spotSet", spotSet).setParameter("startDateTime", (Object)startDate.atStartOfDay(timeZone).toOffsetDateTime()).setParameter("endDateTime", (Object)endDate.atStartOfDay(timeZone).toOffsetDateTime()).getResultList();
        LinkedHashMap<Long, List> spotIdToShiftViewListMap = new LinkedHashMap<Long, List>(spotList.size());
        Roster roster = this.solverManager.getRoster(tenantId);
        if (roster == null) {
            roster = this.buildRoster(tenantId);
        }
        Map<Object, Indictment> indictmentMap = this.indictmentUtils.getIndictmentMapForRoster(roster);
        for (Shift shift : shiftList) {
            Indictment indictment = indictmentMap.get(shift);
            spotIdToShiftViewListMap.computeIfAbsent(shift.getSpot().getId(), k -> new ArrayList()).add(this.indictmentUtils.getShiftViewWithIndictment(timeZone, shift, indictment));
        }
        shiftRosterView.setSpotIdToShiftViewListMap(spotIdToShiftViewListMap);
        shiftRosterView.setScore(roster == null ? null : roster.getScore());
        shiftRosterView.setRosterState(this.getRosterState(tenantId));
        return shiftRosterView;
    }

    @Transactional
    public AvailabilityRosterView getCurrentAvailabilityRosterView(Integer tenantId, Integer pageNumber, Integer numberOfItemsPerPage) {
        RosterState rosterState = this.getRosterState(tenantId);
        LocalDate startDate = rosterState.getLastHistoricDate();
        LocalDate endDate = rosterState.getFirstUnplannedDate();
        return this.getAvailabilityRosterView(tenantId, startDate, endDate, Pagination.of((Integer)pageNumber, (Integer)numberOfItemsPerPage));
    }

    @Transactional
    public AvailabilityRosterView getAvailabilityRosterView(Integer tenantId, Integer pageNumber, Integer numberOfItemsPerPage, String startDateString, String endDateString) {
        LocalDate startDate = LocalDate.parse(startDateString);
        LocalDate endDate = LocalDate.parse(endDateString);
        return this.getAvailabilityRosterView(tenantId, startDate, endDate, Pagination.of((Integer)pageNumber, (Integer)numberOfItemsPerPage));
    }

    @Transactional
    public AvailabilityRosterView getAvailabilityRosterViewFor(Integer tenantId, String startDateString, String endDateString, List<Employee> employeeList) {
        LocalDate startDate = LocalDate.parse(startDateString);
        LocalDate endDate = LocalDate.parse(endDateString);
        if (employeeList == null) {
            throw new IllegalArgumentException("The employeeList (" + employeeList + ") must not be null.");
        }
        return this.getAvailabilityRosterView(tenantId, startDate, endDate, employeeList);
    }

    private AvailabilityRosterView getAvailabilityRosterView(Integer tenantId, LocalDate startDate, LocalDate endDate, Pagination pagination) {
        List employeeList = this.entityManager.createNamedQuery("Employee.findAll", Employee.class).setParameter("tenantId", (Object)tenantId).setMaxResults(pagination.getNumberOfItemsPerPage().intValue()).setFirstResult(pagination.getFirstResultIndex().intValue()).getResultList();
        return this.getAvailabilityRosterView(tenantId, startDate, endDate, employeeList);
    }

    @Transactional
    protected AvailabilityRosterView getAvailabilityRosterView(Integer tenantId, LocalDate startDate, LocalDate endDate, List<Employee> employeeList) {
        AvailabilityRosterView availabilityRosterView = new AvailabilityRosterView(tenantId, startDate, endDate);
        List spotList = this.entityManager.createNamedQuery("Spot.findAll", Spot.class).setParameter("tenantId", (Object)tenantId).getResultList();
        availabilityRosterView.setSpotList(spotList);
        availabilityRosterView.setEmployeeList(employeeList);
        LinkedHashMap<Long, List> employeeIdToShiftViewListMap = new LinkedHashMap<Long, List>(employeeList.size());
        ArrayList<ShiftView> unassignedShiftViewList = new ArrayList<ShiftView>();
        HashSet<Employee> employeeSet = new HashSet<Employee>(employeeList);
        ZoneId timeZone = this.getRosterState(tenantId).getTimeZone();
        List shiftList = this.entityManager.createNamedQuery("Shift.filterWithEmployees", Shift.class).setParameter("tenantId", (Object)tenantId).setParameter("startDateTime", (Object)startDate.atStartOfDay(timeZone).toOffsetDateTime()).setParameter("endDateTime", (Object)endDate.atStartOfDay(timeZone).toOffsetDateTime()).setParameter("employeeSet", employeeSet).getResultList();
        Roster roster = this.solverManager.getRoster(tenantId);
        if (roster == null) {
            roster = this.buildRoster(tenantId);
        }
        Map<Object, Indictment> indictmentMap = this.indictmentUtils.getIndictmentMapForRoster(roster);
        for (Shift shift : shiftList) {
            Indictment indictment = indictmentMap.get(shift);
            if (shift.getEmployee() != null) {
                employeeIdToShiftViewListMap.computeIfAbsent(shift.getEmployee().getId(), k -> new ArrayList()).add(this.indictmentUtils.getShiftViewWithIndictment(timeZone, shift, indictment));
                continue;
            }
            unassignedShiftViewList.add(this.indictmentUtils.getShiftViewWithIndictment(timeZone, shift, indictment));
        }
        availabilityRosterView.setEmployeeIdToShiftViewListMap(employeeIdToShiftViewListMap);
        availabilityRosterView.setUnassignedShiftViewList(unassignedShiftViewList);
        LinkedHashMap<Long, List> employeeIdToAvailabilityViewListMap = new LinkedHashMap<Long, List>(employeeList.size());
        List employeeAvailabilityList = this.entityManager.createNamedQuery("EmployeeAvailability.filterWithEmployee", EmployeeAvailability.class).setParameter("tenantId", (Object)tenantId).setParameter("startDateTime", (Object)startDate.atStartOfDay(timeZone).toOffsetDateTime()).setParameter("endDateTime", (Object)endDate.atStartOfDay(timeZone).toOffsetDateTime()).setParameter("employeeSet", employeeSet).getResultList();
        for (EmployeeAvailability employeeAvailability : employeeAvailabilityList) {
            employeeIdToAvailabilityViewListMap.computeIfAbsent(employeeAvailability.getEmployee().getId(), k -> new ArrayList()).add(new EmployeeAvailabilityView(timeZone, employeeAvailability));
        }
        availabilityRosterView.setEmployeeIdToAvailabilityViewListMap(employeeIdToAvailabilityViewListMap);
        availabilityRosterView.setScore(roster.getScore());
        availabilityRosterView.setRosterState(this.getRosterState(tenantId));
        return availabilityRosterView;
    }

    public void solveRoster(Integer tenantId) {
        this.solverManager.solve(tenantId);
    }

    public void terminateRosterEarly(Integer tenantId) {
        this.solverManager.terminate(tenantId);
    }

    @Transactional
    public Roster buildRoster(Integer tenantId) {
        List skillList = this.entityManager.createNamedQuery("Skill.findAll", Skill.class).setParameter("tenantId", (Object)tenantId).getResultList();
        List spotList = this.entityManager.createNamedQuery("Spot.findAll", Spot.class).setParameter("tenantId", (Object)tenantId).getResultList();
        List employeeList = this.entityManager.createNamedQuery("Employee.findAll", Employee.class).setParameter("tenantId", (Object)tenantId).getResultList();
        List employeeAvailabilityList = this.entityManager.createNamedQuery("EmployeeAvailability.findAll", EmployeeAvailability.class).setParameter("tenantId", (Object)tenantId).getResultList();
        List shiftList = this.entityManager.createNamedQuery("Shift.findAll", Shift.class).setParameter("tenantId", (Object)tenantId).getResultList();
        return new Roster(Long.valueOf(tenantId.intValue()), tenantId, skillList, spotList, employeeList, employeeAvailabilityList, this.tenantRestService.getRosterParametrization(tenantId), this.getRosterState(tenantId), shiftList);
    }

    @Transactional
    public void updateShiftsOfRoster(Roster newRoster) {
        Integer tenantId = newRoster.getTenantId();
        Map employeeIdMap = this.entityManager.createNamedQuery("Employee.findAll", Employee.class).setParameter("tenantId", (Object)tenantId).getResultList().stream().collect(Collectors.toMap(AbstractPersistable::getId, Function.identity()));
        Map shiftIdMap = this.entityManager.createNamedQuery("Shift.findAll", Shift.class).setParameter("tenantId", (Object)tenantId).getResultList().stream().collect(Collectors.toMap(AbstractPersistable::getId, Function.identity()));
        for (Shift shift : newRoster.getShiftList()) {
            Shift attachedShift = (Shift)shiftIdMap.get(shift.getId());
            if (attachedShift == null) continue;
            attachedShift.setEmployee(shift.getEmployee() == null ? null : (Employee)employeeIdMap.get(shift.getEmployee().getId()));
        }
    }

    @Transactional
    public PublishResult publishAndProvision(Integer tenantId) {
        RosterState rosterState = this.getRosterState(tenantId);
        LocalDate publishFrom = rosterState.getFirstDraftDate();
        LocalDate publishTo = publishFrom.plusDays(rosterState.getPublishLength().intValue());
        LocalDate firstUnplannedDate = rosterState.getFirstUnplannedDate();
        rosterState.setFirstDraftDate(publishTo);
        List shiftTemplateList = this.entityManager.createNamedQuery("ShiftTemplate.findAll", ShiftTemplate.class).setParameter("tenantId", (Object)tenantId).getResultList();
        Map<Integer, List<ShiftTemplate>> dayOffsetToShiftTemplateListMap = shiftTemplateList.stream().collect(Collectors.groupingBy(ShiftTemplate::getStartDayOffset));
        int dayOffset = rosterState.getUnplannedRotationOffset();
        LocalDate shiftDate = firstUnplannedDate;
        for (int i = 0; i < rosterState.getPublishLength(); ++i) {
            List dayShiftTemplateList = dayOffsetToShiftTemplateListMap.getOrDefault(dayOffset, Collections.emptyList());
            for (ShiftTemplate shiftTemplate : dayShiftTemplateList) {
                Shift shift = shiftTemplate.createShiftOnDate(shiftDate, rosterState.getRotationLength().intValue(), rosterState.getTimeZone(), false);
                this.entityManager.persist((Object)shift);
            }
            shiftDate = shiftDate.plusDays(1L);
            dayOffset = (dayOffset + 1) % rosterState.getRotationLength();
        }
        rosterState.setUnplannedRotationOffset(Integer.valueOf(dayOffset));
        return new PublishResult(publishFrom, publishTo);
    }

    public RosterState getRosterState(Integer tenantId) {
        return (RosterState)this.entityManager.createNamedQuery("RosterState.find", RosterState.class).setParameter("tenantId", (Object)tenantId).getSingleResult();
    }
}

