/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.server.shift;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import javax.transaction.Transactional;
import org.optaplanner.core.api.score.constraint.Indictment;
import org.optaweb.employeerostering.server.common.AbstractRestServiceImpl;
import org.optaweb.employeerostering.server.common.IndictmentUtils;
import org.optaweb.employeerostering.shared.common.AbstractPersistable;
import org.optaweb.employeerostering.shared.employee.Employee;
import org.optaweb.employeerostering.shared.employee.EmployeeRestService;
import org.optaweb.employeerostering.shared.roster.RosterRestService;
import org.optaweb.employeerostering.shared.roster.RosterState;
import org.optaweb.employeerostering.shared.rotation.ShiftTemplate;
import org.optaweb.employeerostering.shared.rotation.view.RotationView;
import org.optaweb.employeerostering.shared.rotation.view.ShiftTemplateView;
import org.optaweb.employeerostering.shared.shift.Shift;
import org.optaweb.employeerostering.shared.shift.ShiftRestService;
import org.optaweb.employeerostering.shared.shift.view.ShiftView;
import org.optaweb.employeerostering.shared.spot.Spot;
import org.optaweb.employeerostering.shared.spot.SpotRestService;

public class ShiftRestServiceImpl
extends AbstractRestServiceImpl
implements ShiftRestService {
    @PersistenceContext
    private EntityManager entityManager;
    @Inject
    private RosterRestService rosterRestService;
    @Inject
    private SpotRestService spotRestService;
    @Inject
    private EmployeeRestService employeeRestService;
    @Inject
    private IndictmentUtils indictmentUtils;

    @Transactional
    public ShiftView getShift(Integer tenantId, Long id) {
        Shift shift = (Shift)this.entityManager.find(Shift.class, (Object)id);
        this.validateTenantIdParameter(tenantId, (AbstractPersistable)shift);
        Indictment indictment = this.indictmentUtils.getIndictmentMapForRoster(this.rosterRestService.buildRoster(tenantId)).get(shift);
        return this.indictmentUtils.getShiftViewWithIndictment(this.rosterRestService.getRosterState(tenantId).getTimeZone(), shift, indictment);
    }

    @Transactional
    public ShiftView addShift(Integer tenantId, ShiftView shiftView) {
        Shift shift = this.convertFromView(tenantId, shiftView);
        this.entityManager.persist((Object)shift);
        Indictment indictment = this.indictmentUtils.getIndictmentMapForRoster(this.rosterRestService.buildRoster(tenantId)).get(shift);
        return this.indictmentUtils.getShiftViewWithIndictment(this.rosterRestService.getRosterState(tenantId).getTimeZone(), shift, indictment);
    }

    @Transactional
    public ShiftView updateShift(Integer tenantId, ShiftView shiftView) {
        Shift shift = this.convertFromView(tenantId, shiftView);
        shift = (Shift)this.entityManager.merge((Object)shift);
        this.entityManager.flush();
        Indictment indictment = this.indictmentUtils.getIndictmentMapForRoster(this.rosterRestService.buildRoster(tenantId)).get(shift);
        return this.indictmentUtils.getShiftViewWithIndictment(this.rosterRestService.getRosterState(tenantId).getTimeZone(), shift, indictment);
    }

    private Shift convertFromView(Integer tenantId, ShiftView shiftView) {
        this.validateTenantIdParameter(tenantId, (AbstractPersistable)shiftView);
        Spot spot = (Spot)this.entityManager.find(Spot.class, (Object)shiftView.getSpotId());
        this.validateTenantIdParameter(tenantId, (AbstractPersistable)spot);
        Long rotationEmployeeId = shiftView.getRotationEmployeeId();
        Employee rotationEmployee = null;
        if (rotationEmployeeId != null) {
            rotationEmployee = (Employee)this.entityManager.find(Employee.class, (Object)rotationEmployeeId);
            if (rotationEmployee == null) {
                throw new IllegalArgumentException("ShiftView (" + shiftView + ") has an non-existing employeeId (" + rotationEmployeeId + ").");
            }
            this.validateTenantIdParameter(tenantId, (AbstractPersistable)rotationEmployee);
        }
        Shift shift = new Shift(this.rosterRestService.getRosterState(tenantId).getTimeZone(), shiftView, spot, rotationEmployee);
        shift.setPinnedByUser(shiftView.isPinnedByUser());
        Long employeeId = shiftView.getEmployeeId();
        if (employeeId != null) {
            Employee employee = (Employee)this.entityManager.find(Employee.class, (Object)employeeId);
            if (employee == null) {
                throw new IllegalArgumentException("ShiftView (" + shiftView + ") has an non-existing employeeId (" + employeeId + ").");
            }
            this.validateTenantIdParameter(tenantId, (AbstractPersistable)employee);
            shift.setEmployee(employee);
        }
        return shift;
    }

    @Transactional
    public Boolean removeShift(Integer tenantId, Long id) {
        Shift shift = (Shift)this.entityManager.find(Shift.class, (Object)id);
        if (shift == null) {
            return false;
        }
        this.validateTenantIdParameter(tenantId, (AbstractPersistable)shift);
        this.entityManager.remove((Object)shift);
        return true;
    }

    public List<ShiftView> getShifts(Integer tenantId) {
        Map<Object, Indictment> indictmentMap = this.indictmentUtils.getIndictmentMapForRoster(this.rosterRestService.buildRoster(tenantId));
        return this.getAllShifts(tenantId).stream().map(s -> this.indictmentUtils.getShiftViewWithIndictment(this.rosterRestService.getRosterState(tenantId).getTimeZone(), (Shift)s, (Indictment)indictmentMap.get(s))).collect(Collectors.toList());
    }

    private List<Shift> getAllShifts(Integer tenantId) {
        TypedQuery q = this.entityManager.createNamedQuery("Shift.findAll", Shift.class);
        q.setParameter("tenantId", (Object)tenantId);
        return q.getResultList();
    }

    public RotationView getRotation(Integer tenantId) {
        List shiftTemplateList = this.entityManager.createNamedQuery("ShiftTemplate.findAll", ShiftTemplate.class).setParameter("tenantId", (Object)tenantId).getResultList();
        RotationView rotationView = new RotationView();
        rotationView.setTenantId(tenantId);
        rotationView.setSpotList(this.spotRestService.getSpotList(tenantId));
        rotationView.setEmployeeList(this.employeeRestService.getEmployeeList(tenantId));
        rotationView.setRotationLength(((RosterState)this.entityManager.createNamedQuery("RosterState.find", RosterState.class).setParameter("tenantId", (Object)tenantId).getSingleResult()).getRotationLength());
        HashMap spotIdToShiftTemplateViewListMap = new HashMap();
        shiftTemplateList.forEach(shiftTemplate -> spotIdToShiftTemplateViewListMap.computeIfAbsent(shiftTemplate.getSpot().getId(), k -> new ArrayList()).add(new ShiftTemplateView(rotationView.getRotationLength(), shiftTemplate)));
        rotationView.setSpotIdToShiftTemplateViewListMap(spotIdToShiftTemplateViewListMap);
        return rotationView;
    }

    @Transactional
    public void updateRotation(Integer tenantId, RotationView rotationView) {
        if (!tenantId.equals(rotationView.getTenantId())) {
            throw new IllegalArgumentException("rotationView (" + rotationView + ") tenantId does not match tenantId (" + tenantId + ")");
        }
        List oldShiftTemplateList = this.entityManager.createNamedQuery("ShiftTemplate.findAll", ShiftTemplate.class).setParameter("tenantId", (Object)tenantId).getResultList();
        oldShiftTemplateList.forEach(s -> this.entityManager.remove(s));
        Integer rotationLength = ((RosterState)this.entityManager.createNamedQuery("RosterState.find", RosterState.class).setParameter("tenantId", (Object)tenantId).getSingleResult()).getRotationLength();
        Map<Long, Spot> spotIdToSpotMap = this.spotRestService.getSpotList(tenantId).stream().collect(Collectors.toMap(spot -> spot.getId(), spot -> spot));
        Map<Long, Employee> employeeIdToEmployeeMap = this.employeeRestService.getEmployeeList(tenantId).stream().collect(Collectors.toMap(employee -> employee.getId(), employee -> employee));
        rotationView.getSpotIdToShiftTemplateViewListMap().forEach((spotId, shiftTemplateViewList) -> {
            Spot spot = (Spot)spotIdToSpotMap.get(spotId);
            if (shiftTemplateViewList != null) {
                shiftTemplateViewList.forEach(shiftTemplateView -> this.entityManager.merge((Object)new ShiftTemplate(rotationLength, shiftTemplateView, spot, (Employee)employeeIdToEmployeeMap.get(shiftTemplateView.getRotationEmployeeId()))));
            }
        });
    }
}

