/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.server.solver;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.enterprise.concurrent.ManagedExecutorService;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.core.impl.score.director.ScoreDirectorFactory;
import org.optaweb.employeerostering.server.solver.SolverStatus;
import org.optaweb.employeerostering.shared.roster.Roster;
import org.optaweb.employeerostering.shared.roster.RosterRestService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class WannabeSolverManager {
    public static final String SOLVER_CONFIG = "org/optaweb/employeerostering/server/solver/employeeRosteringSolverConfig.xml";
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private SolverFactory<Roster> solverFactory;
    private ScoreDirectorFactory<Roster> scoreDirectorFactory;
    @Resource(name="DefaultManagedExecutorService")
    private ManagedExecutorService executorService;
    @Inject
    private RosterRestService rosterRestService;
    private ConcurrentMap<Integer, SolverStatus> tenantIdToSolverStateMap = new ConcurrentHashMap<Integer, SolverStatus>();
    private ConcurrentMap<Integer, Solver<Roster>> tenantIdToSolverMap = new ConcurrentHashMap<Integer, Solver<Roster>>();

    @PostConstruct
    public void setUpSolverFactory() {
        this.solverFactory = SolverFactory.createFromXmlResource((String)SOLVER_CONFIG);
        this.scoreDirectorFactory = this.solverFactory.buildSolver().getScoreDirectorFactory();
    }

    public void terminate(Integer tenantId) {
        Solver solver = (Solver)this.tenantIdToSolverMap.get(tenantId);
        if (null == solver) {
            throw new IllegalStateException("The roster with tenantId (" + tenantId + ") is not being solved currently.");
        }
        solver.terminateEarly();
    }

    public void solve(Integer tenantId) {
        this.logger.info("Scheduling solver for tenantId ({})...", (Object)tenantId);
        this.tenantIdToSolverStateMap.compute(tenantId, (k, solverStatus) -> {
            if (solverStatus != null && solverStatus != SolverStatus.TERMINATED) {
                throw new IllegalStateException("The roster with tenantId (" + tenantId + ") is already solving with solverStatus (" + (Object)solverStatus + ").");
            }
            return SolverStatus.SCHEDULED;
        });
        this.executorService.submit(() -> {
            try {
                Solver solver = this.solverFactory.buildSolver();
                this.tenantIdToSolverMap.put(tenantId, (Solver<Roster>)solver);
                solver.addEventListener(event -> {
                    if (event.isEveryProblemFactChangeProcessed()) {
                        this.logger.info("  New best solution found for tenantId ({}).", (Object)tenantId);
                        Roster newBestRoster = (Roster)event.getNewBestSolution();
                        this.rosterRestService.updateShiftsOfRoster(newBestRoster);
                    }
                });
                Roster roster = this.rosterRestService.buildRoster(tenantId);
                try {
                    this.tenantIdToSolverStateMap.put(tenantId, SolverStatus.SOLVING);
                    solver.solve((Object)roster);
                }
                finally {
                    this.tenantIdToSolverMap.remove(tenantId);
                    this.tenantIdToSolverStateMap.put(tenantId, SolverStatus.TERMINATED);
                }
            }
            catch (Throwable e) {
                this.logger.error("Error solving for tenantId (" + tenantId + ").", e);
            }
        });
    }

    public Roster getRoster(Integer tenantId) {
        Solver solver = (Solver)this.tenantIdToSolverMap.get(tenantId);
        return solver == null ? null : (Roster)solver.getBestSolution();
    }

    public ScoreDirector<Roster> getScoreDirector() {
        return this.scoreDirectorFactory.buildScoreDirector();
    }
}

