/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.server.rotation;

import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.EntityNotFoundException;
import javax.persistence.PersistenceContext;
import javax.transaction.Transactional;
import org.optaweb.employeerostering.server.common.AbstractRestServiceImpl;
import org.optaweb.employeerostering.shared.common.AbstractPersistable;
import org.optaweb.employeerostering.shared.employee.Employee;
import org.optaweb.employeerostering.shared.employee.EmployeeRestService;
import org.optaweb.employeerostering.shared.roster.RosterRestService;
import org.optaweb.employeerostering.shared.roster.RosterState;
import org.optaweb.employeerostering.shared.rotation.RotationRestService;
import org.optaweb.employeerostering.shared.rotation.ShiftTemplate;
import org.optaweb.employeerostering.shared.rotation.view.ShiftTemplateView;
import org.optaweb.employeerostering.shared.spot.Spot;
import org.optaweb.employeerostering.shared.spot.SpotRestService;

public class RotationRestServiceImpl
extends AbstractRestServiceImpl
implements RotationRestService {
    @PersistenceContext
    private EntityManager entityManager;
    @Inject
    private RosterRestService rosterRestService;
    @Inject
    private SpotRestService spotRestService;
    @Inject
    private EmployeeRestService employeeRestService;

    public List<ShiftTemplateView> getShiftTemplateList(Integer tenantId) {
        RosterState rosterState = this.rosterRestService.getRosterState(tenantId);
        return this.entityManager.createNamedQuery("ShiftTemplate.findAll", ShiftTemplate.class).setParameter("tenantId", (Object)tenantId).getResultList().stream().map(st -> new ShiftTemplateView(rosterState.getRotationLength(), st)).collect(Collectors.toList());
    }

    public ShiftTemplateView getShiftTemplate(Integer tenantId, Long id) {
        RosterState rosterState = this.rosterRestService.getRosterState(tenantId);
        ShiftTemplate shiftTemplate = (ShiftTemplate)this.entityManager.find(ShiftTemplate.class, (Object)id);
        if (shiftTemplate == null) {
            throw new EntityNotFoundException("No ShiftTemplate entity found with ID (" + id + ").");
        }
        this.validateTenantIdParameter(tenantId, (AbstractPersistable)shiftTemplate);
        return new ShiftTemplateView(rosterState.getRotationLength(), shiftTemplate);
    }

    @Transactional
    public ShiftTemplateView addShiftTemplate(Integer tenantId, ShiftTemplateView shiftTemplateView) {
        RosterState rosterState = this.rosterRestService.getRosterState(tenantId);
        Spot spot = this.spotRestService.getSpot(tenantId, shiftTemplateView.getSpotId());
        Employee employee = shiftTemplateView.getRotationEmployeeId() != null ? this.employeeRestService.getEmployee(tenantId, shiftTemplateView.getRotationEmployeeId()) : null;
        ShiftTemplate shiftTemplate = new ShiftTemplate(rosterState.getRotationLength(), shiftTemplateView, spot, employee);
        this.validateTenantIdParameter(tenantId, (AbstractPersistable)shiftTemplate);
        this.entityManager.persist((Object)shiftTemplate);
        return new ShiftTemplateView(rosterState.getRotationLength(), shiftTemplate);
    }

    @Transactional
    public ShiftTemplateView updateShiftTemplate(Integer tenantId, ShiftTemplateView shiftTemplateView) {
        RosterState rosterState = this.rosterRestService.getRosterState(tenantId);
        Spot spot = this.spotRestService.getSpot(tenantId, shiftTemplateView.getSpotId());
        Employee employee = shiftTemplateView.getRotationEmployeeId() != null ? this.employeeRestService.getEmployee(tenantId, shiftTemplateView.getRotationEmployeeId()) : null;
        ShiftTemplate shiftTemplate = new ShiftTemplate(rosterState.getRotationLength(), shiftTemplateView, spot, employee);
        this.validateTenantIdParameter(tenantId, (AbstractPersistable)shiftTemplate);
        shiftTemplate = (ShiftTemplate)this.entityManager.merge((Object)shiftTemplate);
        this.entityManager.flush();
        return new ShiftTemplateView(rosterState.getRotationLength(), shiftTemplate);
    }

    @Transactional
    public Boolean removeShiftTemplate(Integer tenantId, Long id) {
        ShiftTemplate shiftTemplate = (ShiftTemplate)this.entityManager.find(ShiftTemplate.class, (Object)id);
        if (shiftTemplate == null) {
            return false;
        }
        this.validateTenantIdParameter(tenantId, (AbstractPersistable)shiftTemplate);
        this.entityManager.remove((Object)shiftTemplate);
        return true;
    }
}

