/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.server.common.jaxrs;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.optaweb.employeerostering.server.common.jaxrs.OptaWebExceptionMapper;
import org.optaweb.employeerostering.server.common.jaxrs.OptaWebObjectMapperResolver;
import org.optaweb.employeerostering.server.exception.ExceptionDataMapper;
import org.optaweb.employeerostering.shared.exception.ServerSideExceptionInfo;

@RunWith(value=MockitoJUnitRunner.class)
public class OptaWebExceptionMapperTest {
    @InjectMocks
    private OptaWebExceptionMapper tested;
    @Mock
    private OptaWebObjectMapperResolver optaWebObjectMapperResolver;
    @Mock
    private ExceptionDataMapper exceptionDataMapper;

    @Test
    public void testToResponse() {
        ObjectMapper objectMapper = new ObjectMapper();
        Mockito.when((Object)this.exceptionDataMapper.getExceptionDataForExceptionClass(IllegalArgumentException.class)).thenReturn((Object)ExceptionDataMapper.ExceptionData.ILLEGAL_ARGUMENT);
        Mockito.when((Object)this.optaWebObjectMapperResolver.getContext((Class)ArgumentMatchers.any())).thenReturn((Object)objectMapper);
        String EXCEPTION_MESSAGE = "TEST";
        Response response = this.tested.toResponse((Exception)new IllegalArgumentException("TEST"));
        Assert.assertEquals((Object)ExceptionDataMapper.ExceptionData.ILLEGAL_ARGUMENT.getStatusCode(), (Object)response.getStatusInfo());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getMediaType());
        try {
            ServerSideExceptionInfo serverSideException = (ServerSideExceptionInfo)objectMapper.readValue(response.getEntity().toString(), ServerSideExceptionInfo.class);
            Assert.assertEquals((Object)"TEST", (Object)serverSideException.getExceptionMessage());
            Assert.assertEquals((Object)IllegalArgumentException.class.getName(), (Object)serverSideException.getExceptionClass());
            Assert.assertEquals((Object)ExceptionDataMapper.ExceptionData.ILLEGAL_ARGUMENT.getI18nKey(), (Object)serverSideException.getI18nKey());
        }
        catch (IOException e) {
            Assert.fail((String)e.toString());
        }
    }

    @Test
    public void testToResponseError() {
        String ERROR_MSG = "BAD STATE";
        String EXPECTED_MSG = "There was an issue with retrieving the root cause: BAD STATE\nMore information can be found in the server log.";
        ObjectMapper mockObjectMapper = (ObjectMapper)Mockito.mock(ObjectMapper.class);
        JsonProcessingException jsonProcessingException = (JsonProcessingException)Mockito.mock(JsonProcessingException.class);
        Mockito.when((Object)this.exceptionDataMapper.getExceptionDataForExceptionClass(IllegalArgumentException.class)).thenReturn((Object)ExceptionDataMapper.ExceptionData.ENTITY_NOT_FOUND);
        try {
            Mockito.when((Object)jsonProcessingException.getMessage()).thenReturn((Object)"BAD STATE");
            Mockito.when((Object)mockObjectMapper.writeValueAsString(ArgumentMatchers.any())).thenThrow(new Throwable[]{jsonProcessingException});
        }
        catch (Exception e) {
            Assert.fail((String)e.toString());
        }
        Mockito.when((Object)this.optaWebObjectMapperResolver.getContext((Class)ArgumentMatchers.any())).thenReturn((Object)mockObjectMapper);
        Response response = this.tested.toResponse((Exception)new IllegalArgumentException());
        Assert.assertEquals((Object)Response.Status.INTERNAL_SERVER_ERROR, (Object)response.getStatusInfo());
        Assert.assertEquals((Object)MediaType.TEXT_PLAIN_TYPE, (Object)response.getMediaType());
        Assert.assertEquals((Object)"There was an issue with retrieving the root cause: BAD STATE\nMore information can be found in the server log.", (Object)response.getEntity().toString());
    }
}

