/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.server.tenant;

import java.time.ZoneId;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.transaction.Transactional;
import org.optaweb.employeerostering.server.common.AbstractRestServiceImpl;
import org.optaweb.employeerostering.shared.roster.RosterState;
import org.optaweb.employeerostering.shared.tenant.RosterParametrization;
import org.optaweb.employeerostering.shared.tenant.Tenant;
import org.optaweb.employeerostering.shared.tenant.TenantRestService;

public class TenantRestServiceImpl
extends AbstractRestServiceImpl
implements TenantRestService {
    @PersistenceContext
    private EntityManager entityManager;

    @Transactional
    public List<Tenant> getTenantList() {
        return this.entityManager.createNamedQuery("Tenant.findAll", Tenant.class).getResultList();
    }

    @Transactional
    public Tenant getTenant(Integer id) {
        Tenant tenant = (Tenant)this.entityManager.find(Tenant.class, (Object)id);
        return tenant;
    }

    @Transactional
    public Tenant addTenant(RosterState intialRosterState) {
        this.entityManager.persist((Object)intialRosterState.getTenant());
        intialRosterState.setTenantId(intialRosterState.getTenant().getId());
        RosterParametrization rosterParametriation = new RosterParametrization();
        rosterParametriation.setTenantId(intialRosterState.getTenant().getId());
        this.entityManager.persist((Object)intialRosterState);
        this.entityManager.persist((Object)rosterParametriation);
        return intialRosterState.getTenant();
    }

    @Transactional
    public Boolean removeTenant(Integer tenantId) {
        Tenant tenant = this.getTenant(tenantId);
        if (tenant == null) {
            throw new IllegalArgumentException("There is no tenant with id (" + tenantId + ").");
        }
        this.entityManager.createNamedQuery("Shift.deleteForTenant").setParameter("tenantId", (Object)tenantId).executeUpdate();
        this.entityManager.createNamedQuery("EmployeeAvailability.deleteForTenant").setParameter("tenantId", (Object)tenantId).executeUpdate();
        this.entityManager.createNamedQuery("ShiftTemplate.deleteForTenant").setParameter("tenantId", (Object)tenantId).executeUpdate();
        this.entityManager.createNamedQuery("Employee.deleteForTenant").setParameter("tenantId", (Object)tenantId).executeUpdate();
        this.entityManager.createNamedQuery("Spot.deleteForTenant").setParameter("tenantId", (Object)tenantId).executeUpdate();
        this.entityManager.createNamedQuery("Skill.deleteForTenant").setParameter("tenantId", (Object)tenantId).executeUpdate();
        this.entityManager.createNamedQuery("RosterParametrization.deleteForTenant").setParameter("tenantId", (Object)tenantId).executeUpdate();
        this.entityManager.createNamedQuery("RosterState.deleteForTenant").setParameter("tenantId", (Object)tenantId).executeUpdate();
        this.entityManager.remove((Object)tenant);
        return true;
    }

    @Transactional
    public RosterParametrization updateRosterParametrization(RosterParametrization rosterParametrization) {
        return (RosterParametrization)this.entityManager.merge((Object)rosterParametrization);
    }

    public RosterParametrization getRosterParametrization(Integer tenantId) {
        return (RosterParametrization)this.entityManager.createNamedQuery("RosterParametrization.find", RosterParametrization.class).setParameter("tenantId", (Object)tenantId).getSingleResult();
    }

    public List<ZoneId> getSupportedTimezones() {
        return ZoneId.getAvailableZoneIds().stream().sorted().map(zoneId -> ZoneId.of(zoneId)).collect(Collectors.toList());
    }
}

