/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.shared.common;

import com.google.gwt.core.client.JsDate;
import com.google.gwt.i18n.shared.DateTimeFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Date;

public class GwtJavaTimeWorkaroundUtil {
    public static LocalDateTime toLocalDateTime(OffsetDateTime time) {
        return LocalDateTime.of(GwtJavaTimeWorkaroundUtil.toLocalDate(time), GwtJavaTimeWorkaroundUtil.toLocalTime(time));
    }

    public static LocalDateTime toLocalDateTimeInZone(OffsetDateTime dateTime, ZoneId zoneId) {
        return LocalDateTime.ofEpochSecond(dateTime.toEpochSecond(), dateTime.getNano(), zoneId.getRules().getOffset(dateTime.toInstant()));
    }

    public static LocalDate toLocalDate(OffsetDateTime time) {
        return LocalDate.of(time.getYear(), time.getMonthValue(), time.getDayOfMonth());
    }

    public static LocalTime toLocalTime(OffsetDateTime time) {
        return GwtJavaTimeWorkaroundUtil.toLocalTime(time.toOffsetTime());
    }

    public static LocalTime toLocalTime(OffsetTime time) {
        return LocalTime.of(time.getHour(), time.getMinute(), time.getSecond(), time.getNano());
    }

    public static OffsetDateTime toOffsetDateTime(LocalDate date, OffsetTime offsetTime) {
        return OffsetDateTime.of(date.atTime(GwtJavaTimeWorkaroundUtil.toLocalTime(offsetTime)), offsetTime.getOffset());
    }

    public static boolean doTimeslotsIntersect(OffsetDateTime start1, OffsetDateTime end1, OffsetDateTime start2, OffsetDateTime end2) {
        return !start1.isAfter(end2) && !end1.isBefore(start2);
    }

    public static boolean doTimeslotsIntersect(LocalDate date, OffsetTime start1, OffsetTime end1, OffsetDateTime start2, OffsetDateTime end2) {
        return GwtJavaTimeWorkaroundUtil.doTimeslotsIntersect(start1.atDate(date), end1.atDate(date), start2, end2);
    }

    public static Date toDate(OffsetDateTime offsetDateTime) {
        DateTimeFormat offsetDateTimeConvertor = DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.ISO_8601);
        return offsetDateTimeConvertor.parse(GwtJavaTimeWorkaroundUtil.offsetDateTimeToISO(offsetDateTime));
    }

    public static Date toDateAsLocalTime(OffsetDateTime offsetDateTime) {
        return GwtJavaTimeWorkaroundUtil.toDate(GwtJavaTimeWorkaroundUtil.toLocalDateTime(offsetDateTime));
    }

    public static Date toDate(LocalDateTime localDateTime) {
        DateTimeFormat offsetDateTimeConvertor = DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.ISO_8601);
        return offsetDateTimeConvertor.parse(GwtJavaTimeWorkaroundUtil.offsetDateTimeToISO(OffsetDateTime.of(localDateTime, ZoneOffset.ofTotalSeconds(60 * GwtJavaTimeWorkaroundUtil.getOffsetInMinutes(localDateTime.toLocalDate(), ZoneOffset.UTC)))));
    }

    public static String offsetDateTimeToISO(OffsetDateTime offsetDateTime) {
        return GwtJavaTimeWorkaroundUtil.toLocalDate(offsetDateTime).toString() + "T" + GwtJavaTimeWorkaroundUtil.getGWTTime(GwtJavaTimeWorkaroundUtil.toLocalTime(offsetDateTime)) + offsetDateTime.getOffset().toString();
    }

    public static String getGWTTime(LocalTime time) {
        return time.getHour() + ":" + time.getMinute() + ":" + time.getSecond() + "." + time.getNano();
    }

    public static int getOffsetInMinutes(LocalDate date, ZoneOffset offset) {
        return offset.getTotalSeconds() / 60 - JsDate.create((int)date.getYear(), (int)date.getMonthValue(), (int)date.getDayOfMonth()).getTimezoneOffset();
    }
}

