/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.shared.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;

public class TimeSlotTable<T> {
    List<BoundaryPoint> startPointList = new ArrayList<BoundaryPoint>();
    List<BoundaryPoint> endPointList = new ArrayList<BoundaryPoint>();
    Map<UUID, TimeSlot<T>> intervalDataMap = new HashMap<UUID, TimeSlot<T>>();

    private int getFirstIndexOf(int index, BoundaryPoint o) {
        List<BoundaryPoint> intervalPoints;
        if (index < 0) {
            return -(index + 1);
        }
        List<BoundaryPoint> list = intervalPoints = o.isStartPoint() ? this.startPointList : this.endPointList;
        while (index > 0 && intervalPoints.get(index - 1).equals(o)) {
            --index;
        }
        return index;
    }

    private int getLastIndexOf(int index, BoundaryPoint o) {
        List<BoundaryPoint> intervalPoints;
        if (index < 0) {
            return -(index + 1);
        }
        List<BoundaryPoint> list = intervalPoints = o.isStartPoint() ? this.startPointList : this.endPointList;
        while (index < intervalPoints.size() - 1 && intervalPoints.get(index + 1).equals(o)) {
            ++index;
        }
        return index;
    }

    public UUID add(long start, long end, T data) {
        UUID uuid = UUID.randomUUID();
        BoundaryPoint startPoint = new BoundaryPoint(start, true, uuid);
        BoundaryPoint endPoint = new BoundaryPoint(end, false, uuid);
        int insertionPoint = this.getFirstIndexOf(Collections.binarySearch(this.startPointList, startPoint), startPoint);
        this.startPointList.add(insertionPoint, startPoint);
        insertionPoint = this.getLastIndexOf(Collections.binarySearch(this.endPointList, endPoint), endPoint);
        this.endPointList.add(insertionPoint, endPoint);
        this.intervalDataMap.put(uuid, new TimeSlot<T>(startPoint, endPoint, data));
        return uuid;
    }

    public UUID get(T data) {
        for (Map.Entry<UUID, TimeSlot<T>> e : this.intervalDataMap.entrySet()) {
            if (!e.getValue().getData().equals(data)) continue;
            return e.getKey();
        }
        return null;
    }

    public void update(UUID uuid, T newData) {
        TimeSlot<T> orig = this.intervalDataMap.get(uuid);
        this.intervalDataMap.put(uuid, new TimeSlot<T>(orig.getStartPoint(), orig.getEndPoint(), newData));
    }

    public void remove(TimeSlot<T> timeSlot) {
        BoundaryPoint startPoint = timeSlot.getStartPoint();
        BoundaryPoint endPoint = timeSlot.getEndPoint();
        int startIndex = this.getLastIndexOf(Collections.binarySearch(this.startPointList, startPoint), startPoint);
        int endIndex = this.getLastIndexOf(Collections.binarySearch(this.endPointList, endPoint), endPoint);
        while (!this.startPointList.get(startIndex).getUUID().equals(startPoint.getUUID())) {
            --startIndex;
        }
        while (!this.endPointList.get(endIndex).getUUID().equals(endPoint.getUUID())) {
            --endIndex;
        }
        this.intervalDataMap.remove(timeSlot.getUUID());
        this.startPointList.remove(startIndex);
        this.endPointList.remove(endIndex);
    }

    public void remove(UUID uuid) {
        if (!this.intervalDataMap.keySet().contains(uuid)) {
            StringBuilder errorMsg = new StringBuilder("UUID \"" + uuid + "\" was not found:\nUUIDS: {");
            this.intervalDataMap.keySet().forEach(e -> errorMsg.append(e.toString() + ";"));
            errorMsg.append("}");
            throw new RuntimeException(errorMsg.toString());
        }
        this.remove(this.intervalDataMap.get(uuid));
    }

    public UUID remove(long start, long end) {
        int endIndex;
        BoundaryPoint startPoint = new BoundaryPoint(start, true, null);
        BoundaryPoint endPoint = new BoundaryPoint(end, false, null);
        int startIndex = this.getLastIndexOf(Collections.binarySearch(this.startPointList, startPoint), startPoint);
        int pairIndex = endIndex = this.getLastIndexOf(Collections.binarySearch(this.endPointList, endPoint), endPoint);
        UUID uuid = this.startPointList.get(startIndex).getUUID();
        while (!this.startPointList.get(startIndex).getUUID().equals(this.endPointList.get(pairIndex).getUUID())) {
            uuid = this.startPointList.get(startIndex).getUUID();
            boolean found = false;
            while (pairIndex >= 0 && this.endPointList.get(pairIndex).equals(endPoint)) {
                if (this.endPointList.get(pairIndex).getUUID().equals(uuid)) {
                    found = true;
                    break;
                }
                --pairIndex;
            }
            if (found) break;
            pairIndex = endIndex;
            --startIndex;
        }
        uuid = this.startPointList.get(startIndex).getUUID();
        this.intervalDataMap.remove(uuid);
        this.startPointList.remove(startIndex);
        this.endPointList.remove(pairIndex);
        return uuid;
    }

    public List<List<TimeSlot<T>>> getTimeSlotsAsGrid() {
        return new TimeSlotIterator<T>(this.startPointList, this.intervalDataMap).getTimeSlotsAsGrid();
    }

    public List<List<TimeSlot<T>>> getTimeSlotsAsGrid(long start, long end) {
        BoundaryPoint startPoint = new BoundaryPoint(end, true, null);
        BoundaryPoint endPoint = new BoundaryPoint(start, false, null);
        int indexOfFirstEndPointAfterStart = this.getFirstIndexOf(Collections.binarySearch(this.endPointList, endPoint), endPoint);
        int indexOfLastStartPointBeforeEnd = this.getLastIndexOf(Collections.binarySearch(this.startPointList, startPoint), startPoint);
        Set endPointsAfterStartUUID = this.endPointList.subList(indexOfFirstEndPointAfterStart, this.endPointList.size()).stream().map(e -> e.getUUID()).collect(Collectors.toSet());
        List<BoundaryPoint> startPointsBeforeEnd = this.startPointList.subList(0, indexOfLastStartPointBeforeEnd).stream().filter(s -> endPointsAfterStartUUID.contains(s.getUUID())).collect(Collectors.toList());
        return new TimeSlotIterator<T>(startPointsBeforeEnd, this.intervalDataMap).getTimeSlotsAsGrid();
    }

    public static final class BoundaryPoint
    implements Comparable<BoundaryPoint> {
        final long position;
        final boolean isStartOfBoundary;
        final UUID uuid;

        public BoundaryPoint(long pos, boolean isStart, UUID uuid) {
            this.position = pos;
            this.isStartOfBoundary = isStart;
            this.uuid = uuid;
        }

        public boolean isStartPoint() {
            return this.isStartOfBoundary;
        }

        public boolean isEndPoint() {
            return !this.isStartOfBoundary;
        }

        public long getPosition() {
            return this.position;
        }

        public UUID getUUID() {
            return this.uuid;
        }

        public boolean equals(Object o) {
            if (o instanceof BoundaryPoint) {
                BoundaryPoint other = (BoundaryPoint)o;
                return this.position == other.position && this.isStartOfBoundary == other.isStartOfBoundary;
            }
            return false;
        }

        public int hashCode() {
            return Long.hashCode(this.position) ^ Boolean.hashCode(this.isStartOfBoundary);
        }

        @Override
        public int compareTo(BoundaryPoint o) {
            int compareToResult = Long.compare(this.position, o.position);
            if (compareToResult != 0) {
                return compareToResult;
            }
            if (this.isStartOfBoundary == o.isStartOfBoundary) {
                return 0;
            }
            if (this.isStartOfBoundary) {
                return -1;
            }
            return 1;
        }
    }

    public static final class TimeSlot<T> {
        final BoundaryPoint startPoint;
        final BoundaryPoint endPoint;
        final T data;

        public TimeSlot(BoundaryPoint start, BoundaryPoint end, T data) {
            this.startPoint = start;
            this.endPoint = end;
            this.data = data;
        }

        public BoundaryPoint getStartPoint() {
            return this.startPoint;
        }

        public BoundaryPoint getEndPoint() {
            return this.endPoint;
        }

        public long getLength() {
            return this.endPoint.getPosition() - this.startPoint.getPosition();
        }

        public UUID getUUID() {
            return this.startPoint.getUUID();
        }

        public T getData() {
            return this.data;
        }

        public int hashCode() {
            return this.getUUID().hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof TimeSlot)) {
                return false;
            }
            TimeSlot other = (TimeSlot)obj;
            return this.getUUID().equals(other.getUUID());
        }
    }

    private static final class TimeSlotIterator<T>
    implements Iterator<TimeSlot<T>> {
        List<BoundaryPoint> startPoints;
        Map<UUID, TimeSlot<T>> intervalData;
        int index;
        int nextDepth;
        List<TimeSlot<T>> prev;
        TimeSlot<T> next;

        public TimeSlotIterator(List<BoundaryPoint> startPoints, Map<UUID, TimeSlot<T>> intervalData) {
            this.startPoints = startPoints;
            this.intervalData = intervalData;
            this.index = 0;
            this.nextDepth = 0;
            this.prev = new ArrayList<TimeSlot<T>>();
            this.next();
        }

        public List<List<TimeSlot<T>>> getTimeSlotsAsGrid() {
            ArrayList<List<TimeSlot<T>>> out = new ArrayList<List<TimeSlot<T>>>();
            while (this.hasNext()) {
                int depth = this.nextDepth;
                while (out.size() <= depth) {
                    out.add(new ArrayList());
                }
                Object timeSlot = this.next();
                ((List)out.get(depth)).add(timeSlot);
            }
            return out;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public TimeSlot<T> next() {
            TimeSlot<T> out = this.next;
            if (this.index < this.startPoints.size()) {
                int depth;
                BoundaryPoint startPoint = this.startPoints.get(this.index);
                this.next = this.intervalData.get(startPoint.getUUID());
                BoundaryPoint endPoint = this.next.getEndPoint();
                for (depth = 0; depth < this.prev.size() && startPoint.getPosition() < this.prev.get(depth).getEndPoint().getPosition() && endPoint.getPosition() > this.prev.get(depth).getStartPoint().getPosition(); ++depth) {
                }
                this.nextDepth = depth;
                if (this.prev.size() <= depth) {
                    this.prev.add(this.next);
                } else {
                    this.prev.set(depth, this.next);
                }
                ++this.index;
            } else {
                this.next = null;
            }
            return out;
        }
    }
}

